/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TaskAttemptListenerImpl;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.event.Event;
import org.junit.Assert;
import org.junit.Test;

public class TestFail {
    @Test
    public void testFailTask() throws Exception {
        MockFirstFailingAttemptMRApp app = new MockFirstFailingAttemptMRApp(1, 0);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (long)1L, (long)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.SUCCEEDED, (Object)task.getReport().getTaskState());
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"Num attempts is not correct", (long)2L, (long)attempts.size());
        Iterator it = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.FAILED, (Object)((TaskAttempt)it.next()).getReport().getTaskAttemptState());
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.SUCCEEDED, (Object)((TaskAttempt)it.next()).getReport().getTaskAttemptState());
    }

    @Test
    public void testMapFailureMaxPercent() throws Exception {
        MockFirstFailingTaskMRApp app = new MockFirstFailingTaskMRApp(4, 0);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 2);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        conf.setInt("mapreduce.map.failures.maxpercent", 20);
        conf.setInt("mapreduce.map.maxattempts", 1);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        app = new MockFirstFailingTaskMRApp(4, 0);
        conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 2);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        conf.setInt("mapreduce.map.failures.maxpercent", 25);
        conf.setInt("mapreduce.map.maxattempts", 1);
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testReduceFailureMaxPercent() throws Exception {
        MockFirstFailingTaskMRApp app = new MockFirstFailingTaskMRApp(2, 4);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.maxattempts", 2);
        conf.setInt("mapreduce.map.failures.maxpercent", 50);
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.failures.maxpercent", 20);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        app = new MockFirstFailingTaskMRApp(2, 4);
        conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.maxattempts", 2);
        conf.setInt("mapreduce.map.failures.maxpercent", 50);
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.failures.maxpercent", 25);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testTimedOutTask() throws Exception {
        TimeOutTaskMRApp app = new TimeOutTaskMRApp(1, 0);
        Configuration conf = new Configuration();
        int maxAttempts = 2;
        conf.setInt("mapreduce.map.maxattempts", maxAttempts);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (long)1L, (long)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.FAILED, (Object)task.getReport().getTaskState());
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"Num attempts is not correct", (long)maxAttempts, (long)attempts.size());
        for (TaskAttempt attempt : attempts.values()) {
            Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.FAILED, (Object)attempt.getReport().getTaskAttemptState());
        }
    }

    @Test
    public void testTaskFailWithUnusedContainer() throws Exception {
        MRAppWithFailingTaskAndUnusedContainer app = new MRAppWithFailingTaskAndUnusedContainer();
        Configuration conf = new Configuration();
        int maxAttempts = 1;
        conf.setInt("mapreduce.map.maxattempts", maxAttempts);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (long)1L, (long)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        app.waitForState(task, TaskState.SCHEDULED);
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"Num attempts is not correct", (long)maxAttempts, (long)attempts.size());
        TaskAttempt attempt = (TaskAttempt)attempts.values().iterator().next();
        app.waitForInternalState((TaskAttemptImpl)attempt, TaskAttemptStateInternal.ASSIGNED);
        app.getDispatcher().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_CONTAINER_COMPLETED));
        app.waitForState(job, JobState.FAILED);
    }

    public static void main(String[] args) throws Exception {
        TestFail t = new TestFail();
        t.testFailTask();
        t.testTimedOutTask();
        t.testMapFailureMaxPercent();
        t.testReduceFailureMaxPercent();
        t.testTaskFailWithUnusedContainer();
    }

    static class MockFirstFailingAttemptMRApp
    extends MRApp {
        MockFirstFailingAttemptMRApp(int maps, int reduces) {
            super(maps, reduces, true, "MockFirstFailingAttemptMRApp", true);
        }

        @Override
        protected void attemptLaunched(TaskAttemptId attemptID) {
            if (attemptID.getTaskId().getId() == 0 && attemptID.getId() == 0) {
                this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_FAILMSG));
            } else {
                this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_DONE));
            }
        }
    }

    static class MockFirstFailingTaskMRApp
    extends MRApp {
        MockFirstFailingTaskMRApp(int maps, int reduces) {
            super(maps, reduces, true, "MockFirstFailingTaskMRApp", true);
        }

        @Override
        protected void attemptLaunched(TaskAttemptId attemptID) {
            if (attemptID.getTaskId().getId() == 0) {
                this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_FAILMSG));
            } else {
                this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_DONE));
            }
        }
    }

    static class TimeOutTaskMRApp
    extends MRApp {
        TimeOutTaskMRApp(int maps, int reduces) {
            super(maps, reduces, false, "TimeOutTaskMRApp", true);
        }

        @Override
        protected TaskAttemptListener createTaskAttemptListener(AppContext context) {
            return new TaskAttemptListenerImpl(this.getContext(), null, null){

                public void startRpcServer() {
                }

                public void stopRpcServer() {
                }

                public InetSocketAddress getAddress() {
                    return NetUtils.createSocketAddr((String)"localhost", (int)1234);
                }

                protected void serviceInit(Configuration conf) throws Exception {
                    conf.setInt("mapreduce.task.timeout", 1000);
                    conf.setInt("mapreduce.task.timeout.check-interval-ms", 1000);
                    super.serviceInit(conf);
                }
            };
        }
    }

    static class MRAppWithFailingTaskAndUnusedContainer
    extends MRApp {
        public MRAppWithFailingTaskAndUnusedContainer() {
            super(1, 0, false, "TaskFailWithUnsedContainer", true);
        }

        @Override
        protected ContainerLauncher createContainerLauncher(AppContext context) {
            return new ContainerLauncherImpl(context){

                public void handle(ContainerLauncherEvent event) {
                    switch ((ContainerLauncher.EventType)event.getType()) {
                        case CONTAINER_REMOTE_LAUNCH: {
                            super.handle(event);
                            break;
                        }
                        case CONTAINER_REMOTE_CLEANUP: {
                            MRAppWithFailingTaskAndUnusedContainer.this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(event.getTaskAttemptID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData getCMProxy(String containerMgrBindAddr, ContainerId containerId) throws IOException {
                    try {
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            ((Object)((Object)this)).wait();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
        }
    }
}

