/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.local;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.local.LocalContainerAllocator;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestLocalContainerAllocator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMConnectionRetry() throws Exception {
        Configuration conf = new Configuration();
        StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator();
        lca.init(conf);
        lca.start();
        try {
            lca.heartbeat();
            Assert.fail((String)"heartbeat was supposed to throw");
        }
        catch (YarnException e) {
        }
        finally {
            lca.stop();
        }
        conf.setLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 0L);
        lca = new StubbedLocalContainerAllocator();
        lca.init(conf);
        lca.start();
        try {
            lca.heartbeat();
            Assert.fail((String)"heartbeat was supposed to throw");
        }
        catch (YarnRuntimeException yarnRuntimeException) {
        }
        finally {
            lca.stop();
        }
    }

    private static class StubbedLocalContainerAllocator
    extends LocalContainerAllocator {
        public StubbedLocalContainerAllocator() {
            super((ClientService)Mockito.mock(ClientService.class), StubbedLocalContainerAllocator.createAppContext(), "nmhost", 1, 2, null);
        }

        protected void register() {
        }

        protected void unregister() {
        }

        protected void startAllocatorThread() {
            this.allocatorThread = new Thread();
        }

        protected ApplicationMasterProtocol createSchedulerProxy() {
            ApplicationMasterProtocol scheduler = (ApplicationMasterProtocol)Mockito.mock(ApplicationMasterProtocol.class);
            try {
                Mockito.when((Object)scheduler.allocate((AllocateRequest)Matchers.isA(AllocateRequest.class))).thenThrow(new Throwable[]{RPCUtil.getRemoteException((Throwable)new IOException("forcefail"))});
            }
            catch (YarnException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return scheduler;
        }

        private static AppContext createAppContext() {
            ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
            ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            Job job = (Job)Mockito.mock(Job.class);
            EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
            Mockito.when((Object)ctx.getApplicationID()).thenReturn((Object)appId);
            Mockito.when((Object)ctx.getApplicationAttemptId()).thenReturn((Object)attemptId);
            Mockito.when((Object)ctx.getJob((JobId)Matchers.isA(JobId.class))).thenReturn((Object)job);
            Mockito.when((Object)ctx.getClusterInfo()).thenReturn((Object)new ClusterInfo(Resource.newInstance((int)10240, (int)1)));
            Mockito.when((Object)ctx.getEventHandler()).thenReturn((Object)eventHandler);
            return ctx;
        }
    }
}

