/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.TestContainerLauncherImpl;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestContainerLauncherImpl {
    static final Log LOG = LogFactory.getLog(TestContainerLauncherImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private Map<String, ByteBuffer> serviceResponse = new HashMap();

    @Before
    public void setup() throws IOException {
        this.serviceResponse.clear();
        this.serviceResponse.put("mapreduce_shuffle", ShuffleHandler.serializeMetaData((int)80));
    }

    public static ContainerId makeContainerId(long ts, int appId, int attemptId, int id) {
        return ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)ts, (int)appId), (int)attemptId), (int)id);
    }

    public static TaskAttemptId makeTaskAttemptId(long ts, int appId, int taskId, TaskType taskType, int id) {
        ApplicationId aID = ApplicationId.newInstance((long)ts, (int)appId);
        JobId jID = MRBuilderUtils.newJobId((ApplicationId)aID, (int)id);
        TaskId tID = MRBuilderUtils.newTaskId((JobId)jID, (int)taskId, (TaskType)taskType);
        return MRBuilderUtils.newTaskAttemptId((TaskId)tID, (int)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testHandle() throws Exception {
        LOG.info((Object)"STARTING testHandle");
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        String cmAddress = "127.0.0.1:8000";
        ContainerManagementProtocol mockCM = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, mockCM);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            StartContainersResponse startResp = (StartContainersResponse)recordFactory.newRecordInstance(StartContainersResponse.class);
            startResp.setAllServicesMetaData(this.serviceResponse);
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockCM.startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class))).thenReturn((Object)startResp);
            Mockito.when((Object)mockLaunchEvent.getContainerToken()).thenReturn((Object)this.createNewContainerToken(contId, cmAddress));
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            ut.waitForPoolToIdle();
            ((ContainerManagementProtocol)Mockito.verify((Object)mockCM)).startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class));
            LOG.info((Object)"inserting cleanup event");
            ContainerLauncherEvent mockCleanupEvent = (ContainerLauncherEvent)Mockito.mock(ContainerLauncherEvent.class);
            Mockito.when((Object)mockCleanupEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP);
            Mockito.when((Object)mockCleanupEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockCleanupEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockCleanupEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            ut.handle(mockCleanupEvent);
            ut.waitForPoolToIdle();
            ((ContainerManagementProtocol)Mockito.verify((Object)mockCM)).stopContainers((StopContainersRequest)Matchers.any(StopContainersRequest.class));
        }
        finally {
            ut.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testOutOfOrder() throws Exception {
        LOG.info((Object)"STARTING testOutOfOrder");
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        ContainerManagementProtocol mockCM = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, mockCM);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            String cmAddress = "127.0.0.1:8000";
            StartContainersResponse startResp = (StartContainersResponse)recordFactory.newRecordInstance(StartContainersResponse.class);
            startResp.setAllServicesMetaData(this.serviceResponse);
            LOG.info((Object)"inserting cleanup event");
            ContainerLauncherEvent mockCleanupEvent = (ContainerLauncherEvent)Mockito.mock(ContainerLauncherEvent.class);
            Mockito.when((Object)mockCleanupEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP);
            Mockito.when((Object)mockCleanupEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockCleanupEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockCleanupEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            ut.handle(mockCleanupEvent);
            ut.waitForPoolToIdle();
            ((ContainerManagementProtocol)Mockito.verify((Object)mockCM, (VerificationMode)Mockito.never())).stopContainers((StopContainersRequest)Matchers.any(StopContainersRequest.class));
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockCM.startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class))).thenReturn((Object)startResp);
            Mockito.when((Object)mockLaunchEvent.getContainerToken()).thenReturn((Object)this.createNewContainerToken(contId, cmAddress));
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            ut.waitForPoolToIdle();
            ((ContainerManagementProtocol)Mockito.verify((Object)mockCM, (VerificationMode)Mockito.never())).startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class));
        }
        finally {
            ut.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMyShutdown() throws Exception {
        LOG.info((Object)"in test Shutdown");
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        ContainerManagementProtocol mockCM = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, mockCM);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            String cmAddress = "127.0.0.1:8000";
            StartContainersResponse startResp = (StartContainersResponse)recordFactory.newRecordInstance(StartContainersResponse.class);
            startResp.setAllServicesMetaData(this.serviceResponse);
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockCM.startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class))).thenReturn((Object)startResp);
            Mockito.when((Object)mockLaunchEvent.getContainerToken()).thenReturn((Object)this.createNewContainerToken(contId, cmAddress));
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            ut.waitForPoolToIdle();
            ((ContainerManagementProtocol)Mockito.verify((Object)mockCM)).startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class));
        }
        finally {
            ut.stop();
            ((ContainerManagementProtocol)Mockito.verify((Object)mockCM)).stopContainers((StopContainersRequest)Matchers.any(StopContainersRequest.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testContainerCleaned() throws Exception {
        LOG.info((Object)"STARTING testContainerCleaned");
        CyclicBarrier startLaunchBarrier = new CyclicBarrier(2);
        CyclicBarrier completeLaunchBarrier = new CyclicBarrier(2);
        AppContext mockContext = (AppContext)Mockito.mock(AppContext.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mockContext.getEventHandler()).thenReturn((Object)mockEventHandler);
        ContainerManagerForTest mockCM = new ContainerManagerForTest(startLaunchBarrier, completeLaunchBarrier);
        ContainerLauncherImplUnderTest ut = new ContainerLauncherImplUnderTest(mockContext, (ContainerManagementProtocol)mockCM);
        Configuration conf = new Configuration();
        ut.init(conf);
        ut.start();
        try {
            ContainerId contId = TestContainerLauncherImpl.makeContainerId((long)0L, (int)0, (int)0, (int)1);
            TaskAttemptId taskAttemptId = TestContainerLauncherImpl.makeTaskAttemptId((long)0L, (int)0, (int)0, (TaskType)TaskType.MAP, (int)0);
            String cmAddress = "127.0.0.1:8000";
            StartContainersResponse startResp = (StartContainersResponse)recordFactory.newRecordInstance(StartContainersResponse.class);
            startResp.setAllServicesMetaData(this.serviceResponse);
            LOG.info((Object)"inserting launch event");
            ContainerRemoteLaunchEvent mockLaunchEvent = (ContainerRemoteLaunchEvent)Mockito.mock(ContainerRemoteLaunchEvent.class);
            Mockito.when((Object)mockLaunchEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH);
            Mockito.when((Object)mockLaunchEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockLaunchEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockLaunchEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            Mockito.when((Object)mockLaunchEvent.getContainerToken()).thenReturn((Object)this.createNewContainerToken(contId, cmAddress));
            ut.handle((ContainerLauncherEvent)mockLaunchEvent);
            startLaunchBarrier.await();
            LOG.info((Object)"inserting cleanup event");
            ContainerLauncherEvent mockCleanupEvent = (ContainerLauncherEvent)Mockito.mock(ContainerLauncherEvent.class);
            Mockito.when((Object)mockCleanupEvent.getType()).thenReturn((Object)ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP);
            Mockito.when((Object)mockCleanupEvent.getContainerID()).thenReturn((Object)contId);
            Mockito.when((Object)mockCleanupEvent.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
            Mockito.when((Object)mockCleanupEvent.getContainerMgrAddress()).thenReturn((Object)cmAddress);
            ut.handle(mockCleanupEvent);
            completeLaunchBarrier.await();
            ut.waitForPoolToIdle();
            ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)mockEventHandler, (VerificationMode)Mockito.atLeast((int)2))).handle((Event)arg.capture());
            boolean containerCleaned = false;
            for (int i = 0; i < arg.getAllValues().size(); ++i) {
                LOG.info((Object)((Event)arg.getAllValues().get(i)).toString());
                Event currentEvent = (Event)arg.getAllValues().get(i);
                if (currentEvent.getType() != TaskAttemptEventType.TA_CONTAINER_CLEANED) continue;
                containerCleaned = true;
            }
            assert (containerCleaned);
        }
        finally {
            ut.stop();
        }
    }

    private Token createNewContainerToken(ContainerId contId, String containerManagerAddr) {
        long currentTime = System.currentTimeMillis();
        return MRApp.newContainerToken((NodeId)NodeId.newInstance((String)"127.0.0.1", (int)1234), (byte[])"password".getBytes(), (ContainerTokenIdentifier)new ContainerTokenIdentifier(contId, containerManagerAddr, "user", Resource.newInstance((int)1024, (int)1), currentTime + 10000L, 123, currentTime, Priority.newInstance((int)0), 0L));
    }
}

