/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksBlockForTest;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestBlocks;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.webapp.view.BlockForTest;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlocks {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    @Test
    public void testConfigurationBlock() throws Exception {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        Job job = (Job)Mockito.mock(Job.class);
        Path path = new Path("conf");
        Configuration configuration = new Configuration();
        configuration.set("Key for test", "Value for test");
        Mockito.when((Object)job.getConfFile()).thenReturn((Object)path);
        Mockito.when((Object)job.loadConfFile()).thenReturn((Object)configuration);
        Mockito.when((Object)ctx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)job);
        ConfBlockForTest configurationBlock = new ConfBlockForTest(this, ctx);
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        configurationBlock.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("Sorry, can't do anything without a JobID"));
        configurationBlock.addParameter("job.id", "job_01_01");
        this.data.reset();
        configurationBlock.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("Key for test"));
        Assert.assertTrue((boolean)this.data.toString().contains("Value for test"));
    }

    @Test
    public void testTasksBlock() throws Exception {
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)0L, (int)1);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(appId);
        TaskIdPBImpl taskId = new TaskIdPBImpl();
        taskId.setId(0);
        taskId.setTaskType(TaskType.MAP);
        taskId.setJobId((JobId)jobId);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getID()).thenReturn((Object)taskId);
        TaskReport report = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)Float.valueOf(report.getProgress())).thenReturn((Object)Float.valueOf(0.7f));
        Mockito.when((Object)report.getTaskState()).thenReturn((Object)TaskState.SUCCEEDED);
        Mockito.when((Object)report.getStartTime()).thenReturn((Object)100001L);
        Mockito.when((Object)report.getFinishTime()).thenReturn((Object)100011L);
        Mockito.when((Object)task.getReport()).thenReturn((Object)report);
        Mockito.when((Object)task.getType()).thenReturn((Object)TaskType.MAP);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        tasks.put(taskId, task);
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks()).thenReturn(tasks);
        App app = new App(ctx);
        app.setJob(job);
        TasksBlockForTest taskBlock = new TasksBlockForTest(app);
        taskBlock.addParameter("task.type", "m");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        taskBlock.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assert.assertTrue((boolean)this.data.toString().contains("70.00"));
        Assert.assertTrue((boolean)this.data.toString().contains("SUCCEEDED"));
        Assert.assertTrue((boolean)this.data.toString().contains("100001"));
        Assert.assertTrue((boolean)this.data.toString().contains("100011"));
    }
}

