/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.TestRecovery;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.junit.Test;

public class TestAMInfos {
    @Test
    public void testAMInfosWithoutRecoveryEnabled() throws Exception {
        int runCount = 0;
        TestRecovery.MRAppWithHistory app = new TestRecovery.MRAppWithHistory(1, 0, false, this.getClass().getName(), true, ++runCount);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        long am1StartTime = ((AMInfo)app.getAllAMInfos().get(0)).getStartTime();
        Assert.assertEquals((String)"No of tasks not correct", (int)1, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask = (Task)it.next();
        app.waitForState(mapTask, TaskState.RUNNING);
        TaskAttempt taskAttempt = (TaskAttempt)mapTask.getAttempts().values().iterator().next();
        app.waitForState(taskAttempt, TaskAttemptState.RUNNING);
        app.stop();
        app = new TestRecovery.MRAppWithHistory(1, 0, false, this.getClass().getName(), false, ++runCount);
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", false);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (int)1, (int)job.getTasks().size());
        it = job.getTasks().values().iterator();
        mapTask = (Task)it.next();
        List amInfos = app.getAllAMInfos();
        Assert.assertEquals((int)2, (int)amInfos.size());
        AMInfo amInfoOne = (AMInfo)amInfos.get(0);
        Assert.assertEquals((long)am1StartTime, (long)amInfoOne.getStartTime());
        app.stop();
    }
}

