/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.MRAppMasterTest;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRAppMaster {
    private static final Log LOG = LogFactory.getLog(TestMRAppMaster.class);
    static String stagingDir = "staging/";
    private static FileContext localFS = null;
    private static final File testDir = new File("target", TestMRAppMaster.class.getName() + "-tmpDir").getAbsoluteFile();

    @BeforeClass
    public static void setup() throws AccessControlException, FileNotFoundException, IllegalArgumentException, IOException {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        File dir = new File(stagingDir);
        stagingDir = dir.getAbsolutePath();
        localFS = FileContext.getLocalFSFileContext();
        localFS.delete(new Path(testDir.getAbsolutePath()), true);
        testDir.mkdir();
    }

    @Before
    public void cleanup() throws IOException {
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    @Test
    public void testMRAppMasterForDifferentUser() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000001";
        String containerIdStr = "container_1317529182569_0004_000001_1";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), 3);
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        Path userPath = new Path(stagingDir, userName);
        Path userStagingPath = new Path(userPath, ".staging");
        Assert.assertEquals((Object)userStagingPath.toString(), (Object)appMaster.stagingDirPath.toString());
    }

    @Test
    public void testMRAppMasterMidLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), 3, false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.ERROR, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    public void testMRAppMasterSuccessLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        Path end = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        fs.create(end).close();
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), 3, false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.SUCCEEDED, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    public void testMRAppMasterFailLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        Path end = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        fs.create(end).close();
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), 3, false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.FAILED, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    public void testMRAppMasterMissingStaging() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), 3, false, false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.ERROR, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test(timeout=30000L)
    public void testMRAppMasterMaxAppAttempts() throws IOException, InterruptedException {
        int[] maxAppAttemtps = new int[]{1, 2, 3};
        Boolean[] expectedBools = new Boolean[]{true, true, false};
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        JobConf conf = new JobConf();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        File stagingDir = new File(MRApps.getStagingAreaDir((Configuration)conf, (String)userName).toString());
        stagingDir.mkdirs();
        for (int i = 0; i < maxAppAttemtps.length; ++i) {
            MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), maxAppAttemtps[i], false, true);
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
            Assert.assertEquals((String)"isLastAMRetry is correctly computed.", (Object)expectedBools[i], (Object)appMaster.isLastAMRetry());
        }
    }

    private static void setNewEnvironmentHack(Map<String, String> newenv) throws Exception {
        try {
            Class<?> cl = Class.forName("java.lang.ProcessEnvironment");
            Field field = cl.getDeclaredField("theEnvironment");
            field.setAccessible(true);
            Map env = (Map)field.get(null);
            env.clear();
            env.putAll(newenv);
            Field ciField = cl.getDeclaredField("theCaseInsensitiveEnvironment");
            ciField.setAccessible(true);
            Map cienv = (Map)ciField.get(null);
            cienv.clear();
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
    }

    @Test
    public void testMRAppMasterCredentials() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        Credentials credentials = new Credentials();
        byte[] identifier = "MyIdentifier".getBytes();
        byte[] password = "MyPassword".getBytes();
        Text kind = new Text("MyTokenKind");
        Text service = new Text("host:port");
        Token myToken = new Token(identifier, password, kind, service);
        Text tokenAlias = new Text("myToken");
        credentials.addToken(tokenAlias, myToken);
        Text appTokenService = new Text("localhost:0");
        Token appToken = new Token(identifier, password, AMRMTokenIdentifier.KIND_NAME, appTokenService);
        credentials.addToken(appTokenService, appToken);
        Text keyAlias = new Text("mySecretKeyAlias");
        credentials.addSecretKey(keyAlias, "mySecretKey".getBytes());
        Token storedToken = credentials.getToken(tokenAlias);
        JobConf conf = new JobConf();
        Path tokenFilePath = new Path(testDir.getAbsolutePath(), "tokens-file");
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.put("HADOOP_TOKEN_FILE_LOCATION", tokenFilePath.toUri().getPath());
        TestMRAppMaster.setNewEnvironmentHack(newEnv);
        credentials.writeTokenStorageFile(tokenFilePath, (Configuration)conf);
        ApplicationId appId = ApplicationId.newInstance((long)12345L, (int)56);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)546);
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        File stagingDir = new File(MRApps.getStagingAreaDir((Configuration)conf, (String)userName).toString());
        stagingDir.mkdirs();
        UserGroupInformation.setLoginUser(null);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), 1, false, true);
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)userName);
        Credentials appMasterCreds = appMaster.getCredentials();
        junit.framework.Assert.assertNotNull((Object)appMasterCreds);
        junit.framework.Assert.assertEquals((int)1, (int)appMasterCreds.numberOfSecretKeys());
        junit.framework.Assert.assertEquals((int)1, (int)appMasterCreds.numberOfTokens());
        Token usedToken = appMasterCreds.getToken(tokenAlias);
        junit.framework.Assert.assertNotNull((Object)usedToken);
        junit.framework.Assert.assertEquals((Object)storedToken, (Object)usedToken);
        byte[] usedKey = appMasterCreds.getSecretKey(keyAlias);
        junit.framework.Assert.assertNotNull((Object)usedKey);
        junit.framework.Assert.assertEquals((String)"mySecretKey", (String)new String(usedKey));
        Credentials confCredentials = conf.getCredentials();
        junit.framework.Assert.assertEquals((int)1, (int)confCredentials.numberOfSecretKeys());
        junit.framework.Assert.assertEquals((int)1, (int)confCredentials.numberOfTokens());
        junit.framework.Assert.assertEquals((Object)storedToken, (Object)confCredentials.getToken(tokenAlias));
        junit.framework.Assert.assertEquals((String)"mySecretKey", (String)new String(confCredentials.getSecretKey(keyAlias)));
        Credentials ugiCredentials = appMaster.getUgi().getCredentials();
        junit.framework.Assert.assertEquals((int)1, (int)ugiCredentials.numberOfSecretKeys());
        junit.framework.Assert.assertEquals((int)2, (int)ugiCredentials.numberOfTokens());
        junit.framework.Assert.assertEquals((Object)storedToken, (Object)ugiCredentials.getToken(tokenAlias));
        junit.framework.Assert.assertEquals((Object)appToken, (Object)ugiCredentials.getToken(appTokenService));
        junit.framework.Assert.assertEquals((String)"mySecretKey", (String)new String(ugiCredentials.getSecretKey(keyAlias)));
    }
}

