/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.TestKill;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.yarn.event.Event;
import org.junit.Test;

public class TestKill {
    @Test
    public void testKillJob() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BlockingMRApp app = new BlockingMRApp(1, 0, latch);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new JobEvent(job.getID(), JobEventType.JOB_KILL));
        latch.countDown();
        app.waitForState(job, JobState.KILLED);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"No of tasks is not correct", (int)1, (int)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.KILLED, (Object)task.getReport().getTaskState());
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"No of attempts is not correct", (int)1, (int)attempts.size());
        Iterator it = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.KILLED, (Object)((TaskAttempt)it.next()).getReport().getTaskAttemptState());
    }

    @Test
    public void testKillTask() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BlockingMRApp app = new BlockingMRApp(2, 0, latch);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"No of tasks is not correct", (int)2, (int)tasks.size());
        Iterator it = tasks.values().iterator();
        Task task1 = (Task)it.next();
        Task task2 = (Task)it.next();
        app.getContext().getEventHandler().handle((Event)new TaskEvent(task1.getID(), TaskEventType.T_KILL));
        latch.countDown();
        app.waitForState(job, JobState.SUCCEEDED);
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.KILLED, (Object)task1.getReport().getTaskState());
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.SUCCEEDED, (Object)task2.getReport().getTaskState());
        Map attempts = task1.getAttempts();
        Assert.assertEquals((String)"No of attempts is not correct", (int)1, (int)attempts.size());
        Iterator iter = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.KILLED, (Object)((TaskAttempt)iter.next()).getReport().getTaskAttemptState());
        attempts = task2.getAttempts();
        Assert.assertEquals((String)"No of attempts is not correct", (int)1, (int)attempts.size());
        iter = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.SUCCEEDED, (Object)((TaskAttempt)iter.next()).getReport().getTaskAttemptState());
    }

    @Test
    public void testKillTaskWait() throws Exception {
        1 dispatcher = new /* Unavailable Anonymous Inner Class!! */;
        2 app = new /* Unavailable Anonymous Inner Class!! */;
        Job job = app.submit(new Configuration());
        JobId jobId = app.getJobId();
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (int)2, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask, TaskState.RUNNING);
        app.waitForState(reduceTask, TaskState.RUNNING);
        TaskAttempt mapAttempt = (TaskAttempt)mapTask.getAttempts().values().iterator().next();
        app.waitForState(mapAttempt, TaskAttemptState.RUNNING);
        TaskAttempt reduceAttempt = (TaskAttempt)reduceTask.getAttempts().values().iterator().next();
        app.waitForState(reduceAttempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(mapAttempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask, TaskState.SUCCEEDED);
        app.getContext().getEventHandler().handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
        app.waitForInternalState((JobImpl)job, JobStateInternal.KILLED);
    }

    @Test
    public void testKillTaskAttempt() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        BlockingMRApp app = new BlockingMRApp(2, 0, latch);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"No of tasks is not correct", (int)2, (int)tasks.size());
        Iterator it = tasks.values().iterator();
        Task task1 = (Task)it.next();
        Task task2 = (Task)it.next();
        app.waitForState(task1, TaskState.SCHEDULED);
        app.waitForState(task2, TaskState.SCHEDULED);
        TaskAttempt attempt = (TaskAttempt)task1.getAttempts().values().iterator().next();
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
        latch.countDown();
        app.waitForState(job, JobState.SUCCEEDED);
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.SUCCEEDED, (Object)task1.getReport().getTaskState());
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.SUCCEEDED, (Object)task2.getReport().getTaskState());
        Map attempts = task1.getAttempts();
        Assert.assertEquals((String)"No of attempts is not correct", (int)2, (int)attempts.size());
        Iterator iter = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.KILLED, (Object)((TaskAttempt)iter.next()).getReport().getTaskAttemptState());
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.SUCCEEDED, (Object)((TaskAttempt)iter.next()).getReport().getTaskAttemptState());
        attempts = task2.getAttempts();
        Assert.assertEquals((String)"No of attempts is not correct", (int)1, (int)attempts.size());
        iter = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.SUCCEEDED, (Object)((TaskAttempt)iter.next()).getReport().getTaskAttemptState());
    }

    public static void main(String[] args) throws Exception {
        TestKill t = new TestKill();
        t.testKillJob();
        t.testKillTask();
        t.testKillTaskAttempt();
    }
}

