/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KMSAudit {
    private static Set<KMS.KMSOp> AGGREGATE_OPS_WHITELIST = Sets.newHashSet((Object[])new KMS.KMSOp[]{KMS.KMSOp.GET_KEY_VERSION, KMS.KMSOp.GET_CURRENT_KEY, KMS.KMSOp.DECRYPT_EEK, KMS.KMSOp.GENERATE_EEK});
    private Cache<String, AuditEvent> cache;
    private ScheduledExecutorService executor;
    public static final String KMS_LOGGER_NAME = "kms-audit";
    private static Logger AUDIT_LOG = LoggerFactory.getLogger((String)"kms-audit");

    KMSAudit(long windowMs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(windowMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new /* Unavailable Anonymous Inner Class!! */).build();
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kms-audit_thread").build());
        this.executor.scheduleAtFixedRate((Runnable)new /* Unavailable Anonymous Inner Class!! */, windowMs / 10L, windowMs / 10L, TimeUnit.MILLISECONDS);
    }

    private void logEvent(AuditEvent event) {
        AUDIT_LOG.info("OK[op={}, key={}, user={}, accessCount={}, interval={}ms] {}", new Object[]{event.getOp(), event.getKeyName(), event.getUser(), event.getAccessCount().get(), System.currentTimeMillis() - event.getStartTime(), event.getExtraMsg()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void op(OpStatus opStatus, KMS.KMSOp op, String user, String key, String extraMsg) {
        if (!Strings.isNullOrEmpty((String)user) && !Strings.isNullOrEmpty((String)key) && op != null && AGGREGATE_OPS_WHITELIST.contains(op)) {
            String cacheKey = KMSAudit.createCacheKey((String)user, (String)key, (KMS.KMSOp)op);
            if (opStatus == OpStatus.UNAUTHORIZED) {
                this.cache.invalidate((Object)cacheKey);
                AUDIT_LOG.info("UNAUTHORIZED[op={}, key={}, user={}] {}", new Object[]{op, key, user, extraMsg});
                return;
            } else {
                try {
                    AuditEvent event = (AuditEvent)this.cache.get((Object)cacheKey, (Callable)new /* Unavailable Anonymous Inner Class!! */);
                    if (event.getAccessCount().incrementAndGet() != 0L) return;
                    event.getAccessCount().incrementAndGet();
                    this.logEvent(event);
                    return;
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
        } else {
            LinkedList<String> kvs = new LinkedList<String>();
            if (op != null) {
                kvs.add("op=" + op);
            }
            if (!Strings.isNullOrEmpty((String)key)) {
                kvs.add("key=" + key);
            }
            if (!Strings.isNullOrEmpty((String)user)) {
                kvs.add("user=" + user);
            }
            if (kvs.size() == 0) {
                AUDIT_LOG.info("{} {}", (Object)opStatus.toString(), (Object)extraMsg);
                return;
            } else {
                String join = Joiner.on((String)", ").join(kvs);
                AUDIT_LOG.info("{}[{}] {}", new Object[]{opStatus.toString(), join, extraMsg});
            }
        }
    }

    public void ok(UserGroupInformation user, KMS.KMSOp op, String key, String extraMsg) {
        this.op(OpStatus.OK, op, user.getShortUserName(), key, extraMsg);
    }

    public void ok(UserGroupInformation user, KMS.KMSOp op, String extraMsg) {
        this.op(OpStatus.OK, op, user.getShortUserName(), null, extraMsg);
    }

    public void unauthorized(UserGroupInformation user, KMS.KMSOp op, String key) {
        this.op(OpStatus.UNAUTHORIZED, op, user.getShortUserName(), key, "");
    }

    public void error(UserGroupInformation user, String method, String url, String extraMsg) {
        this.op(OpStatus.ERROR, null, user.getShortUserName(), null, "Method:'" + method + "' Exception:'" + extraMsg + "'");
    }

    public void unauthenticated(String remoteHost, String method, String url, String extraMsg) {
        this.op(OpStatus.UNAUTHENTICATED, null, null, null, "RemoteHost:" + remoteHost + " Method:" + method + " URL:" + url + " ErrorMsg:'" + extraMsg + "'");
    }

    private static String createCacheKey(String user, String key, KMS.KMSOp op) {
        return user + "#" + key + "#" + op;
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    static /* synthetic */ void access$000(KMSAudit x0, AuditEvent x1) {
        x0.logEvent(x1);
    }

    static /* synthetic */ Cache access$100(KMSAudit x0) {
        return x0.cache;
    }
}

