/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.crypto.key.kms.server.TestKMS;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestKMS {
    private static MiniKdc kdc;
    private static File keytab;

    @Before
    public void cleanUp() {
        Configuration conf = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    public static File getTestDir() throws Exception {
        File file = new File("dummy");
        file = file.getAbsoluteFile();
        file = file.getParentFile();
        file = new File(file, "target");
        if (!(file = new File(file, UUID.randomUUID().toString())).mkdirs()) {
            throw new RuntimeException("Could not create test directory: " + file);
        }
        return file;
    }

    protected KeyProvider createProvider(URI uri, Configuration conf) throws IOException {
        return new LoadBalancingKMSClientProvider(new KMSClientProvider[]{new KMSClientProvider(uri, conf)}, conf);
    }

    protected <T> T runServer(String keystore, String password, File confDir, KMSCallable<T> callable) throws Exception {
        return (T)this.runServer(-1, keystore, password, confDir, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runServer(int port, String keystore, String password, File confDir, KMSCallable<T> callable) throws Exception {
        MiniKMS.Builder miniKMSBuilder = new MiniKMS.Builder().setKmsConfDir(confDir).setLog4jConfFile("log4j.properties");
        if (keystore != null) {
            miniKMSBuilder.setSslConf(new File(keystore), password);
        }
        if (port > 0) {
            miniKMSBuilder.setPort(port);
        }
        MiniKMS miniKMS = miniKMSBuilder.build();
        miniKMS.start();
        try {
            System.out.println("Test KMS running at: " + miniKMS.getKMSUrl());
            KMSCallable.access$002(callable, (URL)miniKMS.getKMSUrl());
            Object object = callable.call();
            return (T)object;
        }
        finally {
            miniKMS.stop();
        }
    }

    protected Configuration createBaseKMSConf(File keyStoreDir) throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("hadoop.kms.key.provider.uri", "jceks://file@" + new Path(keyStoreDir.getAbsolutePath(), "kms.keystore").toUri());
        conf.set("hadoop.kms.authentication.type", "simple");
        return conf;
    }

    public static void writeConf(File confDir, Configuration conf) throws Exception {
        FileWriter writer = new FileWriter(new File(confDir, "kms-site.xml"));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        writer = new FileWriter(new File(confDir, "kms-acls.xml"));
        conf.writeXml((Writer)writer);
        ((Writer)writer).close();
        writer = new FileWriter(new File(confDir, "core-site.xml"));
        new Configuration(false).writeXml((Writer)writer);
        ((Writer)writer).close();
    }

    public static URI createKMSUri(URL kmsUrl) throws Exception {
        String str = kmsUrl.toString();
        str = str.replaceFirst("://", "@");
        return new URI("kms://" + str);
    }

    @BeforeClass
    public static void setUpMiniKdc() throws Exception {
        File kdcDir = TestKMS.getTestDir();
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, kdcDir);
        kdc.start();
        keytab = new File(kdcDir, "keytab");
        ArrayList<String> principals = new ArrayList<String>();
        principals.add("HTTP/localhost");
        principals.add("client");
        principals.add("hdfs");
        principals.add("otheradmin");
        principals.add("client/host");
        principals.add("client1");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            principals.add(type.toString());
        }
        principals.add("CREATE_MATERIAL");
        principals.add("ROLLOVER_MATERIAL");
        kdc.createPrincipal(keytab, principals.toArray(new String[principals.size()]));
    }

    @AfterClass
    public static void tearDownMiniKdc() throws Exception {
        if (kdc != null) {
            kdc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doAs(String user, PrivilegedExceptionAction<T> action) throws Exception {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(user));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        LoginContext loginContext = new LoginContext("", subject, null, KerberosConfiguration.createClientConfig((String)user, (File)keytab));
        try {
            loginContext.login();
            subject = loginContext.getSubject();
            UserGroupInformation ugi = UserGroupInformation.getUGIFromSubject((Subject)subject);
            Object object = ugi.doAs(action);
            return (T)object;
        }
        finally {
            loginContext.logout();
        }
    }

    public void testStartStop(boolean ssl, boolean kerberos) throws Exception {
        String password;
        String keystore;
        Configuration conf = new Configuration();
        if (kerberos) {
            conf.set("hadoop.security.authentication", "kerberos");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        if (ssl) {
            String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestKMS.class);
            KeyStoreTestUtil.setupSSLConfig((String)testDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
            keystore = testDir.getAbsolutePath() + "/serverKS.jks";
            password = "serverP";
        } else {
            keystore = null;
            password = null;
        }
        conf.set("hadoop.kms.authentication.token.validity", "1");
        if (kerberos) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
            conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
            conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
            conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        }
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(keystore, password, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testStartStopHttpPseudo() throws Exception {
        this.testStartStop(false, false);
    }

    @Test
    public void testStartStopHttpsPseudo() throws Exception {
        this.testStartStop(true, false);
    }

    @Test
    public void testStartStopHttpKerberos() throws Exception {
        this.testStartStop(false, true);
    }

    @Test
    public void testStartStopHttpsKerberos() throws Exception {
        this.testStartStop(true, true);
    }

    @Test
    public void testKMSProvider() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File confDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(confDir);
        conf.set("key.acl.k1.ALL", "*");
        conf.set("key.acl.k2.MANAGEMENT", "*");
        conf.set("key.acl.k2.READ", "*");
        conf.set("key.acl.k3.ALL", "*");
        conf.set("key.acl.k4.ALL", "*");
        conf.set("key.acl.k5.ALL", "*");
        conf.set("key.acl.k6.ALL", "*");
        TestKMS.writeConf((File)confDir, (Configuration)conf);
        this.runServer(null, null, confDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testKeyACLs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK,DECRYPT_EEK");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK,DECRYPT_EEK");
        conf.set(KMSACLs.Type.GENERATE_EEK.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK,DECRYPT_EEK");
        conf.set(KMSACLs.Type.DECRYPT_EEK.getAclConfigKey(), "CREATE,ROLLOVER,GET,SET_KEY_MATERIAL,GENERATE_EEK");
        conf.set("key.acl.test_key.MANAGEMENT", "CREATE");
        conf.set("key.acl.some_key.MANAGEMENT", "ROLLOVER");
        conf.set("whitelist.key.acl.MANAGEMENT", "DECRYPT_EEK");
        conf.set("whitelist.key.acl.ALL", "DECRYPT_EEK");
        conf.set("key.acl.all_access.ALL", "GENERATE_EEK");
        conf.set("key.acl.all_access.DECRYPT_EEK", "ROLLOVER");
        conf.set("default.key.acl.MANAGEMENT", "ROLLOVER");
        conf.set("default.key.acl.GENERATE_EEK", "SOMEBODY");
        conf.set("default.key.acl.ALL", "ROLLOVER");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
        conf.set("default.key.acl.MANAGEMENT", "");
        conf.set("default.key.acl.GENERATE_EEK", "*");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testKMSRestartKerberosAuth() throws Exception {
        this.doKMSRestart(true);
    }

    @Test
    public void testKMSRestartSimpleAuth() throws Exception {
        this.doKMSRestart(false);
    }

    public void doKMSRestart(boolean useKrb) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        if (useKrb) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
        }
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
        conf.set("key.acl.k0.ALL", "*");
        conf.set("key.acl.k1.ALL", "*");
        conf.set("key.acl.k2.ALL", "*");
        conf.set("key.acl.k3.ALL", "*");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        5 c = new /* Unavailable Anonymous Inner Class!! */;
        KeyProvider retKp = (KeyProvider)this.runServer(null, null, testDir, (KMSCallable)c);
        this.runServer(c.getKMSUrl().getPort(), null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testKMSAuthFailureRetry() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.kms.authentication.token.validity", "1");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
        conf.set("key.acl.k0.ALL", "*");
        conf.set("key.acl.k1.ALL", "*");
        conf.set("key.acl.k2.ALL", "*");
        conf.set("key.acl.k3.ALL", "*");
        conf.set("key.acl.k4.ALL", "*");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testACLs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString());
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
        conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
        conf.set("key.acl.k0.ALL", "*");
        conf.set("key.acl.k1.ALL", "*");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testKMSBlackList() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), " ");
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "client,hdfs,otheradmin");
        conf.set(KMSACLs.Type.GENERATE_EEK.getAclConfigKey(), "client,hdfs,otheradmin");
        conf.set(KMSACLs.Type.DECRYPT_EEK.getAclConfigKey(), "client,hdfs,otheradmin");
        conf.set(KMSACLs.Type.DECRYPT_EEK.getBlacklistConfigKey(), "hdfs,otheradmin");
        conf.set("key.acl.ck0.ALL", "*");
        conf.set("key.acl.ck1.ALL", "*");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testServicePrincipalACLs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), " ");
        }
        conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), "client");
        conf.set("default.key.acl.MANAGEMENT", "client,client/host");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testKMSTimeout() throws Exception {
        KeyProvider kp;
        int port;
        ServerSocket sock;
        File confDir = TestKMS.getTestDir();
        Configuration conf = this.createBaseKMSConf(confDir);
        conf.setInt("hadoop.security.kms.client.timeout", 1);
        TestKMS.writeConf((File)confDir, (Configuration)conf);
        try {
            sock = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
            port = sock.getLocalPort();
        }
        catch (Exception e) {
            return;
        }
        URL url = new URL("http://localhost:" + port + "/kms");
        URI uri = TestKMS.createKMSUri((URL)url);
        boolean caughtTimeout = false;
        try {
            kp = this.createProvider(uri, conf);
            kp.getKeys();
        }
        catch (SocketTimeoutException e) {
            caughtTimeout = true;
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Caught unexpected exception" + e.toString()), (boolean)false);
        }
        caughtTimeout = false;
        try {
            kp = this.createProvider(uri, conf);
            KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp).generateEncryptedKey("a");
        }
        catch (SocketTimeoutException e) {
            caughtTimeout = true;
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Caught unexpected exception" + e.toString()), (boolean)false);
        }
        caughtTimeout = false;
        try {
            kp = this.createProvider(uri, conf);
            KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp).decryptEncryptedKey((KeyProviderCryptoExtension.EncryptedKeyVersion)new KMSClientProvider.KMSEncryptedKeyVersion("a", "a", new byte[]{1, 2}, "EEK", new byte[]{1, 2}));
        }
        catch (SocketTimeoutException e) {
            caughtTimeout = true;
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Caught unexpected exception" + e.toString()), (boolean)false);
        }
        Assert.assertTrue((boolean)caughtTimeout);
        sock.close();
    }

    @Test
    public void testDelegationTokenAccess() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        conf.set("hadoop.kms.authentication.type", "kerberos");
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        String keyA = "key_a";
        String keyD = "key_d";
        conf.set("key.acl.key_a.ALL", "*");
        conf.set("key.acl.key_d.ALL", "*");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testKMSWithZKSigner() throws Exception {
        this.doKMSWithZK(true, false);
    }

    @Test
    public void testKMSWithZKDTSM() throws Exception {
        this.doKMSWithZK(false, true);
    }

    @Test
    public void testKMSWithZKSignerAndDTSM() throws Exception {
        this.doKMSWithZK(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doKMSWithZK(boolean zkDTSM, boolean zkSigner) throws Exception {
        TestingServer zkServer = null;
        try {
            zkServer = new TestingServer();
            zkServer.start();
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            File testDir = TestKMS.getTestDir();
            conf = this.createBaseKMSConf(testDir);
            conf.set("hadoop.kms.authentication.type", "kerberos");
            conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
            conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
            conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
            if (zkSigner) {
                conf.set("hadoop.kms.authentication.signer.secret.provider", "zookeeper");
                conf.set("hadoop.kms.authentication.signer.secret.provider.zookeeper.path", "/testKMSWithZKDTSM");
                conf.set("hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string", zkServer.getConnectString());
            }
            if (zkDTSM) {
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.enable", "true");
            }
            if (zkDTSM && !zkSigner) {
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.zkConnectionString", zkServer.getConnectString());
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.znodeWorkingPath", "testZKPath");
                conf.set("hadoop.kms.authentication.zk-dt-secret-manager.zkAuthType", "none");
            }
            for (KMSACLs.Type type : KMSACLs.Type.values()) {
                conf.set(type.getAclConfigKey(), type.toString());
            }
            conf.set(KMSACLs.Type.CREATE.getAclConfigKey(), KMSACLs.Type.CREATE.toString() + ",SET_KEY_MATERIAL");
            conf.set(KMSACLs.Type.ROLLOVER.getAclConfigKey(), KMSACLs.Type.ROLLOVER.toString() + ",SET_KEY_MATERIAL");
            conf.set("key.acl.k0.ALL", "*");
            conf.set("key.acl.k1.ALL", "*");
            conf.set("key.acl.k2.ALL", "*");
            conf.set("key.acl.k3.ALL", "*");
            TestKMS.writeConf((File)testDir, (Configuration)conf);
            13 c = new /* Unavailable Anonymous Inner Class!! */;
            this.runServer(null, null, testDir, (KMSCallable)c);
        }
        finally {
            if (zkServer != null) {
                zkServer.stop();
                zkServer.close();
            }
        }
    }

    @Test
    public void testProxyUserKerb() throws Exception {
        this.doProxyUserTest(true);
    }

    @Test
    public void testProxyUserSimple() throws Exception {
        this.doProxyUserTest(false);
    }

    public void doProxyUserTest(boolean kerberos) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        if (kerberos) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
        }
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.kms.proxyuser.client.users", "foo,bar");
        conf.set("hadoop.kms.proxyuser.client.hosts", "*");
        conf.set("key.acl.kaa.ALL", "client");
        conf.set("key.acl.kbb.ALL", "foo");
        conf.set("key.acl.kcc.ALL", "foo1");
        conf.set("key.acl.kdd.ALL", "bar");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testWebHDFSProxyUserKerb() throws Exception {
        this.doWebHDFSProxyUserTest(true);
    }

    @Test
    public void testWebHDFSProxyUserSimple() throws Exception {
        this.doWebHDFSProxyUserTest(false);
    }

    public void doWebHDFSProxyUserTest(boolean kerberos) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File testDir = TestKMS.getTestDir();
        conf = this.createBaseKMSConf(testDir);
        if (kerberos) {
            conf.set("hadoop.kms.authentication.type", "kerberos");
        }
        conf.set("hadoop.kms.authentication.kerberos.keytab", keytab.getAbsolutePath());
        conf.set("hadoop.kms.authentication.kerberos.principal", "HTTP/localhost");
        conf.set("hadoop.kms.authentication.kerberos.name.rules", "DEFAULT");
        conf.set("hadoop.security.kms.client.timeout", "300");
        conf.set("hadoop.kms.proxyuser.client.users", "foo,bar");
        conf.set("hadoop.kms.proxyuser.client.hosts", "*");
        conf.set("key.acl.kaa.ALL", "foo");
        conf.set("key.acl.kbb.ALL", "foo1");
        conf.set("key.acl.kcc.ALL", "bar");
        TestKMS.writeConf((File)testDir, (Configuration)conf);
        this.runServer(null, null, testDir, (KMSCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Object access$100(TestKMS x0, String x1, PrivilegedExceptionAction x2) throws Exception {
        return x0.doAs(x1, x2);
    }

    static /* synthetic */ File access$200() {
        return keytab;
    }
}

