/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.EagerKeyGeneratorKeyProviderCryptoExtension;

@InterfaceAudience.Private
public class EagerKeyGeneratorKeyProviderCryptoExtension
extends KeyProviderCryptoExtension {
    private static final String KEY_CACHE_PREFIX = "hadoop.security.kms.encrypted.key.cache.";
    public static final String KMS_KEY_CACHE_SIZE = "hadoop.security.kms.encrypted.key.cache.size";
    public static final int KMS_KEY_CACHE_SIZE_DEFAULT = 100;
    public static final String KMS_KEY_CACHE_LOW_WATERMARK = "hadoop.security.kms.encrypted.key.cache.low.watermark";
    public static final float KMS_KEY_CACHE_LOW_WATERMARK_DEFAULT = 0.3f;
    public static final String KMS_KEY_CACHE_EXPIRY_MS = "hadoop.security.kms.encrypted.key.cache.expiry";
    public static final int KMS_KEY_CACHE_EXPIRY_DEFAULT = 43200000;
    public static final String KMS_KEY_CACHE_NUM_REFILL_THREADS = "hadoop.security.kms.encrypted.key.cache.num.fill.threads";
    public static final int KMS_KEY_CACHE_NUM_REFILL_THREADS_DEFAULT = 2;

    public EagerKeyGeneratorKeyProviderCryptoExtension(Configuration conf, KeyProviderCryptoExtension keyProviderCryptoExtension) {
        super((KeyProvider)keyProviderCryptoExtension, (KeyProviderCryptoExtension.CryptoExtension)new CryptoExtension(conf, keyProviderCryptoExtension));
    }

    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        KeyProvider.KeyVersion keyVersion = super.rollNewVersion(name);
        ((KeyProviderCryptoExtension.CryptoExtension)this.getExtension()).drain(name);
        return keyVersion;
    }

    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        KeyProvider.KeyVersion keyVersion = super.rollNewVersion(name, material);
        ((KeyProviderCryptoExtension.CryptoExtension)this.getExtension()).drain(name);
        return keyVersion;
    }
}

