/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;

public class TestWebHdfsTokens {
    private static Configuration conf;
    URI uri = null;

    @BeforeClass
    public static void setUp() {
        conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"LoginUser", (String[])new String[]{"supergroup"}));
    }

    private WebHdfsFileSystem spyWebhdfsInSecureSetup() throws IOException {
        WebHdfsFileSystem fsOrig = new WebHdfsFileSystem();
        fsOrig.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.spy((Object)fsOrig);
        return fs;
    }

    @Test(timeout=5000L)
    public void testTokenForNonTokenOp() throws IOException {
        WebHdfsFileSystem fs = this.spyWebhdfsInSecureSetup();
        Token token = (Token)Mockito.mock(Token.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)token).when((Object)fs)).getDelegationToken(null);
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).setDelegationToken(token);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.toUrl((HttpOpParam.Op)GetOpParam.Op.OPEN, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs)).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken(token);
    }

    @Test(timeout=5000L)
    public void testNoTokenForGetToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN);
    }

    @Test(timeout=5000L)
    public void testNoTokenForRenewToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN);
    }

    @Test(timeout=5000L)
    public void testNoTokenForCancelToken() throws IOException {
        this.checkNoTokenForOperation((HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN);
    }

    private void checkNoTokenForOperation(HttpOpParam.Op op) throws IOException {
        WebHdfsFileSystem fs = this.spyWebhdfsInSecureSetup();
        ((WebHdfsFileSystem)Mockito.doReturn(null).when((Object)fs)).getDelegationToken(null);
        fs.initialize(URI.create("webhdfs://127.0.0.1:0"), conf);
        fs.toUrl(op, null, new Param[0]);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
    }

    @Test(timeout=1000L)
    public void testGetOpRequireAuth() {
        for (GetOpParam.Op op : GetOpParam.Op.values()) {
            boolean expect = op == GetOpParam.Op.GETDELEGATIONTOKEN;
            Assert.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testPutOpRequireAuth() {
        for (PutOpParam.Op op : PutOpParam.Op.values()) {
            boolean expect = op == PutOpParam.Op.RENEWDELEGATIONTOKEN || op == PutOpParam.Op.CANCELDELEGATIONTOKEN;
            Assert.assertEquals((Object)expect, (Object)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testPostOpRequireAuth() {
        for (PostOpParam.Op op : PostOpParam.Op.values()) {
            Assert.assertFalse((boolean)op.getRequireAuth());
        }
    }

    @Test(timeout=1000L)
    public void testDeleteOpRequireAuth() {
        for (DeleteOpParam.Op op : DeleteOpParam.Op.values()) {
            Assert.assertFalse((boolean)op.getRequireAuth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazyTokenFetchForWebhdfs() throws Exception {
        MiniDFSCluster cluster = null;
        Object fs = null;
        try {
            HdfsConfiguration clusterConf = new HdfsConfiguration(conf);
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.SIMPLE, (Configuration)clusterConf);
            clusterConf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            UserGroupInformation.setConfiguration((Configuration)clusterConf);
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(1).build();
            cluster.waitActive();
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)clusterConf);
            UserGroupInformation.setConfiguration((Configuration)clusterConf);
            this.uri = DFSUtil.createUri((String)"webhdfs", (InetSocketAddress)cluster.getNameNode().getHttpAddress());
            this.validateLazyTokenFetch((Configuration)clusterConf);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazyTokenFetchForSWebhdfs() throws Exception {
        MiniDFSCluster cluster = null;
        Object fs = null;
        try {
            HdfsConfiguration clusterConf = new HdfsConfiguration(conf);
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.SIMPLE, (Configuration)clusterConf);
            clusterConf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestWebHdfsTokens.class.getSimpleName();
            clusterConf.setBoolean("dfs.webhdfs.enabled", true);
            clusterConf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
            clusterConf.set("dfs.namenode.https-address", "localhost:0");
            clusterConf.set("dfs.datanode.https.address", "localhost:0");
            File base = new File(BASEDIR);
            FileUtil.fullyDelete((File)base);
            base.mkdirs();
            String keystoresDir = new File(BASEDIR).getAbsolutePath();
            String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestWebHdfsTokens.class);
            KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)clusterConf, (boolean)false);
            UserGroupInformation.setConfiguration((Configuration)clusterConf);
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(1).build();
            cluster.waitActive();
            InetSocketAddress addr = cluster.getNameNode().getHttpsAddress();
            String nnAddr = NetUtils.getHostPortString((InetSocketAddress)addr);
            clusterConf.set("dfs.namenode.https-address", nnAddr);
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)clusterConf);
            UserGroupInformation.setConfiguration((Configuration)clusterConf);
            this.uri = DFSUtil.createUri((String)"swebhdfs", (InetSocketAddress)cluster.getNameNode().getHttpsAddress());
            this.validateLazyTokenFetch((Configuration)clusterConf);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTokenServiceAndKind() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration clusterConf = new HdfsConfiguration(conf);
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.SIMPLE, (Configuration)clusterConf);
            clusterConf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            UserGroupInformation.setConfiguration((Configuration)clusterConf);
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(0).build();
            cluster.waitActive();
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)clusterConf);
            WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)clusterConf, "webhdfs");
            Whitebox.setInternalState((Object)fs, (String)"canRefreshDelegationToken", (Object)true);
            URLConnectionFactory factory = new URLConnectionFactory(new ConnectionConfigurator(){

                public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                    return conn;
                }
            }){

                public URLConnection openConnection(URL url) throws IOException {
                    return super.openConnection(new URL(url + "&service=foo&kind=bar"));
                }
            };
            Whitebox.setInternalState((Object)fs, (String)"connectionFactory", (Object)factory);
            Token token1 = fs.getDelegationToken();
            Assert.assertEquals((Object)new Text("bar"), (Object)token1.getKind());
            GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
            WebHdfsFileSystem webHdfsFileSystem = fs;
            webHdfsFileSystem.getClass();
            Token token2 = (Token)new WebHdfsFileSystem.FsPathResponseRunner<Token<DelegationTokenIdentifier>>(webHdfsFileSystem, (HttpOpParam.Op)op, null, new Param[]{new RenewerParam(null)}){
                {
                    WebHdfsFileSystem webHdfsFileSystem = x0;
                    webHdfsFileSystem.getClass();
                    super(webHdfsFileSystem, x1, x2, x3);
                }

                Token<DelegationTokenIdentifier> decodeResponse(Map<?, ?> json) throws IOException {
                    return JsonUtil.toDelegationToken(json);
                }
            }.run();
            Assert.assertEquals((Object)new Text("bar"), (Object)token2.getKind());
            Assert.assertEquals((Object)new Text("foo"), (Object)token2.getService());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void validateLazyTokenFetch(final Configuration clusterConf) throws Exception {
        String testUser = "DummyUser";
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"DummyUser", (String[])new String[]{"supergroup"});
        WebHdfsFileSystem fs = (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws IOException {
                return (WebHdfsFileSystem)Mockito.spy((Object)((WebHdfsFileSystem)FileSystem.newInstance((URI)TestWebHdfsTokens.this.uri, (Configuration)clusterConf)));
            }
        });
        Assert.assertNull((Object)fs.getRenewToken());
        Token token = fs.getDelegationToken(null);
        fs.renewDelegationToken(token);
        fs.cancelDelegationToken(token);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        Assert.assertNull((Object)fs.getRenewToken());
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        Path p = new Path("/f");
        fs.create(p, (short)1).close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.any(Token.class));
        token = fs.getRenewToken();
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)"DummyUser", (Object)this.getTokenOwner(token));
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.getFileStatus(p);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        Token token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        token = fs.getRenewToken();
        fs.cancelDelegationToken(token);
        try {
            fs.renewDelegationToken(token);
            Assert.fail((String)"should have failed");
        }
        catch (SecretManager.InvalidToken it) {
        }
        catch (Exception ex) {
            Assert.fail((String)("wrong exception:" + ex));
        }
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        try {
            fs.cancelDelegationToken(token);
            Assert.fail((String)"should have failed");
        }
        catch (SecretManager.InvalidToken it) {
        }
        catch (Exception ex) {
            Assert.fail((String)("wrong exception:" + ex));
        }
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.open(p).close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.any(Token.class));
        token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertNotSame((Object)token, (Object)token2);
        Assert.assertEquals((Object)"DummyUser", (Object)this.getTokenOwner(token2));
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.cancelDelegationToken(fs.getRenewToken());
        FSDataInputStream is = fs.open(p);
        is.read();
        is.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken(null);
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.any(Token.class));
        token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertNotSame((Object)token, (Object)token2);
        Assert.assertEquals((Object)"DummyUser", (Object)this.getTokenOwner(token2));
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).cancelDelegationToken((Token)Mockito.eq((Object)token2));
        token = fs.getDelegationToken(null);
        ugi.addToken(token);
        fs = (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws IOException {
                return (WebHdfsFileSystem)Mockito.spy((Object)((WebHdfsFileSystem)FileSystem.newInstance((URI)TestWebHdfsTokens.this.uri, (Configuration)clusterConf)));
            }
        });
        Assert.assertNull((Object)fs.getRenewToken());
        fs.getFileStatus(new Path("/"));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setDelegationToken((Token)Mockito.eq((Object)token));
        token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.getFileStatus(new Path("/"));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        token2 = fs.getRenewToken();
        Assert.assertNotNull((Object)token2);
        Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
        Assert.assertSame((Object)token, (Object)token2);
        Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        fs.cancelDelegationToken(token);
        for (int i = 0; i < 2; ++i) {
            try {
                fs.getFileStatus(new Path("/"));
                Assert.fail((String)"didn't fail");
            }
            catch (SecretManager.InvalidToken it) {
            }
            catch (Exception ex) {
                Assert.fail((String)("wrong exception:" + ex));
            }
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getDelegationToken();
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).replaceExpiredDelegationToken();
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
            ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
            token2 = fs.getRenewToken();
            Assert.assertNotNull((Object)token2);
            Assert.assertEquals((Object)fs.getTokenKind(), (Object)token.getKind());
            Assert.assertSame((Object)token, (Object)token2);
            Mockito.reset((Object[])new WebHdfsFileSystem[]{fs});
        }
        fs.close();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).replaceExpiredDelegationToken();
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).getDelegationToken(Mockito.anyString());
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).setDelegationToken((Token)Mockito.any(Token.class));
        ((WebHdfsFileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).cancelDelegationToken((Token)Mockito.any(Token.class));
    }

    private String getTokenOwner(Token<?> token) throws IOException {
        Token clone = new Token(token);
        clone.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
        return clone.decodeIdentifier().getUser().getUserName();
    }
}

