/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBlockPoolManager {
    private final Log LOG = LogFactory.getLog(TestBlockPoolManager.class);
    private final DataNode mockDN = (DataNode)Mockito.mock(DataNode.class);
    private BlockPoolManager bpm;
    private final StringBuilder log = new StringBuilder();
    private int mockIdx = 1;

    @Before
    public void setupBPM() {
        this.bpm = new BlockPoolManager(this.mockDN){

            protected BPOfferService createBPOS(List<InetSocketAddress> nnAddrs) {
                final int idx = TestBlockPoolManager.this.mockIdx++;
                TestBlockPoolManager.this.doLog("create #" + idx);
                final BPOfferService bpos = (BPOfferService)Mockito.mock(BPOfferService.class);
                ((BPOfferService)Mockito.doReturn((Object)("Mock BPOS #" + idx)).when((Object)bpos)).toString();
                try {
                    ((BPOfferService)Mockito.doAnswer((Answer)new Answer<Void>(){

                        public Void answer(InvocationOnMock invocation) throws Throwable {
                            TestBlockPoolManager.this.doLog("refresh #" + idx);
                            return null;
                        }
                    }).when((Object)bpos)).refreshNNList((ArrayList)Mockito.any());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ((BPOfferService)Mockito.doAnswer((Answer)new Answer<Void>(){

                    public Void answer(InvocationOnMock invocation) throws Throwable {
                        TestBlockPoolManager.this.doLog("stop #" + idx);
                        TestBlockPoolManager.this.bpm.remove(bpos);
                        return null;
                    }
                }).when((Object)bpos)).stop();
                return bpos;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog(String string) {
        StringBuilder stringBuilder = this.log;
        synchronized (stringBuilder) {
            this.LOG.info((Object)string);
            this.log.append(string).append("\n");
        }
    }

    @Test
    public void testSimpleSingleNS() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://mock1:8020");
        this.bpm.refreshNamenodes(conf);
        Assert.assertEquals((Object)"create #1\n", (Object)this.log.toString());
    }

    @Test
    public void testFederationRefresh() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", "ns1,ns2");
        TestBlockPoolManager.addNN(conf, "ns1", "mock1:8020");
        TestBlockPoolManager.addNN(conf, "ns2", "mock1:8020");
        this.bpm.refreshNamenodes(conf);
        Assert.assertEquals((Object)"create #1\ncreate #2\n", (Object)this.log.toString());
        this.log.setLength(0);
        conf.set("dfs.nameservices", "ns2");
        this.bpm.refreshNamenodes(conf);
        Assert.assertEquals((Object)"stop #1\nrefresh #2\n", (Object)this.log.toString());
        this.log.setLength(0);
        conf.set("dfs.nameservices", "ns1,ns2");
        this.bpm.refreshNamenodes(conf);
        Assert.assertEquals((Object)"create #3\nrefresh #2\n", (Object)this.log.toString());
    }

    @Test
    public void testInternalNameService() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", "ns1,ns2,ns3");
        TestBlockPoolManager.addNN(conf, "ns1", "mock1:8020");
        TestBlockPoolManager.addNN(conf, "ns2", "mock1:8020");
        TestBlockPoolManager.addNN(conf, "ns3", "mock1:8020");
        conf.set("dfs.internal.nameservices", "ns1");
        this.bpm.refreshNamenodes(conf);
        Assert.assertEquals((Object)"create #1\n", (Object)this.log.toString());
        Map map = (Map)Whitebox.getInternalState((Object)this.bpm, (String)"bpByNameserviceId");
        Assert.assertFalse((boolean)map.containsKey("ns2"));
        Assert.assertFalse((boolean)map.containsKey("ns3"));
        Assert.assertTrue((boolean)map.containsKey("ns1"));
        this.log.setLength(0);
    }

    private static void addNN(Configuration conf, String ns, String addr) {
        String key = DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{ns});
        conf.set(key, addr);
    }
}

