/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBlockListAsLongs {
    static Block b1 = new Block(1L, 11L, 111L);
    static Block b2 = new Block(2L, 22L, 222L);
    static Block b3 = new Block(3L, 33L, 333L);
    static Block b4 = new Block(4L, 44L, 444L);

    @Test
    public void testEmptyReport() {
        BlockListAsLongs blocks = this.checkReport(new Replica[0]);
        Assert.assertArrayEquals((long[])new long[]{0L, 0L, -1L, -1L, -1L}, (long[])blocks.getBlockListAsLongs());
    }

    @Test
    public void testFinalized() {
        BlockListAsLongs blocks = this.checkReport(new Replica[]{new FinalizedReplica(b1, null, null)});
        Assert.assertArrayEquals((long[])new long[]{1L, 0L, 1L, 11L, 111L, -1L, -1L, -1L}, (long[])blocks.getBlockListAsLongs());
    }

    @Test
    public void testUc() {
        BlockListAsLongs blocks = this.checkReport(new Replica[]{new ReplicaBeingWritten(b1, null, null, null)});
        Assert.assertArrayEquals((long[])new long[]{0L, 1L, -1L, -1L, -1L, 1L, 11L, 111L, HdfsServerConstants.ReplicaState.RBW.getValue()}, (long[])blocks.getBlockListAsLongs());
    }

    @Test
    public void testMix() {
        BlockListAsLongs blocks = this.checkReport(new Replica[]{new FinalizedReplica(b1, null, null), new FinalizedReplica(b2, null, null), new ReplicaBeingWritten(b3, null, null, null), new ReplicaWaitingToBeRecovered(b4, null, null)});
        Assert.assertArrayEquals((long[])new long[]{2L, 2L, 1L, 11L, 111L, 2L, 22L, 222L, -1L, -1L, -1L, 3L, 33L, 333L, HdfsServerConstants.ReplicaState.RBW.getValue(), 4L, 44L, 444L, HdfsServerConstants.ReplicaState.RWR.getValue()}, (long[])blocks.getBlockListAsLongs());
    }

    @Test
    public void testFuzz() throws InterruptedException {
        Replica[] replicas = new Replica[100000];
        Random rand = new Random(0L);
        block5: for (int i = 0; i < replicas.length; ++i) {
            Block b = new Block(rand.nextLong(), (long)i, (long)(i << 4));
            switch (rand.nextInt(2)) {
                case 0: {
                    replicas[i] = new FinalizedReplica(b, null, null);
                    continue block5;
                }
                case 1: {
                    replicas[i] = new ReplicaBeingWritten(b, null, null, null);
                    continue block5;
                }
                case 2: {
                    replicas[i] = new ReplicaWaitingToBeRecovered(b, null, null);
                }
            }
        }
        this.checkReport(replicas);
    }

    private BlockListAsLongs checkReport(Replica ... replicas) {
        Map<Long, Replica> expectedReplicas = new HashMap();
        for (Replica replica : replicas) {
            expectedReplicas.put(replica.getBlockId(), replica);
        }
        expectedReplicas = Collections.unmodifiableMap(expectedReplicas);
        BlockListAsLongs blocks = BlockListAsLongs.encode(expectedReplicas.values());
        List buffers = blocks.getBlocksBuffers();
        ArrayList<Long> longs = new ArrayList<Long>();
        for (long value : blocks.getBlockListAsLongs()) {
            longs.add(value);
        }
        BlockListAsLongs decodedBlocks = BlockListAsLongs.decodeBuffers((int)expectedReplicas.size(), (List)buffers);
        this.checkReplicas(expectedReplicas, decodedBlocks);
        BlockListAsLongs decodedList = BlockListAsLongs.decodeLongs(longs);
        this.checkReplicas(expectedReplicas, decodedList);
        return blocks;
    }

    private void checkReplicas(Map<Long, Replica> expectedReplicas, BlockListAsLongs decodedBlocks) {
        Assert.assertEquals((long)expectedReplicas.size(), (long)decodedBlocks.getNumberOfBlocks());
        HashMap<Long, Replica> reportReplicas = new HashMap<Long, Replica>(expectedReplicas);
        for (BlockListAsLongs.BlockReportReplica replica : decodedBlocks) {
            Assert.assertNotNull((Object)replica);
            Replica expected = (Replica)reportReplicas.remove(replica.getBlockId());
            Assert.assertNotNull((Object)expected);
            Assert.assertEquals((String)"wrong bytes", (long)expected.getNumBytes(), (long)replica.getNumBytes());
            Assert.assertEquals((String)"wrong genstamp", (long)expected.getGenerationStamp(), (long)replica.getGenerationStamp());
            Assert.assertEquals((String)"wrong replica state", (Object)expected.getState(), (Object)replica.getState());
        }
        Assert.assertTrue((boolean)reportReplicas.isEmpty());
    }

    @Test
    public void testDatanodeDetect() throws ServiceException, IOException {
        final AtomicReference request = new AtomicReference();
        DatanodeProtocolPB mockProxy = (DatanodeProtocolPB)Mockito.mock(DatanodeProtocolPB.class);
        ((DatanodeProtocolPB)Mockito.doAnswer((Answer)new Answer<DatanodeProtocolProtos.BlockReportResponseProto>(){

            public DatanodeProtocolProtos.BlockReportResponseProto answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                request.set((DatanodeProtocolProtos.BlockReportRequestProto)args[1]);
                return DatanodeProtocolProtos.BlockReportResponseProto.newBuilder().build();
            }
        }).when((Object)mockProxy)).blockReport((RpcController)Matchers.any(RpcController.class), (DatanodeProtocolProtos.BlockReportRequestProto)Matchers.any(DatanodeProtocolProtos.BlockReportRequestProto.class));
        DatanodeProtocolClientSideTranslatorPB nn = new DatanodeProtocolClientSideTranslatorPB(mockProxy);
        DatanodeRegistration reg = DFSTestUtil.getLocalDatanodeRegistration();
        NamespaceInfo nsInfo = new NamespaceInfo(1, "cluster", "bp", 1L);
        reg.setNamespaceInfo(nsInfo);
        FinalizedReplica r = new FinalizedReplica(new Block(1L, 2L, 3L), null, null);
        BlockListAsLongs bbl = BlockListAsLongs.encode(Collections.singleton(r));
        DatanodeStorage storage = new DatanodeStorage("s1");
        StorageBlockReport[] sbr = new StorageBlockReport[]{new StorageBlockReport(storage, bbl)};
        request.set(null);
        nsInfo.setCapabilities(NamespaceInfo.Capability.STORAGE_BLOCK_REPORT_BUFFERS.getMask());
        nn.blockReport(reg, "pool", sbr, new BlockReportContext(1, 0, System.nanoTime()));
        DatanodeProtocolProtos.BlockReportRequestProto proto = (DatanodeProtocolProtos.BlockReportRequestProto)request.get();
        Assert.assertNotNull((Object)proto);
        Assert.assertTrue((boolean)proto.getReports(0).getBlocksList().isEmpty());
        Assert.assertFalse((boolean)proto.getReports(0).getBlocksBuffersList().isEmpty());
        request.set(null);
        nsInfo.setCapabilities(NamespaceInfo.Capability.UNKNOWN.getMask());
        nn.blockReport(reg, "pool", sbr, new BlockReportContext(1, 0, System.nanoTime()));
        proto = (DatanodeProtocolProtos.BlockReportRequestProto)request.get();
        Assert.assertNotNull((Object)proto);
        Assert.assertFalse((boolean)proto.getReports(0).getBlocksList().isEmpty());
        Assert.assertTrue((boolean)proto.getReports(0).getBlocksBuffersList().isEmpty());
    }
}

