/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRefreshCallQueue {
    private MiniDFSCluster cluster;
    private Configuration config;
    private FileSystem fs;
    static int mockQueueConstructions;
    static int mockQueuePuts;
    private static final int NNPort = 54222;
    private static String CALLQUEUE_CONFIG_KEY;

    @Before
    public void setUp() throws Exception {
        mockQueueConstructions = 0;
        mockQueuePuts = 0;
        this.config = new Configuration();
        this.config.setClass(CALLQUEUE_CONFIG_KEY, MockCallQueue.class, BlockingQueue.class);
        this.config.set("hadoop.security.authorization", "true");
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:54222");
        this.fs = FileSystem.get((Configuration)this.config);
        this.cluster = new MiniDFSCluster.Builder(this.config).nameNodePort(54222).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public boolean canPutInMockQueue() throws IOException {
        int putsBefore = mockQueuePuts;
        this.fs.exists(new Path("/"));
        return mockQueuePuts > putsBefore;
    }

    @Test
    public void testRefresh() throws Exception {
        Assert.assertTrue((String)"Mock queue should have been constructed", (mockQueueConstructions > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Puts are routed through MockQueue", (boolean)this.canPutInMockQueue());
        int lastMockQueueConstructions = mockQueueConstructions;
        DFSAdmin admin = new DFSAdmin(this.config);
        String[] args = new String[]{"-refreshCallQueue"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"DFSAdmin should return 0", (long)0L, (long)exitCode);
        Assert.assertEquals((String)"Mock queue should have no additional constructions", (long)lastMockQueueConstructions, (long)mockQueueConstructions);
        try {
            Assert.assertFalse((String)"Puts are routed through LBQ instead of MockQueue", (boolean)this.canPutInMockQueue());
        }
        catch (IOException ioe) {
            Assert.fail((String)"Could not put into queue at all");
        }
    }

    static {
        CALLQUEUE_CONFIG_KEY = "ipc.54222.callqueue.impl";
    }

    public static class MockCallQueue<E>
    extends LinkedBlockingQueue<E> {
        public MockCallQueue(int cap, String ns, Configuration conf) {
            super(cap);
            ++mockQueueConstructions;
        }

        @Override
        public void put(E e) throws InterruptedException {
            super.put(e);
            ++mockQueuePuts;
        }
    }
}

