/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.security.AccessControlException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestOpenFilesWithSnapshot {
    private Configuration conf = new Configuration();
    MiniHDFSCluster cluster = null;
    DistributedFileSystem fs = null;

    @Before
    public void setup() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).buildHDFS();
        this.conf.set("dfs.blocksize", "1048576");
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void teardown() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testUCFileDeleteWithSnapShot() throws Exception {
        Path path = new Path("/test");
        this.doWriteAndAbort(this.fs, path);
        this.fs.delete(new Path("/test/test/test2"), true);
        this.fs.delete(new Path("/test/test/test3"), true);
        this.cluster.restartNameNode();
    }

    @Test
    public void testParentDirWithUCFileDeleteWithSnapShot() throws Exception {
        Path path = new Path("/test");
        this.doWriteAndAbort(this.fs, path);
        this.fs.delete(new Path("/test/test"), true);
        this.cluster.restartNameNode();
    }

    @Test
    public void testWithCheckpoint() throws Exception {
        Path path = new Path("/test");
        this.doWriteAndAbort(this.fs, path);
        this.fs.delete(new Path("/test/test"), true);
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeAdapter.enterSafeMode(nameNode, false);
        NameNodeAdapter.saveNamespace(nameNode);
        NameNodeAdapter.leaveSafeMode(nameNode);
        this.cluster.restartNameNode(true);
        String test2snapshotPath = Snapshot.getSnapshotPath((String)path.toString(), (String)"s1/test/test2");
        DFSTestUtil.readFile((FileSystem)this.fs, new Path(test2snapshotPath));
        String test3snapshotPath = Snapshot.getSnapshotPath((String)path.toString(), (String)"s1/test/test3");
        DFSTestUtil.readFile((FileSystem)this.fs, new Path(test3snapshotPath));
    }

    @Test
    public void testFilesDeletionWithCheckpoint() throws Exception {
        Path path = new Path("/test");
        this.doWriteAndAbort(this.fs, path);
        this.fs.delete(new Path("/test/test/test2"), true);
        this.fs.delete(new Path("/test/test/test3"), true);
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeAdapter.enterSafeMode(nameNode, false);
        NameNodeAdapter.saveNamespace(nameNode);
        NameNodeAdapter.leaveSafeMode(nameNode);
        this.cluster.restartNameNode(true);
        String test2snapshotPath = Snapshot.getSnapshotPath((String)path.toString(), (String)"s1/test/test2");
        DFSTestUtil.readFile((FileSystem)this.fs, new Path(test2snapshotPath));
        String test3snapshotPath = Snapshot.getSnapshotPath((String)path.toString(), (String)"s1/test/test3");
        DFSTestUtil.readFile((FileSystem)this.fs, new Path(test3snapshotPath));
    }

    private void doWriteAndAbort(DistributedFileSystem fs, Path path) throws IOException {
        fs.mkdirs(path);
        fs.allowSnapshot(path);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/test/test1"), 100L, (short)2, 100024L);
        DFSTestUtil.createFile((FileSystem)fs, new Path("/test/test2"), 100L, (short)2, 100024L);
        Path file = new Path("/test/test/test2");
        FSDataOutputStream out = fs.create(file);
        for (int i = 0; i < 2; ++i) {
            for (long count = 0L; count < 0x100000L; count += 4L) {
                out.writeBytes("hell");
            }
        }
        ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        DFSTestUtil.abortStream((DFSOutputStream)out.getWrappedStream());
        Path file2 = new Path("/test/test/test3");
        FSDataOutputStream out2 = fs.create(file2);
        for (int i = 0; i < 2; ++i) {
            for (long count = 0L; count < 0x100000L; count += 4L) {
                out2.writeBytes("hell");
            }
        }
        ((DFSOutputStream)out2.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        DFSTestUtil.abortStream((DFSOutputStream)out2.getWrappedStream());
        fs.createSnapshot(path, "s1");
    }

    @Test
    public void testOpenFilesWithMultipleSnapshots() throws Exception {
        this.doTestMultipleSnapshots(true);
    }

    @Test
    public void testOpenFilesWithMultipleSnapshotsWithoutCheckpoint() throws Exception {
        this.doTestMultipleSnapshots(false);
    }

    private void doTestMultipleSnapshots(boolean saveNamespace) throws IOException, AccessControlException {
        Path path = new Path("/test");
        this.doWriteAndAbort(this.fs, path);
        this.fs.createSnapshot(path, "s2");
        this.fs.delete(new Path("/test/test"), true);
        this.fs.deleteSnapshot(path, "s2");
        if (saveNamespace) {
            NameNode nameNode = this.cluster.getNameNode();
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
            NameNodeAdapter.leaveSafeMode(nameNode);
        }
        this.cluster.restartNameNode(true);
    }

    @Test
    public void testOpenFilesWithRename() throws Exception {
        Path path = new Path("/test");
        this.doWriteAndAbort(this.fs, path);
        Path fileWithEmptyBlock = new Path("/test/test/test4");
        this.fs.create(fileWithEmptyBlock);
        NamenodeProtocols nameNodeRpc = this.cluster.getNameNodeRpc();
        String clientName = this.fs.getClient().getClientName();
        nameNodeRpc.addBlock(fileWithEmptyBlock.toString(), clientName, null, null, 0L, null);
        this.fs.createSnapshot(path, "s2");
        this.fs.rename(new Path("/test/test"), new Path("/test/test-renamed"));
        this.fs.delete(new Path("/test/test-renamed"), true);
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeAdapter.enterSafeMode(nameNode, false);
        NameNodeAdapter.saveNamespace(nameNode);
        NameNodeAdapter.leaveSafeMode(nameNode);
        this.cluster.restartNameNode(true);
    }
}

