/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.util.LightWeightCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRetryCacheWithHA {
    private static final Log LOG = LogFactory.getLog(TestRetryCacheWithHA.class);
    private static final int BlockSize = 1024;
    private static final short DataNodes = 3;
    private static final int CHECKTIMES = 10;
    private MiniHDFSCluster cluster;
    private DistributedFileSystem dfs;
    private Configuration conf = new HdfsConfiguration();

    @Before
    public void setup() throws Exception {
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).buildHDFS();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        HATestUtil.setFailoverConfigurations(this.cluster, this.conf);
        this.dfs = (DistributedFileSystem)HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    @After
    public void cleanup() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testRetryCacheOnStandbyNN() throws Exception {
        DFSTestUtil.runOperations(this.cluster, this.dfs, this.conf, 1024L, 0);
        FSNamesystem fsn0 = this.cluster.getNamesystem(0);
        LightWeightCache cacheSet = (LightWeightCache)fsn0.getRetryCache().getCacheSet();
        Assert.assertEquals((long)14L, (long)cacheSet.size());
        HashMap<RetryCache.CacheEntry, RetryCache.CacheEntry> oldEntries = new HashMap<RetryCache.CacheEntry, RetryCache.CacheEntry>();
        for (RetryCache.CacheEntry entry : cacheSet) {
            oldEntries.put(entry, entry);
        }
        this.cluster.getNameNode(0).getRpcServer().rollEditLog();
        this.cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        FSNamesystem fsn1 = this.cluster.getNamesystem(1);
        cacheSet = (LightWeightCache)fsn1.getRetryCache().getCacheSet();
        Assert.assertEquals((long)14L, (long)cacheSet.size());
        for (RetryCache.CacheEntry entry : cacheSet) {
            Assert.assertTrue((boolean)oldEntries.containsKey(entry));
        }
    }

    private DFSClient genClientWithDummyHandler() throws IOException {
        URI nnUri = this.dfs.getUri();
        Class failoverProxyProviderClass = NameNodeProxies.getFailoverProxyProviderClass((Configuration)this.conf, (URI)nnUri, ClientProtocol.class);
        FailoverProxyProvider failoverProxyProvider = NameNodeProxies.createFailoverProxyProvider((Configuration)this.conf, (Class)failoverProxyProviderClass, ClientProtocol.class, (URI)nnUri);
        DummyRetryInvocationHandler dummyHandler = new DummyRetryInvocationHandler((FailoverProxyProvider<ClientProtocol>)failoverProxyProvider, RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)Integer.MAX_VALUE, (long)500L, (long)15000L));
        ClientProtocol proxy = (ClientProtocol)Proxy.newProxyInstance(failoverProxyProvider.getInterface().getClassLoader(), new Class[]{ClientProtocol.class}, (InvocationHandler)((Object)dummyHandler));
        DFSClient client = new DFSClient(null, proxy, this.conf, null);
        return client;
    }

    @Test(timeout=60000L)
    public void testCreateSnapshot() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        CreateSnapshotOp op = new CreateSnapshotOp(client, "/test", "s1");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testDeleteSnapshot() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        DeleteSnapshotOp op = new DeleteSnapshotOp(client, "/test", "s1");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRenameSnapshot() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RenameSnapshotOp op = new RenameSnapshotOp(client, "/test", "s1", "s2");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testCreate() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        CreateOp op = new CreateOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testAppend() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        AppendOp op = new AppendOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRename() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RenameOp op = new RenameOp(client, "/file1", "/file2");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRename2() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        Rename2Op op = new Rename2Op(client, "/file1", "/file2");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testConcat() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        ConcatOp op = new ConcatOp(client, new Path("/test/file"), 5);
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testDelete() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        DeleteOp op = new DeleteOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testCreateSymlink() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        CreateSymlinkOp op = new CreateSymlinkOp(client, "/testfile", "/testlink");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testUpdatePipeline() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        UpdatePipelineOp op = new UpdatePipelineOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClientRetryWithFailover(final AtMostOnceOp op) throws Exception {
        final HashMap results = new HashMap();
        op.prepare();
        DummyRetryInvocationHandler.block.set(true);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    op.invoke();
                    Object result = op.getResult();
                    LOG.info((Object)("Operation " + op.name + " finished"));
                    TestRetryCacheWithHA testRetryCacheWithHA = TestRetryCacheWithHA.this;
                    synchronized (testRetryCacheWithHA) {
                        results.put(op.name, result == null ? "SUCCESS" : result);
                        TestRetryCacheWithHA.this.notifyAll();
                    }
                }
                catch (Exception e) {
                    try {
                        LOG.info((Object)("Got Exception while calling " + op.name), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanup(null, (Closeable[])new Closeable[]{op.client});
                        throw throwable;
                    }
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{op.client});
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{op.client});
            }
        }.start();
        Assert.assertTrue((String)("After waiting the operation " + op.name + " still has not taken effect on NN yet"), (boolean)op.checkNamenodeBeforeReturn());
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        LOG.info((Object)"Setting block to false");
        DummyRetryInvocationHandler.block.set(false);
        TestRetryCacheWithHA testRetryCacheWithHA = this;
        synchronized (testRetryCacheWithHA) {
            while (!results.containsKey(op.name)) {
                this.wait();
            }
            LOG.info((Object)("Got the result of " + op.name + ": " + results.get(op.name)));
        }
    }

    class UpdatePipelineOp
    extends AtMostOnceOp {
        private String file;
        private ExtendedBlock oldBlock;
        private ExtendedBlock newBlock;
        private DatanodeInfo[] nodes;
        private FSDataOutputStream out;

        public UpdatePipelineOp(DFSClient client, String file) {
            super("updatePipeline", client);
            this.file = file;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.file);
            DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 1024L, (short)3, 0L);
            this.out = this.client.append(this.file, 1024, null, null);
            byte[] appendContent = new byte[100];
            new Random().nextBytes(appendContent);
            this.out.write(appendContent);
            ((HdfsDataOutputStream)this.out).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            LocatedBlocks blks = TestRetryCacheWithHA.this.dfs.getClient().getLocatedBlocks(this.file, 1025L);
            Assert.assertEquals((long)1L, (long)blks.getLocatedBlocks().size());
            this.nodes = blks.get(0).getLocations();
            this.oldBlock = blks.get(0).getBlock();
            LocatedBlock newLbk = this.client.getNamenode().updateBlockForPipeline(this.oldBlock, this.client.getClientName());
            this.newBlock = new ExtendedBlock(this.oldBlock.getBlockPoolId(), this.oldBlock.getBlockId(), this.oldBlock.getNumBytes(), newLbk.getBlock().getGenerationStamp());
        }

        @Override
        void invoke() throws Exception {
            DatanodeInfo[] newNodes = new DatanodeInfo[]{this.nodes[0], this.nodes[1]};
            this.client.getNamenode().updatePipeline(this.client.getClientName(), this.oldBlock, this.newBlock, (DatanodeID[])newNodes);
            this.out.close();
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            INodeFileUnderConstruction fileNode = (INodeFileUnderConstruction)TestRetryCacheWithHA.this.cluster.getNamesystem(0).getFSDirectory().getINode4Write(this.file).asFile();
            BlockInfoUnderConstruction blkUC = (BlockInfoUnderConstruction)fileNode.getBlocks()[1];
            int datanodeNum = blkUC.getExpectedLocations().length;
            for (int i = 0; i < 10 && datanodeNum != 2; ++i) {
                Thread.sleep(1000L);
                datanodeNum = blkUC.getExpectedLocations().length;
            }
            return datanodeNum == 2;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class CreateSymlinkOp
    extends AtMostOnceOp {
        private String target;
        private String link;

        public CreateSymlinkOp(DFSClient client, String target, String link) {
            super("createSymlink", client);
            this.target = target;
            this.link = link;
        }

        @Override
        void prepare() throws Exception {
            Path p = new Path(this.target);
            if (!TestRetryCacheWithHA.this.dfs.exists(p)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, p, 1024L, (short)3, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.createSymlink(this.target, this.link, false);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path linkPath = new Path(this.link);
            FileStatus linkStatus = null;
            for (int i = 0; i < 10 && linkStatus == null; ++i) {
                try {
                    linkStatus = TestRetryCacheWithHA.this.dfs.getFileLinkStatus(linkPath);
                    continue;
                }
                catch (FileNotFoundException fnf) {
                    Thread.sleep(1000L);
                }
            }
            return linkStatus != null;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class DeleteOp
    extends AtMostOnceOp {
        private String target;
        private boolean deleted;

        DeleteOp(DFSClient client, String target) {
            super("delete", client);
            this.target = target;
        }

        @Override
        void prepare() throws Exception {
            Path p = new Path(this.target);
            if (!TestRetryCacheWithHA.this.dfs.exists(p)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, p, 1024L, (short)3, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.deleted = this.client.delete(this.target, true);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.target);
            boolean del = !TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !del; ++i) {
                Thread.sleep(1000L);
                del = !TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return del;
        }

        @Override
        Object getResult() {
            return new Boolean(this.deleted);
        }
    }

    class ConcatOp
    extends AtMostOnceOp {
        private String target;
        private String[] srcs;
        private Path[] srcPaths;

        ConcatOp(DFSClient client, Path target, int numSrc) {
            super("concat", client);
            this.target = target.toString();
            this.srcs = new String[numSrc];
            this.srcPaths = new Path[numSrc];
            Path parent = target.getParent();
            for (int i = 0; i < numSrc; ++i) {
                this.srcPaths[i] = new Path(parent, "srcfile" + i);
                this.srcs[i] = this.srcPaths[i].toString();
            }
        }

        @Override
        void prepare() throws Exception {
            DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, new Path(this.target), 1024L, (short)3, 0L);
            for (int i = 0; i < this.srcPaths.length; ++i) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, this.srcPaths[i], 1024L, (short)3, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.concat(this.target, this.srcs);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.target);
            boolean done = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !done; ++i) {
                Thread.sleep(1000L);
                done = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return done;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class Rename2Op
    extends AtMostOnceOp {
        private String oldName;
        private String newName;

        Rename2Op(DFSClient client, String oldName, String newName) {
            super("rename2", client);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.oldName);
            if (!TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 1024L, (short)3, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.rename(this.oldName, this.newName, new Options.Rename[]{Options.Rename.OVERWRITE});
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.newName);
            boolean renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !renamed; ++i) {
                Thread.sleep(1000L);
                renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return renamed;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class RenameOp
    extends AtMostOnceOp {
        private String oldName;
        private String newName;
        private boolean renamed;

        RenameOp(DFSClient client, String oldName, String newName) {
            super("rename", client);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.oldName);
            if (!TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 1024L, (short)3, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.renamed = this.client.rename(this.oldName, this.newName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.newName);
            boolean renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !renamed; ++i) {
                Thread.sleep(1000L);
                renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return renamed;
        }

        @Override
        Object getResult() {
            return new Boolean(this.renamed);
        }
    }

    class AppendOp
    extends AtMostOnceOp {
        private String fileName;
        private LocatedBlock lbk;

        AppendOp(DFSClient client, String fileName) {
            super("append", client);
            this.fileName = fileName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.fileName);
            if (!TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 512L, (short)3, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.lbk = this.client.getNamenode().append(this.fileName, this.client.getClientName());
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            INodeFile fileNode = TestRetryCacheWithHA.this.cluster.getNameNode(0).getNamesystem().getFSDirectory().getINode4Write(this.fileName).asFile();
            boolean fileIsUC = fileNode.isUnderConstruction();
            for (int i = 0; i < 10 && !fileIsUC; ++i) {
                Thread.sleep(1000L);
                fileNode = TestRetryCacheWithHA.this.cluster.getNameNode(0).getNamesystem().getFSDirectory().getINode4Write(this.fileName).asFile();
                fileIsUC = fileNode.isUnderConstruction();
            }
            return fileIsUC;
        }

        @Override
        Object getResult() {
            return this.lbk;
        }
    }

    class CreateOp
    extends AtMostOnceOp {
        private String fileName;
        private HdfsFileStatus status;

        CreateOp(DFSClient client, String fileName) {
            super("create", client);
            this.fileName = fileName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.fileName);
            if (TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                TestRetryCacheWithHA.this.dfs.delete(filePath, true);
            }
            Path fileParent = filePath.getParent();
            if (!TestRetryCacheWithHA.this.dfs.exists(fileParent)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(fileParent);
            }
        }

        @Override
        void invoke() throws Exception {
            EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
            this.status = this.client.getNamenode().create(this.fileName, FsPermission.getFileDefault(), this.client.getClientName(), new EnumSetWritable(createFlag), false, (short)3, 1024L);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path filePath = new Path(this.fileName);
            boolean fileCreated = TestRetryCacheWithHA.this.dfs.exists(filePath);
            for (int i = 0; i < 10 && !fileCreated; ++i) {
                Thread.sleep(1000L);
                fileCreated = TestRetryCacheWithHA.this.dfs.exists(filePath);
            }
            return fileCreated;
        }

        @Override
        Object getResult() {
            return this.status;
        }
    }

    class RenameSnapshotOp
    extends AtMostOnceOp {
        private String dir;
        private String oldName;
        private String newName;

        RenameSnapshotOp(DFSClient client, String dir, String oldName, String newName) {
            super("renameSnapshot", client);
            this.dir = dir;
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        void prepare() throws Exception {
            Path dirPath = new Path(this.dir);
            if (!TestRetryCacheWithHA.this.dfs.exists(dirPath)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(dirPath);
            }
            Path sPath = SnapshotTestHelper.getSnapshotRoot(dirPath, this.oldName);
            if (!TestRetryCacheWithHA.this.dfs.exists(sPath)) {
                TestRetryCacheWithHA.this.dfs.allowSnapshot(dirPath);
                TestRetryCacheWithHA.this.dfs.createSnapshot(dirPath, this.oldName);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.renameSnapshot(this.dir, this.oldName, this.newName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path sPath = SnapshotTestHelper.getSnapshotRoot(new Path(this.dir), this.newName);
            boolean snapshotRenamed = TestRetryCacheWithHA.this.dfs.exists(sPath);
            for (int i = 0; i < 10 && !snapshotRenamed; ++i) {
                Thread.sleep(1000L);
                snapshotRenamed = TestRetryCacheWithHA.this.dfs.exists(sPath);
            }
            return snapshotRenamed;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class DeleteSnapshotOp
    extends AtMostOnceOp {
        private String dir;
        private String snapshotName;

        DeleteSnapshotOp(DFSClient client, String dir, String snapshotName) {
            super("deleteSnapshot", client);
            this.dir = dir;
            this.snapshotName = snapshotName;
        }

        @Override
        void prepare() throws Exception {
            Path dirPath = new Path(this.dir);
            if (!TestRetryCacheWithHA.this.dfs.exists(dirPath)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(dirPath);
            }
            Path sPath = SnapshotTestHelper.getSnapshotRoot(dirPath, this.snapshotName);
            if (!TestRetryCacheWithHA.this.dfs.exists(sPath)) {
                TestRetryCacheWithHA.this.dfs.allowSnapshot(dirPath);
                TestRetryCacheWithHA.this.dfs.createSnapshot(dirPath, this.snapshotName);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.deleteSnapshot(this.dir, this.snapshotName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path sPath = SnapshotTestHelper.getSnapshotRoot(new Path(this.dir), this.snapshotName);
            boolean snapshotNotDeleted = TestRetryCacheWithHA.this.dfs.exists(sPath);
            for (int i = 0; i < 10 && snapshotNotDeleted; ++i) {
                Thread.sleep(1000L);
                snapshotNotDeleted = TestRetryCacheWithHA.this.dfs.exists(sPath);
            }
            return !snapshotNotDeleted;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class CreateSnapshotOp
    extends AtMostOnceOp {
        private String snapshotPath;
        private String dir;
        private String snapshotName;

        CreateSnapshotOp(DFSClient client, String dir, String snapshotName) {
            super("createSnapshot", client);
            this.dir = dir;
            this.snapshotName = snapshotName;
        }

        @Override
        void prepare() throws Exception {
            Path dirPath = new Path(this.dir);
            if (!TestRetryCacheWithHA.this.dfs.exists(dirPath)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(dirPath);
                TestRetryCacheWithHA.this.dfs.allowSnapshot(dirPath);
            }
        }

        @Override
        void invoke() throws Exception {
            this.snapshotPath = this.client.createSnapshot(this.dir, this.snapshotName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path sPath = SnapshotTestHelper.getSnapshotRoot(new Path(this.dir), this.snapshotName);
            boolean snapshotCreated = TestRetryCacheWithHA.this.dfs.exists(sPath);
            for (int i = 0; i < 10 && !snapshotCreated; ++i) {
                Thread.sleep(1000L);
                snapshotCreated = TestRetryCacheWithHA.this.dfs.exists(sPath);
            }
            return snapshotCreated;
        }

        @Override
        Object getResult() {
            return this.snapshotPath;
        }
    }

    abstract class AtMostOnceOp {
        private final String name;
        final DFSClient client;

        AtMostOnceOp(String name, DFSClient client) {
            this.name = name;
            this.client = client;
        }

        abstract void prepare() throws Exception;

        abstract void invoke() throws Exception;

        abstract boolean checkNamenodeBeforeReturn() throws Exception;

        abstract Object getResult();
    }

    private static class DummyRetryInvocationHandler
    extends RetryInvocationHandler<ClientProtocol> {
        static AtomicBoolean block = new AtomicBoolean(false);

        DummyRetryInvocationHandler(FailoverProxyProvider<ClientProtocol> proxyProvider, RetryPolicy retryPolicy) {
            super(proxyProvider, retryPolicy);
        }

        protected Object invokeMethod(Method method, Object[] args) throws Throwable {
            Object result = super.invokeMethod(method, args);
            if (block.get()) {
                throw new UnknownHostException("Fake Exception");
            }
            return result;
        }
    }
}

