/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNNHealthCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNNHealthCheck() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).nnTopology(MiniDFSNNTopology.simpleHATopology()).buildHDFS();
            NameNodeResourceChecker mockResourceChecker = (NameNodeResourceChecker)Mockito.mock(NameNodeResourceChecker.class);
            ((NameNodeResourceChecker)Mockito.doReturn((Object)true).when((Object)mockResourceChecker)).hasAvailableDiskSpace();
            ((MiniHDFSCluster)cluster).getNameNode(0).getNamesystem().setNNResourceChecker(mockResourceChecker);
            NamenodeProtocols rpc = ((MiniHDFSCluster)cluster).getNameNodeRpc(0);
            rpc.monitorHealth();
            ((NameNodeResourceChecker)Mockito.doReturn((Object)false).when((Object)mockResourceChecker)).hasAvailableDiskSpace();
            try {
                rpc.monitorHealth();
                Assert.fail((String)"Should not have succeeded in calling monitorHealth");
            }
            catch (HealthCheckFailedException hcfe) {
                GenericTestUtils.assertExceptionContains((String)"The NameNode has no resources available", (Throwable)hcfe);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

