/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestHAFsck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHaFsck() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ha-nn-uri-0").addNN(new MiniDFSNNTopology.NNConf("nn1").setHttpPort(10001)).addNN(new MiniDFSNNTopology.NNConf("nn2").setHttpPort(10002)));
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).buildHDFS();
        FileSystem fs = null;
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            HATestUtil.setFailoverConfigurations(cluster, conf, "ha-nn-uri-0", 0);
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            fs.mkdirs(new Path("/test1"));
            fs.mkdirs(new Path("/test2"));
            TestHAFsck.runFsck(conf);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            TestHAFsck.runFsck(conf);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void runFsck(Configuration conf) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])new String[]{"/", "-files"});
        String result = bStream.toString();
        System.out.println("output from fsck:\n" + result);
        Assert.assertEquals((long)0L, (long)errCode);
        Assert.assertTrue((boolean)result.contains("/test1"));
        Assert.assertTrue((boolean)result.contains("/test2"));
    }

    static {
        ((Log4JLogger)LogFactory.getLog(DFSUtil.class)).getLogger().setLevel(Level.ALL);
    }
}

