/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestFailureOfSharedDir {
    @Test
    public void testSharedDirIsAutomaticallyMarkedRequired() throws URISyntaxException {
        URI foo = new URI("file:/foo");
        URI bar = new URI("file:/bar");
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.dir", Joiner.on((String)",").join((Object)foo, (Object)bar, new Object[0]));
        conf.set("dfs.namenode.edits.dir.required", foo.toString());
        Assert.assertFalse((boolean)FSNamesystem.getRequiredNamespaceEditsDirs((Configuration)conf).contains(bar));
        conf.set("dfs.namenode.shared.edits.dir", bar.toString());
        Collection requiredEditsDirs = FSNamesystem.getRequiredNamespaceEditsDirs((Configuration)conf);
        Assert.assertTrue((String)(Joiner.on((String)",").join((Iterable)requiredEditsDirs) + " does not contain " + bar), (boolean)requiredEditsDirs.contains(bar));
    }

    @Test
    public void testMultipleSharedDirsFails() throws Exception {
        Configuration conf = new Configuration();
        URI sharedA = new URI("file:///shared-A");
        URI sharedB = new URI("file:///shared-B");
        URI localA = new URI("file:///local-A");
        conf.set("dfs.namenode.shared.edits.dir", Joiner.on((String)",").join((Object)sharedA, (Object)sharedB, new Object[0]));
        conf.set("dfs.namenode.edits.dir", localA.toString());
        try {
            FSNamesystem.getNamespaceEditsDirs((Configuration)conf);
            Assert.fail((String)"Allowed multiple shared edits directories");
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"Multiple shared edits directories are not yet supported", (Object)ioe.getMessage());
        }
    }

    @Test
    public void testSharedDirsComeFirstInEditsList() throws Exception {
        Configuration conf = new Configuration();
        URI sharedA = new URI("file:///shared-A");
        URI localA = new URI("file:///local-A");
        URI localB = new URI("file:///local-B");
        URI localC = new URI("file:///local-C");
        conf.set("dfs.namenode.shared.edits.dir", sharedA.toString());
        conf.set("dfs.namenode.edits.dir", Joiner.on((String)",").join((Object)localC, (Object)localB, new Object[]{localA}));
        List dirs = FSNamesystem.getNamespaceEditsDirs((Configuration)conf);
        Assert.assertEquals((String)"Shared dirs should come first, then local dirs, in the order they were listed in the configuration.", (Object)Joiner.on((String)",").join((Object)sharedA, (Object)localC, new Object[]{localB, localA}), (Object)Joiner.on((String)",").join((Iterable)dirs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailureOfSharedDir() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.namenode.resource.check.interval", 2000L);
        MiniDFSCluster cluster = null;
        File sharedEditsDir = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).checkExitOnShutdown(false).buildHDFS();
            ((MiniHDFSCluster)cluster).waitActive();
            ((MiniHDFSCluster)cluster).transitionToActive(0);
            FileSystem fs = HATestUtil.configureFailoverFs((MiniHDFSCluster)cluster, conf);
            Assert.assertTrue((boolean)fs.mkdirs(new Path("/test1")));
            URI sharedEditsUri = ((MiniHDFSCluster)cluster).getSharedEditsDir(0, 1);
            sharedEditsDir = new File(sharedEditsUri);
            Assert.assertEquals((long)0L, (long)FileUtil.chmod((String)sharedEditsDir.getAbsolutePath(), (String)"-w", (boolean)true));
            Thread.sleep(conf.getLong("dfs.namenode.resource.check.interval", 5000L) * 2L);
            NameNode nn1 = ((MiniHDFSCluster)cluster).getNameNode(1);
            Assert.assertTrue((boolean)nn1.isStandbyState());
            Assert.assertFalse((String)"StandBy NameNode should not go to SafeMode on resource unavailability", (boolean)nn1.isInSafeMode());
            NameNode nn0 = ((MiniHDFSCluster)cluster).getNameNode(0);
            try {
                nn0.getRpcServer().rollEditLog();
                Assert.fail((String)"Succeeded in rolling edit log despite shared dir being deleted");
            }
            catch (ExitUtil.ExitException ee) {
                GenericTestUtils.assertExceptionContains((String)"finalize log segment 1, 3 failed for required journal", (Throwable)ee);
            }
            for (URI editsUri : ((MiniHDFSCluster)cluster).getNameEditsDirs(0)) {
                if (editsUri.equals(sharedEditsUri)) continue;
                File editsDir = new File(editsUri.getPath());
                File curDir = new File(editsDir, "current");
                GenericTestUtils.assertGlobEquals((File)curDir, (String)"edits_.*", (String[])new String[]{NNStorage.getInProgressEditsFileName((long)1L)});
            }
        }
        finally {
            if (sharedEditsDir != null) {
                FileUtil.chmod((String)sharedEditsDir.getAbsolutePath(), (String)"+w", (boolean)true);
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

