/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSUpgradeWithHA {
    private static final Log LOG = LogFactory.getLog(TestDFSUpgradeWithHA.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartingWithUpgradeOptionsFails() throws IOException {
        for (HdfsServerConstants.StartupOption startOpt : Lists.newArrayList((Object[])new HdfsServerConstants.StartupOption[]{HdfsServerConstants.StartupOption.UPGRADE, HdfsServerConstants.StartupOption.FINALIZE, HdfsServerConstants.StartupOption.ROLLBACK})) {
            MiniDFSCluster cluster = null;
            try {
                cluster = new MiniDFSCluster.Builder(new Configuration()).nnTopology(MiniDFSNNTopology.simpleHATopology()).startupOption(startOpt).numDataNodes(0).buildHDFS();
                Assert.fail((String)"Should not have been able to start an HA NN in upgrade mode");
            }
            catch (IllegalArgumentException iae) {
                GenericTestUtils.assertExceptionContains((String)"Cannot perform DFS upgrade with HA enabled.", (Throwable)iae);
                LOG.info((Object)"Got expected exception", (Throwable)iae);
            }
            finally {
                if (cluster == null) continue;
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartingWithUpgradeInProgressFails() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(new Configuration()).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).buildHDFS();
            for (int i = 0; i < 2; ++i) {
                for (URI uri : ((MiniHDFSCluster)cluster).getNameDirs(i)) {
                    File prevTmp = new File(new File(uri), "previous.tmp");
                    LOG.info((Object)("creating previous tmp dir: " + prevTmp));
                    Assert.assertTrue((boolean)prevTmp.mkdirs());
                }
            }
            ((MiniHDFSCluster)cluster).restartNameNodes();
            Assert.fail((String)"Should not have been able to start an HA NN with an in-progress upgrade");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot start an HA namenode with name dirs that need recovery.", (Throwable)ioe);
            LOG.info((Object)"Got expected exception", (Throwable)ioe);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

