/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSecondaryWebUi {
    private static MiniHDFSCluster cluster;
    private static SecondaryNameNode snn;
    private static Configuration conf;

    @BeforeClass
    public static void setUpCluster() throws IOException {
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).buildHDFS();
        cluster.waitActive();
        snn = new SecondaryNameNode(conf);
    }

    @AfterClass
    public static void shutDownCluster() {
        if (cluster != null) {
            cluster.shutdown();
        }
        if (snn != null) {
            snn.shutdown();
        }
    }

    @Test
    public void testSecondaryWebUi() throws IOException {
        String pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + SecondaryNameNode.getHttpAddress((Configuration)conf).getPort() + "/status.jsp"));
        Assert.assertTrue((boolean)pageContents.contains("Last Checkpoint Time"));
    }

    @Test
    public void testSecondaryWebJmx() throws MalformedURLException, IOException {
        String pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + SecondaryNameNode.getHttpAddress((Configuration)conf).getPort() + "/jmx"));
        Assert.assertTrue((boolean)pageContents.contains("Hadoop:service=SecondaryNameNode,name=JvmMetrics"));
    }

    static {
        conf = new Configuration();
    }
}

