/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSecondaryNameNodeUpgrade {
    @Before
    public void cleanupCluster() throws IOException {
        File hdfsDir = new File(MiniHDFSCluster.getBaseDirectory()).getCanonicalFile();
        System.out.println("cleanupCluster deleting " + hdfsDir);
        if (hdfsDir.exists() && !FileUtil.fullyDelete((File)hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + hdfsDir + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIt(Map<String, String> paramsToCorrupt) throws IOException {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        SecondaryNameNode snn = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
            ((MiniHDFSCluster)cluster).waitActive();
            conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
            snn = new SecondaryNameNode((Configuration)conf);
            fs = ((MiniHDFSCluster)cluster).getFileSystem();
            fs.mkdirs(new Path("/test/foo"));
            snn.doCheckpoint();
            List versionFiles = snn.getFSImage().getStorage().getFiles(null, "VERSION");
            snn.shutdown();
            for (File versionFile : versionFiles) {
                for (Map.Entry<String, String> paramToCorrupt : paramsToCorrupt.entrySet()) {
                    String param = paramToCorrupt.getKey();
                    String val = paramToCorrupt.getValue();
                    System.out.println("Changing '" + param + "' to '" + val + "' in " + versionFile);
                    FSImageTestUtil.corruptVersionFile(versionFile, param, val);
                }
            }
            snn = new SecondaryNameNode((Configuration)conf);
            fs.mkdirs(new Path("/test/bar"));
            snn.doCheckpoint();
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            if (snn != null) {
                snn.shutdown();
            }
        }
    }

    @Test
    public void testUpgradeLayoutVersionSucceeds() throws IOException {
        this.doIt((Map<String, String>)ImmutableMap.of((Object)"layoutVersion", (Object)"-39"));
    }

    @Test
    public void testUpgradePreFedSucceeds() throws IOException {
        this.doIt((Map<String, String>)ImmutableMap.of((Object)"layoutVersion", (Object)"-19", (Object)"clusterID", (Object)"", (Object)"blockpoolID", (Object)""));
    }

    @Test
    public void testChangeNsIDFails() throws IOException {
        try {
            this.doIt((Map<String, String>)ImmutableMap.of((Object)"namespaceID", (Object)"2"));
            Assert.fail((String)"Should throw InconsistentFSStateException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Inconsistent checkpoint fields", (Throwable)e);
            System.out.println("Correctly failed with inconsistent namespaceID: " + e);
        }
    }
}

