/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestFSNamesystem {
    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniHDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testUniqueEditDirs() throws IOException {
        Configuration config = new Configuration();
        config.set("dfs.namenode.edits.dir", "file://edits/dir, file://edits/dir1,file://edits/dir1");
        List editsDirs = FSNamesystem.getNamespaceEditsDirs((Configuration)config);
        Assert.assertEquals((long)2L, (long)editsDirs.size());
    }

    @Test
    public void testFSNamespaceClearLeases() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniHDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        LeaseManager leaseMan = fsn.getLeaseManager();
        leaseMan.addLease("client1", "importantFile");
        Assert.assertEquals((long)1L, (long)leaseMan.countLease());
        fsn.clear();
        leaseMan = fsn.getLeaseManager();
        Assert.assertEquals((long)0L, (long)leaseMan.countLease());
    }

    @Test
    public void testStartupSafemode() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsn.leaveSafeMode();
        Assert.assertTrue((String)"After leaving safemode FSNamesystem.isInStartupSafeMode still returned true", (!fsn.isInStartupSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"After leaving safemode FSNamesystem.isInSafeMode still returned true", (!fsn.isInSafeMode() ? 1 : 0) != 0);
        fsn.enterSafeMode(true);
        Assert.assertTrue((String)"After entering safemode due to low resources FSNamesystem.isInStartupSafeMode still returned true", (!fsn.isInStartupSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"After entering safemode due to low resources FSNamesystem.isInSafeMode still returned false", (boolean)fsn.isInSafeMode());
    }

    @Test
    public void testReplQueuesActiveAfterStartupSafemode() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsNamesystem = new FSNamesystem(conf, fsImage);
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)fsNamesystem);
        HAContext haContext = (HAContext)Mockito.mock(HAContext.class);
        HAState haState = (HAState)Mockito.mock(HAState.class);
        Mockito.when((Object)haContext.getState()).thenReturn((Object)haState);
        Mockito.when((Object)haState.shouldPopulateReplQueues()).thenReturn((Object)true);
        Whitebox.setInternalState((Object)fsn, (String)"haContext", (Object)haContext);
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        fsn.enterSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't enter safemode", (boolean)fsn.isInSafeMode());
        Assert.assertTrue((String)"Replication queues were being populated during very first safemode", (!fsn.isPopulatingReplQueues() ? 1 : 0) != 0);
        fsn.leaveSafeMode();
        Assert.assertTrue((String)"FSNamesystem didn't leave safemode", (!fsn.isInSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Replication queues weren't being populated even after leaving safemode", (boolean)fsn.isPopulatingReplQueues());
        fsn.enterSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't enter safemode", (boolean)fsn.isInSafeMode());
        Assert.assertTrue((String)"Replication queues weren't being populated after entering safemode 2nd time", (boolean)fsn.isPopulatingReplQueues());
    }
}

