/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;
import org.junit.Assert;
import org.junit.Test;

public class TestWriteToReplica {
    private static final int FINALIZED = 0;
    private static final int TEMPORARY = 1;
    private static final int RBW = 2;
    private static final int RWR = 3;
    private static final int RUR = 4;
    private static final int NON_EXISTENT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() throws Exception {
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).buildHDFS();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testClose(dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).buildHDFS();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testAppend(bpid, dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToRbw() throws Exception {
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).buildHDFS();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testWriteToRbw(dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToTempoary() throws Exception {
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).buildHDFS();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testWriteToTemporary(dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    private ExtendedBlock[] setup(String bpid, FsDatasetImpl dataSet) throws IOException {
        ExtendedBlock[] blocks = new ExtendedBlock[]{new ExtendedBlock(bpid, 1L, 1L, 2001L), new ExtendedBlock(bpid, 2L, 1L, 2002L), new ExtendedBlock(bpid, 3L, 1L, 2003L), new ExtendedBlock(bpid, 4L, 1L, 2004L), new ExtendedBlock(bpid, 5L, 1L, 2005L), new ExtendedBlock(bpid, 6L, 1L, 2006L)};
        ReplicaMap replicasMap = dataSet.volumeMap;
        FsVolumeImpl vol = dataSet.volumes.getNextVolume(0L);
        FinalizedReplica replicaInfo = new FinalizedReplica(blocks[0].getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile());
        replicasMap.add(bpid, (ReplicaInfo)replicaInfo);
        replicaInfo.getBlockFile().createNewFile();
        replicaInfo.getMetaFile().createNewFile();
        replicasMap.add(bpid, (ReplicaInfo)new ReplicaInPipeline(blocks[1].getBlockId(), blocks[1].getGenerationStamp(), (FsVolumeSpi)vol, vol.createTmpFile(bpid, blocks[1].getLocalBlock()).getParentFile()));
        replicaInfo = new ReplicaBeingWritten(blocks[2].getLocalBlock(), (FsVolumeSpi)vol, vol.createRbwFile(bpid, blocks[2].getLocalBlock()).getParentFile(), null);
        replicasMap.add(bpid, (ReplicaInfo)replicaInfo);
        replicaInfo.getBlockFile().createNewFile();
        replicaInfo.getMetaFile().createNewFile();
        replicasMap.add(bpid, (ReplicaInfo)new ReplicaWaitingToBeRecovered(blocks[3].getLocalBlock(), (FsVolumeSpi)vol, vol.createRbwFile(bpid, blocks[3].getLocalBlock()).getParentFile()));
        replicasMap.add(bpid, (ReplicaInfo)new ReplicaUnderRecovery((ReplicaInfo)new FinalizedReplica(blocks[4].getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile()), 2007L));
        return blocks;
    }

    private void testAppend(String bpid, FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        long newGS = blocks[0].getGenerationStamp() + 1L;
        FsVolumeImpl v = (FsVolumeImpl)dataSet.volumeMap.get(bpid, blocks[0].getLocalBlock()).getVolume();
        long available = v.getCapacity() - v.getDfsUsed();
        long expectedLen = blocks[0].getNumBytes();
        try {
            v.decDfsUsed(bpid, -available);
            blocks[0].setNumBytes(expectedLen + 100L);
            dataSet.append(blocks[0], newGS, expectedLen);
            Assert.fail((String)("Should not have space to append to an RWR replica" + blocks[3]));
        }
        catch (DiskChecker.DiskOutOfSpaceException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Insufficient space for appending to "));
        }
        v.decDfsUsed(bpid, available);
        blocks[0].setNumBytes(expectedLen);
        newGS = blocks[2].getGenerationStamp() + 1L;
        dataSet.append(blocks[0], newGS, blocks[0].getNumBytes());
        blocks[0].setGenerationStamp(newGS);
        try {
            dataSet.append(blocks[1], blocks[1].getGenerationStamp() + 1L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have appended to a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[1]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[2], blocks[2].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have appended to an RBW replica" + blocks[2]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[2]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[3], blocks[3].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have appended to an RWR replica" + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[3]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[4], blocks[4].getGenerationStamp() + 1L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have appended to an RUR replica" + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[4]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[5], blocks[5].getGenerationStamp(), blocks[5].getNumBytes());
            Assert.fail((String)("Should not have appended to a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to a non-existent replica " + blocks[5]), (Object)e.getMessage());
        }
        newGS = blocks[0].getGenerationStamp() + 1L;
        dataSet.recoverAppend(blocks[0], newGS, blocks[0].getNumBytes());
        blocks[0].setGenerationStamp(newGS);
        try {
            dataSet.recoverAppend(blocks[1], blocks[1].getGenerationStamp() + 1L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have appended to a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        newGS = blocks[2].getGenerationStamp() + 1L;
        dataSet.recoverAppend(blocks[2], newGS, blocks[2].getNumBytes());
        blocks[2].setGenerationStamp(newGS);
        try {
            dataSet.recoverAppend(blocks[3], blocks[3].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have appended to an RWR replica" + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverAppend(blocks[4], blocks[4].getGenerationStamp() + 1L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have appended to an RUR replica" + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverAppend(blocks[5], blocks[5].getGenerationStamp(), blocks[5].getNumBytes());
            Assert.fail((String)("Should not have appended to a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot append to a non-existent replica "));
        }
    }

    private void testClose(FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        long newGS = blocks[0].getGenerationStamp() + 1L;
        dataSet.recoverClose(blocks[0], newGS, blocks[0].getNumBytes());
        blocks[0].setGenerationStamp(newGS);
        try {
            dataSet.recoverClose(blocks[1], blocks[1].getGenerationStamp() + 1L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have recovered close a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        newGS = blocks[2].getGenerationStamp() + 1L;
        dataSet.recoverClose(blocks[2], newGS, blocks[2].getNumBytes());
        blocks[2].setGenerationStamp(newGS);
        try {
            dataSet.recoverClose(blocks[3], blocks[3].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have recovered close an RWR replica" + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverClose(blocks[4], blocks[4].getGenerationStamp() + 1L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have recovered close an RUR replica" + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverClose(blocks[5], blocks[5].getGenerationStamp(), blocks[5].getNumBytes());
            Assert.fail((String)("Should not have recovered close a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot append to a non-existent replica "));
        }
    }

    private void testWriteToRbw(FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        try {
            dataSet.recoverRbw(blocks[0], blocks[0].getGenerationStamp() + 1L, 0L, blocks[0].getNumBytes());
            Assert.fail((String)("Should not have recovered a finalized replica " + blocks[0]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(blocks[0]);
            Assert.fail((String)("Should not have created a replica that's already finalized " + blocks[0]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[1], blocks[1].getGenerationStamp() + 1L, 0L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have recovered a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(blocks[1]);
            Assert.fail((String)("Should not have created a replica that had created as temporary " + blocks[1]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        dataSet.recoverRbw(blocks[2], blocks[2].getGenerationStamp() + 1L, 0L, blocks[2].getNumBytes());
        try {
            dataSet.createRbw(blocks[2]);
            Assert.fail((String)("Should not have created a replica that had created as RBW " + blocks[2]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[3], blocks[3].getGenerationStamp() + 1L, 0L, blocks[3].getNumBytes());
            Assert.fail((String)("Should not have recovered a RWR replica " + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(blocks[3]);
            Assert.fail((String)("Should not have created a replica that was waiting to be recovered " + blocks[3]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[4], blocks[4].getGenerationStamp() + 1L, 0L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have recovered a RUR replica " + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(blocks[4]);
            Assert.fail((String)("Should not have created a replica that was under recovery " + blocks[4]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[5], blocks[5].getGenerationStamp() + 1L, 0L, blocks[5].getNumBytes());
            Assert.fail((String)("Cannot recover a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot append to a non-existent replica "));
        }
        dataSet.createRbw(blocks[5]);
    }

    private void testWriteToTemporary(FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        try {
            dataSet.createTemporary(blocks[0]);
            Assert.fail((String)("Should not have created a temporary replica that was finalized " + blocks[0]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(blocks[1]);
            Assert.fail((String)("Should not have created a replica that had created astemporary " + blocks[1]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(blocks[2]);
            Assert.fail((String)("Should not have created a replica that had created as RBW " + blocks[2]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(blocks[3]);
            Assert.fail((String)("Should not have created a replica that was waiting to be recovered " + blocks[3]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(blocks[4]);
            Assert.fail((String)("Should not have created a replica that was under recovery " + blocks[4]));
        }
        catch (ReplicaAlreadyExistsException replicaAlreadyExistsException) {
            // empty catch block
        }
        dataSet.createTemporary(blocks[5]);
    }
}

