/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataOutputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.util.DataChecksum;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDiskError {
    private FileSystem fs;
    private MiniHDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).buildHDFS();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdown() throws Exception {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return;
        }
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        boolean dnIndex = false;
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        File storageDir = this.cluster.getInstanceStorageDir(0, 0);
        File dir1 = MiniHDFSCluster.getRbwDir(storageDir, bpid);
        storageDir = this.cluster.getInstanceStorageDir(0, 1);
        File dir2 = MiniHDFSCluster.getRbwDir(storageDir, bpid);
        try {
            Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dir1.setReadOnly());
            Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dir2.setReadOnly());
            DataNode dn = this.cluster.getDataNodes().get(0);
            int i = 0;
            while (dn.isDatanodeUp()) {
                Path fileName = new Path("/test.txt" + i);
                DFSTestUtil.createFile(this.fs, fileName, 1024L, (short)2, 1L);
                DFSTestUtil.waitReplication(this.fs, fileName, (short)2);
                this.fs.delete(fileName, true);
                ++i;
            }
        }
        finally {
            FileUtil.setWritable((File)dir1, (boolean)true);
            FileUtil.setWritable((File)dir2, (boolean)true);
        }
    }

    @Test
    public void testReplicationError() throws Exception {
        Path fileName = new Path("/test.txt");
        boolean fileLen = true;
        DFSTestUtil.createFile(this.fs, fileName, 1L, (short)1, 1L);
        DFSTestUtil.waitReplication(this.fs, fileName, (short)1);
        LocatedBlocks blocks = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(), fileName.toString(), 0L, 1L);
        Assert.assertEquals((String)"Should only find 1 block", (long)blocks.locatedBlockCount(), (long)1L);
        LocatedBlock block = blocks.get(0);
        this.cluster.startDataNodes(this.conf, 1, true, null, null);
        this.cluster.waitActive();
        boolean sndNode = true;
        DataNode datanode = this.cluster.getDataNodes().get(1);
        InetSocketAddress target = datanode.getXferAddress();
        Socket s = new Socket(target.getAddress(), target.getPort());
        DataOutputStream out = new DataOutputStream(s.getOutputStream());
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512);
        new Sender(out).writeBlock(block.getBlock(), BlockTokenSecretManager.DUMMY_TOKEN, "", new DatanodeInfo[0], null, BlockConstructionStage.PIPELINE_SETUP_CREATE, 1, 0L, 0L, 0L, checksum, CachingStrategy.newDefaultStrategy());
        out.flush();
        out.close();
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        File storageDir = this.cluster.getInstanceStorageDir(1, 0);
        File dir1 = MiniHDFSCluster.getRbwDir(storageDir, bpid);
        storageDir = this.cluster.getInstanceStorageDir(1, 1);
        File dir2 = MiniHDFSCluster.getRbwDir(storageDir, bpid);
        while (dir1.listFiles().length != 0 || dir2.listFiles().length != 0) {
            Thread.sleep(100L);
        }
        this.fs.setReplication(fileName, (short)2);
        DFSTestUtil.waitReplication(this.fs, fileName, (short)1);
        this.fs.delete(fileName, false);
    }

    @Test
    public void testLocalDirs() throws Exception {
        Configuration conf = new Configuration();
        String permStr = conf.get("dfs.datanode.data.dir.perm");
        FsPermission expected = new FsPermission(permStr);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        for (DataNode dn : this.cluster.getDataNodes()) {
            String[] dataDirs;
            for (String dir : dataDirs = dn.getConf().getStrings("dfs.datanode.data.dir")) {
                Path dataDir = new Path(dir);
                FsPermission actual = localFS.getFileStatus(dataDir).getPermission();
                Assert.assertEquals((String)("Permission for dir: " + dataDir + ", is " + actual + ", while expected is " + expected), (Object)expected, (Object)actual);
            }
        }
    }
}

