/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestReplicationPolicy {
    private Random random = DFSUtil.getRandom();
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 6;
    private static NetworkTopology cluster;
    private static NameNode namenode;
    private static BlockPlacementPolicy replicator;
    private static final String filename = "/dummyfile.txt";
    private static DatanodeDescriptor[] dataNodes;
    private static long staleInterval;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void setupCluster() throws Exception {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d2/r3"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d2/r3")};
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        DFSTestUtil.formatNameNode((Configuration)conf);
        namenode = new NameNode((Configuration)conf);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        replicator = bm.getBlockPlacementPolicy();
        cluster = bm.getDatanodeManager().getNetworkTopology();
        for (i = 0; i < 6; ++i) {
            cluster.add((Node)dataNodes[i]);
            bm.getDatanodeManager().getHeartbeatManager().addDatanode(dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            dataNodes[i].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
        }
    }

    @Test
    public void testChooseTarget1() throws Exception {
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 4, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
    }

    private static DatanodeDescriptor[] chooseTarget(BlockPlacementPolicyDefault policy, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        return policy.chooseTarget(numOfReplicas, writer, chosenNodes, false, excludedNodes, blocksize);
    }

    @Test
    public void testChooseTarget2() throws Exception {
        int i;
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)replicator;
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        HashMap<Node, Node> excludedNodes = new HashMap<Node, Node>();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        DatanodeDescriptor[] targets = TestReplicationPolicy.chooseTarget(repl, 0, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 1, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 2, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 3, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 4, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        for (i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        chosenNodes.add(dataNodes[2]);
        targets = repl.chooseTarget(1, dataNodes[0], chosenNodes, true, excludedNodes, 1024L);
        System.out.println("targets=" + Arrays.asList(targets));
        Assert.assertEquals((long)2L, (long)targets.length);
        for (i = 0; i < targets.length && !dataNodes[2].equals((Object)targets[i]); ++i) {
        }
        Assert.assertTrue((i < targets.length ? 1 : 0) != 0);
    }

    @Test
    public void testChooseTarget3() throws Exception {
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)((HdfsConstants.MIN_BLOCKS_FOR_WRITE - 1) * 1024), 0L, 0, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        for (int i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
    }

    @Test
    public void testChoooseTarget4() throws Exception {
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            dataNodes[i2].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)((HdfsConstants.MIN_BLOCKS_FOR_WRITE - 1) * 1024), 0L, 0, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        for (i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[i], (Node)dataNodes[0]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[0], (Node)targets[1]) || cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        for (i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
        }
    }

    @Test
    public void testChooseTarget5() throws Exception {
        DatanodeDescriptor writerDesc = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r4");
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, writerDesc, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, writerDesc, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = replicator.chooseTarget(filename, 2, writerDesc, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, writerDesc, new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithMoreThanAvailableNodesWithStaleness() throws Exception {
        try {
            namenode.getNamesystem().getBlockManager().getDatanodeManager().setNumStaleNodes(6);
            this.testChooseTargetWithMoreThanAvailableNodes();
        }
        finally {
            namenode.getNamesystem().getBlockManager().getDatanodeManager().setNumStaleNodes(0);
        }
    }

    @Test
    public void testChooseTargetWithMoreThanAvailableNodes() throws Exception {
        for (int i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)((HdfsConstants.MIN_BLOCKS_FOR_WRITE - 1) * 1024), 0L, 0, 0);
        }
        LogVerificationAppender appender = new LogVerificationAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 6, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        List<LoggingEvent> log = appender.getLog();
        Assert.assertNotNull(log);
        Assert.assertFalse((log.size() == 0 ? 1 : 0) != 0);
        LoggingEvent lastLogEntry = log.get(log.size() - 1);
        Assert.assertEquals((Object)lastLogEntry.getLevel(), (Object)Level.WARN);
        Assert.assertTrue((boolean)((String)lastLogEntry.getMessage()).contains("in need of 2"));
        for (int i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
        }
    }

    private boolean containsWithinRange(DatanodeDescriptor target, DatanodeDescriptor[] nodes, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < nodes.length);
        assert (endIndex >= startIndex && endIndex < nodes.length);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!nodes[i].equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testChooseTargetWithStaleNodes() throws Exception {
        dataNodes[0].setLastUpdate(Time.now() - staleInterval - 1L);
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        Assert.assertTrue((boolean)namenode.getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        HashMap<Node, Node> excludedNodes = new HashMap<Node, Node>();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)replicator;
        targets = TestReplicationPolicy.chooseTarget(repl, 1, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        dataNodes[0].setLastUpdate(Time.now());
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    @Test
    public void testChooseTargetWithHalfStaleNodes() throws Exception {
        for (int i = 0; i < 3; ++i) {
            dataNodes[i].setLastUpdate(Time.now() - staleInterval - 1L);
        }
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.containsWithinRange(targets[0], dataNodes, 0, 2));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.containsWithinRange(targets[0], dataNodes, 0, 2));
        Assert.assertFalse((boolean)this.containsWithinRange(targets[1], dataNodes, 0, 2));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.containsWithinRange(targets[0], dataNodes, 3, 5));
        Assert.assertTrue((boolean)this.containsWithinRange(targets[1], dataNodes, 3, 5));
        Assert.assertTrue((boolean)this.containsWithinRange(targets[2], dataNodes, 3, 5));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], new ArrayList(), 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertTrue((boolean)this.containsWithinRange(dataNodes[3], targets, 0, 3));
        Assert.assertTrue((boolean)this.containsWithinRange(dataNodes[4], targets, 0, 3));
        Assert.assertTrue((boolean)this.containsWithinRange(dataNodes[5], targets, 0, 3));
        for (int i = 0; i < dataNodes.length; ++i) {
            dataNodes[i].setLastUpdate(Time.now());
        }
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithMoreThanHalfStaleNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6"};
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
        MiniHDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)conf).racks(racks).hosts(hosts).numDataNodes(hosts.length).buildHDFS();
        miniCluster.waitActive();
        try {
            DataNode dn;
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                DataNode dn2 = miniCluster.getDataNodes().get(i2);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn2, true);
                miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn2.getDatanodeId()).setLastUpdate(Time.now() - staleInterval - 1L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            int numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)2L);
            Assert.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            DatanodeDescriptor staleNodeInfo = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(miniCluster.getDataNodes().get(0).getDatanodeId());
            BlockPlacementPolicy replicator = miniCluster.getNameNode().getNamesystem().getBlockManager().getBlockPlacementPolicy();
            DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 3, staleNodeInfo, new ArrayList(), 1024L);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)staleNodeInfo));
            for (i = 0; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
                miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).setLastUpdate(Time.now() - staleInterval - 1L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)4L);
            Assert.assertFalse((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            targets = replicator.chooseTarget(filename, 3, staleNodeInfo, new ArrayList(), 1024L);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[0], (Node)staleNodeInfo));
            for (i = 2; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
                miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).setLastUpdate(Time.now());
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)2L);
            Assert.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            targets = replicator.chooseTarget(filename, 3, staleNodeInfo, new ArrayList(), 1024L);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)staleNodeInfo));
        }
        finally {
            miniCluster.shutdown();
        }
    }

    @Test
    public void testRereplicate1() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[1]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[1]));
    }

    @Test
    public void testRereplicate3() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[2]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 1, dataNodes[2], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[2], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReplicationWithPriority() throws Exception {
        int DFS_NAMENODE_REPLICATION_INTERVAL = 1000;
        int HIGH_PRIORITY = 0;
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.replication.interval", 1);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).buildHDFS();
        try {
            cluster.waitActive();
            UnderReplicatedBlocks neededReplications = cluster.getNameNode().getNamesystem().getBlockManager().neededReplications;
            for (int i = 0; i < 100; ++i) {
                neededReplications.add(new Block(this.random.nextLong()), 2, 0, 3);
            }
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            neededReplications.add(new Block(this.random.nextLong()), 1, 0, 3);
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            Assert.assertFalse((String)"Not able to clear the element from high priority list", (boolean)neededReplications.iterator(HIGH_PRIORITY).hasNext());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChooseUnderReplicatedBlocks() throws Exception {
        UnderReplicatedBlocks underReplicatedBlocks = new UnderReplicatedBlocks();
        for (int i = 0; i < 5; ++i) {
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 1, 0, 3);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 2, 0, 7);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 6, 0, 6);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 5, 0, 6);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 0, 0, 3);
        }
        List chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(6);
        this.assertTheChosenBlocks(chosenBlocks, 5, 1, 0, 0, 0);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 0, 4, 5, 1, 0);
        underReplicatedBlocks.add(new Block(this.random.nextLong()), 1, 0, 3);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 4, 5);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(7);
        this.assertTheChosenBlocks(chosenBlocks, 6, 1, 0, 0, 0);
    }

    private void assertTheChosenBlocks(List<List<Block>> chosenBlocks, int firstPrioritySize, int secondPrioritySize, int thirdPrioritySize, int fourthPrioritySize, int fifthPrioritySize) {
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_HIGHEST_PRIORITY blocks", (long)firstPrioritySize, (long)chosenBlocks.get(0).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_VERY_UNDER_REPLICATED blocks", (long)secondPrioritySize, (long)chosenBlocks.get(1).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_UNDER_REPLICATED blocks", (long)thirdPrioritySize, (long)chosenBlocks.get(2).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_REPLICAS_BADLY_DISTRIBUTED blocks", (long)fourthPrioritySize, (long)chosenBlocks.get(3).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_WITH_CORRUPT_BLOCKS blocks", (long)fifthPrioritySize, (long)chosenBlocks.get(4).size());
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.5f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertEquals((double)blocksInvalidateWorkPct, (double)0.5, (double)((double)blocksInvalidateWorkPct * 1.0E-7));
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.0f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertEquals((double)blocksInvalidateWorkPct, (double)1.0, (double)((double)blocksInvalidateWorkPct * 1.0E-7));
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.0f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration_NegativeValue() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "-0.5f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration_GreaterThanOne() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.5f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
    }

    @Test
    public void testGetReplWorkMultiplier() {
        Configuration conf = new Configuration();
        int blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
        Assert.assertTrue((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "3");
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
        Assert.assertEquals((long)blocksReplWorkMultiplier, (long)3L);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "-1");
        this.exception.expect(IllegalArgumentException.class);
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
    }

    @Test
    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeDescriptor> replicaNodeList = new ArrayList<DatanodeDescriptor>();
        HashMap rackMap = new HashMap();
        dataNodes[0].setRemaining(0x400000L);
        replicaNodeList.add(dataNodes[0]);
        dataNodes[1].setRemaining(0x300000L);
        replicaNodeList.add(dataNodes[1]);
        dataNodes[2].setRemaining(0x200000L);
        replicaNodeList.add(dataNodes[2]);
        dataNodes[5].setRemaining(0x100000L);
        replicaNodeList.add(dataNodes[5]);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        replicator.splitNodesWithRack(replicaNodeList, rackMap, first, second);
        Assert.assertEquals((long)2L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        DatanodeDescriptor chosenNode = replicator.chooseReplicaToDelete(null, null, (short)3, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[1]);
        replicator.adjustSetsWithChosenReplica(rackMap, first, second, (DatanodeInfo)chosenNode);
        Assert.assertEquals((long)0L, (long)first.size());
        Assert.assertEquals((long)3L, (long)second.size());
        chosenNode = replicator.chooseReplicaToDelete(null, null, (short)2, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[5]);
    }

    static {
        staleInterval = 30000L;
    }
}

