/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReplicationBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.junit.Assert;
import org.junit.Test;

public class TestPendingReplication {
    static final int TIMEOUT = 3;
    private static final int DFS_REPLICATION_INTERVAL = 1;
    private static final int DATANODE_COUNT = 5;

    private DatanodeDescriptor genDatanodeId(int seed) {
        String ip = (seed %= 256) + "." + seed + "." + seed + "." + seed;
        return DFSTestUtil.getDatanodeDescriptor(ip, null);
    }

    private DatanodeDescriptor[] genDatanodes(int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0);
        DatanodeDescriptor[] nodes = new DatanodeDescriptor[number];
        for (int i = 0; i < number; ++i) {
            nodes[i] = this.genDatanodeId(i);
        }
        return nodes;
    }

    @Test
    public void testPendingReplication() {
        Block block;
        int i;
        PendingReplicationBlocks pendingReplications = new PendingReplicationBlocks(3000L);
        pendingReplications.start();
        for (int i2 = 0; i2 < 10; ++i2) {
            Block block2 = new Block((long)i2, (long)i2, 0L);
            pendingReplications.increment(block2, this.genDatanodes(i2));
        }
        Assert.assertEquals((String)"Size of pendingReplications ", (long)10L, (long)pendingReplications.size());
        Block blk = new Block(8L, 8L, 0L);
        pendingReplications.decrement(blk, this.genDatanodeId(7));
        Assert.assertEquals((String)"pendingReplications.getNumReplicas ", (long)7L, (long)pendingReplications.getNumReplicas(blk));
        for (i = 0; i < 7; ++i) {
            pendingReplications.decrement(blk, this.genDatanodeId(i));
        }
        Assert.assertTrue((pendingReplications.size() == 9 ? 1 : 0) != 0);
        pendingReplications.increment(blk, this.genDatanodes(8));
        Assert.assertTrue((pendingReplications.size() == 10 ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            block = new Block((long)i, (long)i, 0L);
            int numReplicas = pendingReplications.getNumReplicas(block);
            Assert.assertTrue((numReplicas == i ? 1 : 0) != 0);
        }
        Assert.assertTrue((pendingReplications.getTimedOutBlocks() == null ? 1 : 0) != 0);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i3 = 10; i3 < 15; ++i3) {
            block = new Block((long)i3, (long)i3, 0L);
            pendingReplications.increment(block, this.genDatanodes(i3));
        }
        Assert.assertTrue((pendingReplications.size() == 15 ? 1 : 0) != 0);
        int loop = 0;
        while (pendingReplications.size() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++loop;
        }
        System.out.println("Had to wait for " + loop + " seconds for the lot to timeout");
        Assert.assertEquals((String)"Size of pendingReplications ", (long)0L, (long)pendingReplications.size());
        Block[] timedOut = pendingReplications.getTimedOutBlocks();
        Assert.assertTrue((timedOut != null && timedOut.length == 15 ? 1 : 0) != 0);
        for (int i4 = 0; i4 < timedOut.length; ++i4) {
            Assert.assertTrue((timedOut[i4].getBlockId() < 15L ? 1 : 0) != 0);
        }
        pendingReplications.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReceived() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        MiniDFSCluster cluster = null;
        try {
            StorageReceivedDeletedBlocks[] report;
            DatanodeRegistration dnR;
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).buildHDFS();
            ((MiniHDFSCluster)cluster).waitActive();
            DistributedFileSystem hdfs = ((MiniHDFSCluster)cluster).getFileSystem();
            FSNamesystem fsn = ((MiniHDFSCluster)cluster).getNamesystem();
            BlockManager blkManager = fsn.getBlockManager();
            String file = "/tmp.txt";
            Path filePath = new Path("/tmp.txt");
            short replFactor = 1;
            DFSTestUtil.createFile((FileSystem)hdfs, filePath, 1024L, replFactor, 0L);
            ArrayList<DataNode> datanodes = ((MiniHDFSCluster)cluster).getDataNodes();
            for (int i2 = 0; i2 < 5; ++i2) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(datanodes.get(i2), true);
            }
            hdfs.setReplication(filePath, (short)5);
            BlockManagerTestUtil.computeAllPendingWork(blkManager);
            Assert.assertEquals((long)1L, (long)blkManager.pendingReplications.size());
            INodeFile fileNode = fsn.getFSDirectory().getINode4Write("/tmp.txt").asFile();
            BlockInfo[] blocks = fileNode.getBlocks();
            Assert.assertEquals((long)4L, (long)blkManager.pendingReplications.getNumReplicas((Block)blocks[0]));
            LocatedBlock locatedBlock = hdfs.getClient().getLocatedBlocks("/tmp.txt", 0L).get(0);
            DatanodeInfo existingDn = locatedBlock.getLocations()[0];
            int reportDnNum = 0;
            String poolId = ((MiniHDFSCluster)cluster).getNamesystem().getBlockPoolId();
            for (i = 0; i < 5 && reportDnNum < 2; ++i) {
                if (datanodes.get(i).getDatanodeId().equals((Object)existingDn)) continue;
                dnR = datanodes.get(i).getDNRegistrationForBP(poolId);
                report = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(dnR.getStorageID(), new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo((Block)blocks[0], ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, "")})};
                ((MiniHDFSCluster)cluster).getNameNodeRpc().blockReceivedAndDeleted(dnR, poolId, report);
                ++reportDnNum;
            }
            Assert.assertEquals((long)2L, (long)blkManager.pendingReplications.getNumReplicas((Block)blocks[0]));
            for (i = 0; i < 5 && reportDnNum < 2; ++i) {
                if (datanodes.get(i).getDatanodeId().equals((Object)existingDn)) continue;
                dnR = datanodes.get(i).getDNRegistrationForBP(poolId);
                report = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(dnR.getStorageID(), new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo((Block)blocks[0], ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, "")})};
                ((MiniHDFSCluster)cluster).getNameNodeRpc().blockReceivedAndDeleted(dnR, poolId, report);
                ++reportDnNum;
            }
            Assert.assertEquals((long)2L, (long)blkManager.pendingReplications.getNumReplicas((Block)blocks[0]));
            for (i = 0; i < 5; ++i) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(datanodes.get(i), false);
                DataNodeTestUtils.triggerHeartbeat(datanodes.get(i));
            }
            Thread.sleep(5000L);
            Assert.assertEquals((long)0L, (long)blkManager.pendingReplications.size());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPendingAndInvalidate() throws Exception {
        HdfsConfiguration CONF = new HdfsConfiguration();
        CONF.setLong("dfs.blocksize", 1024L);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.namenode.replication.interval", 1);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(5).buildHDFS();
        cluster.waitActive();
        FSNamesystem namesystem = cluster.getNamesystem();
        BlockManager bm = namesystem.getBlockManager();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path filePath = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1024L, (short)3, 0L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
            }
            LocatedBlock block = NameNodeAdapter.getBlockLocations(cluster.getNameNode(), filePath.toString(), 0L, 1L).get(0);
            cluster.getNamesystem().writeLock();
            try {
                bm.findAndMarkBlockAsCorrupt(block.getBlock(), block.getLocations()[0], "TEST");
                bm.findAndMarkBlockAsCorrupt(block.getBlock(), block.getLocations()[1], "TEST");
            }
            finally {
                cluster.getNamesystem().writeUnlock();
            }
            BlockManagerTestUtil.computeAllPendingWork(bm);
            BlockManagerTestUtil.updateState(bm);
            Assert.assertEquals((long)bm.getPendingReplicationBlocksCount(), (long)1L);
            Assert.assertEquals((long)bm.pendingReplications.getNumReplicas(block.getBlock().getLocalBlock()), (long)2L);
            fs.delete(filePath, true);
            int retries = 10;
            long pendingNum = bm.getPendingReplicationBlocksCount();
            while (pendingNum != 0L && retries-- > 0) {
                Thread.sleep(1000L);
                BlockManagerTestUtil.updateState(bm);
                pendingNum = bm.getPendingReplicationBlocksCount();
            }
            Assert.assertEquals((long)pendingNum, (long)0L);
        }
        finally {
            cluster.shutdown();
        }
    }
}

