/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;

public class MiniJournalCluster {
    private static final Log LOG = LogFactory.getLog(MiniJournalCluster.class);
    private File baseDir;
    private JournalNode[] nodes;
    private InetSocketAddress[] ipcAddrs;
    private InetSocketAddress[] httpAddrs;

    private MiniJournalCluster(Builder b) throws IOException {
        LOG.info((Object)("Starting MiniJournalCluster with " + b.numJournalNodes + " journal nodes"));
        this.baseDir = b.baseDir != null ? new File(b.baseDir) : new File(MiniHDFSCluster.getBaseDirectory());
        this.nodes = new JournalNode[b.numJournalNodes];
        this.ipcAddrs = new InetSocketAddress[b.numJournalNodes];
        this.httpAddrs = new InetSocketAddress[b.numJournalNodes];
        for (int i = 0; i < b.numJournalNodes; ++i) {
            if (b.format) {
                File dir = this.getStorageDir(i);
                LOG.debug((Object)("Fully deleting JN directory " + dir));
                FileUtil.fullyDelete((File)dir);
            }
            this.nodes[i] = new JournalNode();
            this.nodes[i].setConf(this.createConfForNode(b, i));
            this.nodes[i].start();
            this.ipcAddrs[i] = this.nodes[i].getBoundIpcAddress();
            this.httpAddrs[i] = this.nodes[i].getBoundHttpAddress();
        }
    }

    public URI getQuorumJournalURI(String jid) {
        ArrayList addrs = Lists.newArrayList();
        for (InetSocketAddress addr : this.ipcAddrs) {
            addrs.add("127.0.0.1:" + addr.getPort());
        }
        String addrsVal = Joiner.on((String)";").join((Iterable)addrs);
        LOG.debug((Object)("Setting logger addresses to: " + addrsVal));
        try {
            return new URI("qjournal://" + addrsVal + "/" + jid);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void start() throws IOException {
        for (JournalNode jn : this.nodes) {
            jn.start();
        }
    }

    public void shutdown() throws IOException {
        boolean failed = false;
        for (JournalNode jn : this.nodes) {
            try {
                jn.stopAndJoin(0);
            }
            catch (Exception e) {
                failed = true;
                LOG.warn((Object)("Unable to stop journal node " + jn), (Throwable)e);
            }
        }
        if (failed) {
            throw new IOException("Unable to shut down. Check log for details");
        }
    }

    private Configuration createConfForNode(Builder b, int idx) {
        Configuration conf = new Configuration(b.conf);
        File logDir = this.getStorageDir(idx);
        conf.set("dfs.journalnode.edits.dir", logDir.toString());
        conf.set("dfs.journalnode.rpc-address", "0.0.0.0:0");
        conf.set("dfs.journalnode.http-address", "0.0.0.0:0");
        return conf;
    }

    public File getStorageDir(int idx) {
        return new File(this.baseDir, "journalnode-" + idx).getAbsoluteFile();
    }

    public File getCurrentDir(int idx, String jid) {
        return new File(new File(this.getStorageDir(idx), jid), "current");
    }

    public JournalNode getJournalNode(int i) {
        return this.nodes[i];
    }

    public void restartJournalNode(int i) throws InterruptedException, IOException {
        Configuration conf = new Configuration(this.nodes[i].getConf());
        if (this.nodes[i].isStarted()) {
            this.nodes[i].stopAndJoin(0);
        }
        conf.set("dfs.journalnode.rpc-address", "127.0.0.1:" + this.ipcAddrs[i].getPort());
        conf.set("dfs.journalnode.http-address", "127.0.0.1:" + this.httpAddrs[i].getPort());
        this.nodes[i] = new JournalNode();
        this.nodes[i].setConf(conf);
        this.nodes[i].start();
    }

    public int getQuorumSize() {
        return this.nodes.length / 2 + 1;
    }

    public int getNumNodes() {
        return this.nodes.length;
    }

    public static class Builder {
        private String baseDir;
        private int numJournalNodes = 3;
        private boolean format = true;
        private Configuration conf;

        public Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder baseDir(String d) {
            this.baseDir = d;
            return this;
        }

        public Builder numJournalNodes(int n) {
            this.numJournalNodes = n;
            return this;
        }

        public Builder format(boolean f) {
            this.format = f;
            return this;
        }

        public MiniJournalCluster build() throws IOException {
            return new MiniJournalCluster(this);
        }
    }
}

