/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestPersistBlocks {
    private static final int BLOCK_SIZE = 4096;
    private static final int NUM_BLOCKS = 5;
    private static final String FILE_NAME = "/data";
    private static final Path FILE_PATH;
    static final byte[] DATA_BEFORE_RESTART;
    static final byte[] DATA_AFTER_RESTART;
    private static final String HADOOP_1_0_MULTIBLOCK_TGZ = "hadoop-1.0-multiblock-file.tgz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartDfs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        MiniDFSCluster cluster = null;
        long len = 0L;
        try {
            FileStatus status;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).buildHDFS();
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART);
            stream.hflush();
            while (len <= 4096L) {
                status = fs.getFileStatus(FILE_PATH);
                len = status.getLen();
                Thread.sleep(100L);
            }
            ((MiniHDFSCluster)cluster).restartNameNode();
            status = fs.getFileStatus(FILE_PATH);
            Assert.assertTrue((String)("Length too short: " + status.getLen()), (status.getLen() >= len ? 1 : 0) != 0);
            stream.write(DATA_AFTER_RESTART);
            stream.close();
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                Assert.assertArrayEquals((byte[])DATA_BEFORE_RESTART, (byte[])verifyBuf);
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                Assert.assertArrayEquals((byte[])DATA_AFTER_RESTART, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartDfsWithAbandonedBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        MiniDFSCluster cluster = null;
        long len = 0L;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).buildHDFS();
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART);
            stream.hflush();
            while (len < 16384L) {
                FileStatus status = fs.getFileStatus(FILE_PATH);
                len = status.getLen();
                Thread.sleep(100L);
            }
            DFSClient dfsclient = DFSClientAdapter.getDFSClient(fs);
            LocatedBlocks blocks = dfsclient.getNamenode().getBlockLocations(FILE_NAME, 0L, 20480L);
            Assert.assertEquals((long)5L, (long)blocks.getLocatedBlocks().size());
            LocatedBlock b = blocks.getLastLocatedBlock();
            dfsclient.getNamenode().abandonBlock(b.getBlock(), FILE_NAME, dfsclient.clientName);
            ((MiniHDFSCluster)cluster).restartNameNode();
            FileStatus status = fs.getFileStatus(FILE_PATH);
            Assert.assertTrue((String)("Length incorrect: " + status.getLen()), (status.getLen() == len - 4096L ? 1 : 0) != 0);
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length - 4096];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                byte[] expectedBuf = new byte[DATA_BEFORE_RESTART.length - 4096];
                System.arraycopy(DATA_BEFORE_RESTART, 0, expectedBuf, 0, expectedBuf.length);
                Assert.assertArrayEquals((byte[])expectedBuf, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartWithPartialBlockHflushed() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).buildHDFS();
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            NameNode.getAddress((Configuration)conf).getPort();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART);
            stream.write(1);
            stream.hflush();
            ((MiniHDFSCluster)cluster).restartNameNode();
            stream.write(2);
            stream.hflush();
            stream.close();
            Assert.assertEquals((long)(DATA_BEFORE_RESTART.length + 2), (long)fs.getFileStatus(FILE_PATH).getLen());
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length + 2];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                byte[] expectedBuf = new byte[DATA_BEFORE_RESTART.length + 2];
                System.arraycopy(DATA_BEFORE_RESTART, 0, expectedBuf, 0, DATA_BEFORE_RESTART.length);
                System.arraycopy(new byte[]{1, 2}, 0, expectedBuf, DATA_BEFORE_RESTART.length, 2);
                Assert.assertArrayEquals((byte[])expectedBuf, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartWithAppend() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).buildHDFS();
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            NameNode.getAddress((Configuration)conf).getPort();
            FSDataOutputStream stream = fs.create(FILE_PATH, true, 4096, (short)1, 4096L);
            stream.write(DATA_BEFORE_RESTART, 0, DATA_BEFORE_RESTART.length / 2);
            stream.close();
            stream = fs.append(FILE_PATH, 4096);
            stream.write(DATA_BEFORE_RESTART, DATA_BEFORE_RESTART.length / 2, DATA_BEFORE_RESTART.length / 2);
            stream.close();
            Assert.assertEquals((long)DATA_BEFORE_RESTART.length, (long)fs.getFileStatus(FILE_PATH).getLen());
            ((MiniHDFSCluster)cluster).restartNameNode();
            Assert.assertEquals((long)DATA_BEFORE_RESTART.length, (long)fs.getFileStatus(FILE_PATH).getLen());
            FSDataInputStream readStream = fs.open(FILE_PATH);
            try {
                byte[] verifyBuf = new byte[DATA_BEFORE_RESTART.length];
                IOUtils.readFully((InputStream)readStream, (byte[])verifyBuf, (int)0, (int)verifyBuf.length);
                Assert.assertArrayEquals((byte[])DATA_BEFORE_RESTART, (byte[])verifyBuf);
            }
            finally {
                IOUtils.closeStream((Closeable)readStream);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEarlierVersionEditLog() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String tarFile = System.getProperty("test.cache.data", "build/test/cache") + "/" + HADOOP_1_0_MULTIBLOCK_TGZ;
        String testDir = System.getProperty("test.build.data", "build/test/data");
        File dfsDir = new File(testDir, "image-1.0");
        if (dfsDir.exists() && !FileUtil.fullyDelete((File)dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        FileUtil.unTar((File)new File(tarFile), (File)new File(testDir));
        File nameDir = new File(dfsDir, "name");
        GenericTestUtils.assertExists((File)nameDir);
        File dataDir = new File(dfsDir, "data");
        GenericTestUtils.assertExists((File)dataDir);
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        conf.set("dfs.datanode.data.dir", dataDir.getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).numDataNodes(1).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
        try {
            FileSystem fs = cluster.getFileSystem();
            Path testPath = new Path("/user/todd/4blocks");
            DFSTestUtil.readFile(fs, testPath);
            FSDataOutputStream stm = fs.append(testPath);
            try {
                stm.write(1);
            }
            finally {
                IOUtils.closeStream((Closeable)stm);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static {
        ((Log4JLogger)FSImage.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        FILE_PATH = new Path(FILE_NAME);
        DATA_BEFORE_RESTART = new byte[20480];
        DATA_AFTER_RESTART = new byte[20480];
        Random rand = new Random();
        rand.nextBytes(DATA_BEFORE_RESTART);
        rand.nextBytes(DATA_AFTER_RESTART);
    }
}

