/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestMiniDFSCluster {
    private static final String CLUSTER_1 = "cluster1";
    private static final String CLUSTER_2 = "cluster2";
    private static final String CLUSTER_3 = "cluster3";
    private static final String CLUSTER_4 = "cluster4";
    private static final String CLUSTER_5 = "cluster5";
    protected String testDataPath;
    protected File testDataDir;

    @Before
    public void setUp() {
        this.testDataPath = System.getProperty("test.build.data", "build/test/data");
        this.testDataDir = new File(new File(this.testDataPath).getParentFile(), "miniclusters");
    }

    @After
    public void tearDown() {
        System.setProperty("test.build.data", this.testDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testClusterWithoutSystemProperties() throws Throwable {
        System.clearProperty("test.build.data");
        HdfsConfiguration conf = new HdfsConfiguration();
        File testDataCluster1 = new File(this.testDataPath, CLUSTER_1);
        String c1Path = testDataCluster1.getAbsolutePath();
        conf.set("hdfs.minidfs.basedir", c1Path);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
        try {
            Assert.assertEquals((Object)new File(c1Path + "/data"), (Object)new File(cluster.getDataDirectory()));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testDualClusters() throws Throwable {
        File testDataCluster2 = new File(this.testDataPath, CLUSTER_2);
        File testDataCluster3 = new File(this.testDataPath, CLUSTER_3);
        HdfsConfiguration conf = new HdfsConfiguration();
        String c2Path = testDataCluster2.getAbsolutePath();
        conf.set("hdfs.minidfs.basedir", c2Path);
        MiniHDFSCluster cluster2 = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
        MiniHDFSCluster cluster3 = null;
        try {
            String dataDir2 = cluster2.getDataDirectory();
            Assert.assertEquals((Object)new File(c2Path + "/data"), (Object)new File(dataDir2));
            conf.set("hdfs.minidfs.basedir", testDataCluster3.getAbsolutePath());
            MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder((Configuration)conf);
            cluster3 = builder.buildHDFS();
            String dataDir3 = cluster3.getDataDirectory();
            Assert.assertTrue((String)("Clusters are bound to the same directory: " + dataDir2), (!dataDir2.equals(dataDir3) ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            MiniHDFSCluster.shutdownCluster(cluster3);
            MiniHDFSCluster.shutdownCluster(cluster2);
            throw throwable;
        }
        MiniHDFSCluster.shutdownCluster(cluster3);
        MiniHDFSCluster.shutdownCluster(cluster2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testIsClusterUpAfterShutdown() throws Throwable {
        HdfsConfiguration conf = new HdfsConfiguration();
        File testDataCluster4 = new File(this.testDataPath, CLUSTER_4);
        String c4Path = testDataCluster4.getAbsolutePath();
        conf.set("hdfs.minidfs.basedir", c4Path);
        MiniHDFSCluster cluster4 = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
        try {
            DistributedFileSystem dfs = cluster4.getFileSystem();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster4.shutdown();
        }
        finally {
            while (cluster4.isClusterUp()) {
                Thread.sleep(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testClusterSetDatanodeHostname() throws Throwable {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Linux"));
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.hostname", "MYHOST");
        File testDataCluster5 = new File(this.testDataPath, CLUSTER_5);
        String c5Path = testDataCluster5.getAbsolutePath();
        conf.set("hdfs.minidfs.basedir", c5Path);
        MiniHDFSCluster cluster5 = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).checkDataNodeHostConfig(true).buildHDFS();
        try {
            Assert.assertEquals((String)"DataNode hostname config not respected", (Object)"MYHOST", (Object)cluster5.getDataNodes().get(0).getDatanodeId().getHostName());
        }
        finally {
            MiniHDFSCluster.shutdownCluster(cluster5);
        }
    }
}

