/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Random;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestListFilesInFileContext {
    static final long seed = 3735928559L;
    private static final Configuration conf = new Configuration();
    private static MiniHDFSCluster cluster;
    private static FileContext fc;
    private static final Path TEST_DIR;
    private static final int FILE_LEN = 10;
    private static final Path FILE1;
    private static final Path DIR1;
    private static final Path FILE2;
    private static final Path FILE3;

    public TestListFilesInFileContext() {
        ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.ALL);
    }

    @BeforeClass
    public static void testSetUp() throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).buildHDFS();
        fc = FileContext.getFileContext((Configuration)cluster.getConfiguration(0));
        fc.delete(TEST_DIR, true);
    }

    private static void writeFile(FileContext fc, Path name, int fileSize) throws IOException {
        FSDataOutputStream stm = fc.create(name, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    @AfterClass
    public static void testShutdown() throws Exception {
        cluster.shutdown();
    }

    @Test
    public void testFile() throws IOException {
        fc.mkdir(TEST_DIR, FsPermission.getDefault(), true);
        TestListFilesInFileContext.writeFile(fc, FILE1, 10);
        RemoteIterator itor = fc.util().listFiles(FILE1, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fc.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        itor = fc.util().listFiles(FILE1, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fc.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
    }

    @After
    public void cleanDir() throws IOException {
        fc.delete(TEST_DIR, true);
    }

    @Test
    public void testDirectory() throws IOException {
        fc.mkdir(DIR1, FsPermission.getDefault(), true);
        RemoteIterator itor = fc.util().listFiles(DIR1, true);
        Assert.assertFalse((boolean)itor.hasNext());
        itor = fc.util().listFiles(DIR1, false);
        Assert.assertFalse((boolean)itor.hasNext());
        TestListFilesInFileContext.writeFile(fc, FILE2, 10);
        itor = fc.util().listFiles(DIR1, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fc.makeQualified(FILE2), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        itor = fc.util().listFiles(DIR1, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertFalse((boolean)itor.hasNext());
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((long)10L, (long)stat.getLen());
        Assert.assertEquals((Object)fc.makeQualified(FILE2), (Object)stat.getPath());
        Assert.assertEquals((long)1L, (long)stat.getBlockLocations().length);
        TestListFilesInFileContext.writeFile(fc, FILE1, 10);
        TestListFilesInFileContext.writeFile(fc, FILE3, 10);
        itor = fc.util().listFiles(TEST_DIR, true);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE2), (Object)stat.getPath());
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE3), (Object)stat.getPath());
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertFalse((boolean)itor.hasNext());
        itor = fc.util().listFiles(TEST_DIR, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertFalse((boolean)itor.hasNext());
    }

    @Test
    public void testSymbolicLinks() throws IOException {
        TestListFilesInFileContext.writeFile(fc, FILE1, 10);
        TestListFilesInFileContext.writeFile(fc, FILE2, 10);
        TestListFilesInFileContext.writeFile(fc, FILE3, 10);
        Path dir4 = new Path(TEST_DIR, "dir4");
        Path dir5 = new Path(dir4, "dir5");
        Path file4 = new Path(dir4, "file4");
        fc.createSymlink(DIR1, dir5, true);
        fc.createSymlink(FILE1, file4, true);
        RemoteIterator itor = fc.util().listFiles(dir4, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE2), (Object)stat.getPath());
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE3), (Object)stat.getPath());
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertFalse((boolean)itor.hasNext());
        itor = fc.util().listFiles(dir4, false);
        stat = (LocatedFileStatus)itor.next();
        Assert.assertTrue((boolean)stat.isFile());
        Assert.assertEquals((Object)fc.makeQualified(FILE1), (Object)stat.getPath());
        Assert.assertFalse((boolean)itor.hasNext());
    }

    static {
        TEST_DIR = new Path("/main_");
        FILE1 = new Path(TEST_DIR, "file1");
        DIR1 = new Path(TEST_DIR, "dir1");
        FILE2 = new Path(DIR1, "file2");
        FILE3 = new Path(DIR1, "file3");
    }
}

