/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFileCreationDelete {
    public TestFileCreationDelete() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationDeleteParent() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            int nnport = cluster.getNameNodePort();
            Path dir = new Path("/foo");
            Path file1 = new Path(dir, "file1");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file1);
            TestFileCreation.writeFile(stm1, 1000);
            stm1.hflush();
            Path file2 = new Path("/file2");
            FSDataOutputStream stm2 = TestFileCreation.createFile((FileSystem)fs, file2, 1);
            System.out.println("testFileCreationDeleteParent: Created file " + file2);
            TestFileCreation.writeFile(stm2, 1000);
            stm2.hflush();
            fs.delete(dir, true);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).buildHDFS();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).buildHDFS();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fs.exists(file2));
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

