/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSRename {
    final Path dir = new Path("/test/rename/");

    static int countLease(MiniHDFSCluster cluster) {
        return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).countLease();
    }

    void list(FileSystem fs, String name) throws IOException {
        FileSystem.LOG.info((Object)("\n\n" + name));
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info((Object)("" + s.getPath()));
        }
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        a_out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).buildHDFS();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path aa = new Path(this.dir, "aa");
            Path b = new Path(this.dir, "b");
            TestDFSRename.createFile((FileSystem)fs, a);
            Assert.assertEquals((long)0L, (long)TestDFSRename.countLease(cluster));
            FSDataOutputStream aa_out = fs.create(aa);
            aa_out.writeBytes("something");
            Assert.assertEquals((long)1L, (long)TestDFSRename.countLease(cluster));
            this.list((FileSystem)fs, "rename0");
            fs.rename(a, b);
            this.list((FileSystem)fs, "rename1");
            aa_out.writeBytes(" more");
            aa_out.close();
            this.list((FileSystem)fs, "rename2");
            Assert.assertEquals((long)0L, (long)TestDFSRename.countLease(cluster));
            Path dstPath = new Path("/c/d");
            Assert.assertFalse((boolean)fs.exists(dstPath));
            Assert.assertFalse((boolean)fs.rename(this.dir, dstPath));
            Path src = new Path("/a/b");
            Path dst = new Path("/a/b/c");
            TestDFSRename.createFile((FileSystem)fs, new Path(src, "foo"));
            Assert.assertFalse((boolean)fs.rename(src, dst));
            Assert.assertFalse((boolean)fs.rename(src.getParent(), dst.getParent()));
            src = new Path("/testPrefix");
            dst = new Path("/testPrefixfile");
            TestDFSRename.createFile((FileSystem)fs, src);
            Assert.assertTrue((boolean)fs.rename(src, dst));
            src = new Path("/a/b/c");
            TestDFSRename.createFile((FileSystem)fs, src);
            Assert.assertTrue((boolean)fs.rename(src, src));
            Assert.assertFalse((boolean)fs.rename(new Path("/a/b"), new Path("/a/b/")));
            Assert.assertTrue((boolean)fs.rename(src, new Path("/a/b/c/")));
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

