/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSFinalize {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSFinalize");
    private Configuration conf;
    private int testCounter = 0;
    private MiniHDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs));
    }

    static void checkResult(String[] nameNodeDirs, String[] dataNodeDirs) throws Exception {
        int i;
        ArrayList dirs = Lists.newArrayList();
        for (i = 0; i < nameNodeDirs.length; ++i) {
            File curDir = new File(nameNodeDirs[i], "current");
            dirs.add(curDir);
            FSImageTestUtil.assertReasonableNameCurrentDir(curDir);
        }
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, Collections.<String>emptySet());
        for (i = 0; i < dataNodeDirs.length; ++i) {
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, new File(dataNodeDirs[i], "current")), (long)UpgradeUtilities.checksumMasterDataNodeContents());
        }
        for (i = 0; i < nameNodeDirs.length; ++i) {
            Assert.assertFalse((boolean)new File(nameNodeDirs[i], "previous").isDirectory());
        }
    }

    @Test
    public void testFinalize() throws Exception {
        UpgradeUtilities.initialize();
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            String[] nameNodeDirs = this.conf.getStrings("dfs.namenode.name.dir");
            String[] dataNodeDirs = this.conf.getStrings("dfs.datanode.data.dir");
            this.log("Finalize with existing previous dir", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).buildHDFS();
            this.cluster.finalizeCluster(this.conf);
            TestDFSFinalize.checkResult(nameNodeDirs, dataNodeDirs);
            this.log("Finalize without existing previous dir", numDirs);
            this.cluster.finalizeCluster(this.conf);
            TestDFSFinalize.checkResult(nameNodeDirs, dataNodeDirs);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSFinalize().testFinalize();
    }
}

