/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBlockReaderLocalLegacy {
    @BeforeClass
    public static void setupCluster() throws IOException {
        DFSInputStream.tcpReadsDisabledForTesting = true;
        DomainSocket.disableBindPathValidation();
    }

    private static HdfsConfiguration getConfiguration(TemporarySocketDirectory socketDir) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (socketDir == null) {
            conf.set("dfs.domain.socket.path", "");
        } else {
            conf.set("dfs.domain.socket.path", new File(socketDir.getDir(), "TestBlockReaderLocalLegacy.%d.sock").getAbsolutePath());
        }
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setBoolean("dfs.client.use.legacy.blockreader.local", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        conf.setBoolean("dfs.client.domain.socket.data.traffic", false);
        return conf;
    }

    @Test
    public void testStablePositionAfterCorruptRead() throws Exception {
        boolean REPL_FACTOR = true;
        long FILE_LENGTH = 512L;
        HdfsConfiguration conf = TestBlockReaderLocalLegacy.getConfiguration(null);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).buildHDFS();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/corrupted");
        DFSTestUtil.createFile((FileSystem)fs, path, 512L, (short)1, 12345L);
        DFSTestUtil.waitReplication((FileSystem)fs, path, (short)1);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, path);
        int blockFilesCorrupted = cluster.corruptBlockOnDataNodes(block);
        Assert.assertEquals((String)"All replicas not corrupted", (long)1L, (long)blockFilesCorrupted);
        FSDataInputStream dis = cluster.getFileSystem().open(path);
        ByteBuffer buf = ByteBuffer.allocateDirect(512);
        boolean sawException = false;
        try {
            dis.read(buf);
        }
        catch (ChecksumException ex) {
            sawException = true;
        }
        Assert.assertTrue((boolean)sawException);
        Assert.assertEquals((long)0L, (long)buf.position());
        Assert.assertEquals((long)buf.capacity(), (long)buf.limit());
        dis = cluster.getFileSystem().open(path);
        buf.position(3);
        buf.limit(25);
        sawException = false;
        try {
            dis.read(buf);
        }
        catch (ChecksumException ex) {
            sawException = true;
        }
        Assert.assertTrue((boolean)sawException);
        Assert.assertEquals((long)3L, (long)buf.position());
        Assert.assertEquals((long)25L, (long)buf.limit());
        cluster.shutdown();
    }

    @Test
    public void testBothOldAndNewShortCircuitConfigured() throws Exception {
        boolean REPL_FACTOR = true;
        int FILE_LENGTH = 512;
        Assume.assumeTrue((null == DomainSocket.getLoadingFailureReason() ? 1 : 0) != 0);
        TemporarySocketDirectory socketDir = new TemporarySocketDirectory();
        HdfsConfiguration conf = TestBlockReaderLocalLegacy.getConfiguration(socketDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        socketDir.close();
        FileSystem fs = cluster.getFileSystem();
        Path path = new Path("/foo");
        byte[] orig = new byte[512];
        for (int i = 0; i < orig.length; ++i) {
            orig[i] = (byte)(i % 10);
        }
        FSDataOutputStream fos = fs.create(path, (short)1);
        fos.write(orig);
        fos.close();
        DFSTestUtil.waitReplication(fs, path, (short)1);
        FSDataInputStream fis = cluster.getFileSystem().open(path);
        byte[] buf = new byte[512];
        IOUtils.readFully((InputStream)fis, (byte[])buf, (int)0, (int)512);
        fis.close();
        Assert.assertArrayEquals((byte[])orig, (byte[])buf);
        Arrays.equals(orig, buf);
        cluster.shutdown();
    }
}

