/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Level;
import org.junit.Assert;

public class DFSTestUtil {
    private static final Log LOG = LogFactory.getLog(DFSTestUtil.class);
    private static Random gen = new Random();
    private static String[] dirNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private final int maxLevels;
    private final int maxSize;
    private final int minSize;
    private final int nFiles;
    private MyFile[] files;

    private DFSTestUtil(int nFiles, int maxLevels, int maxSize, int minSize) {
        this.nFiles = nFiles;
        this.maxLevels = maxLevels;
        this.maxSize = maxSize;
        this.minSize = minSize;
    }

    public DFSTestUtil(String testName, int nFiles, int maxLevels, int maxSize, int minSize) {
        this.nFiles = nFiles;
        this.maxLevels = maxLevels;
        this.maxSize = maxSize;
        this.minSize = minSize;
    }

    public static void formatNameNode(Configuration conf) throws IOException {
        String clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId();
        if (clusterId == null || clusterId.isEmpty()) {
            HdfsServerConstants.StartupOption.FORMAT.setClusterId("testClusterID");
        }
        NameNode.format((Configuration)conf);
    }

    public void createFiles(FileSystem fs, String topdir) throws IOException {
        this.createFiles(fs, topdir, (short)3);
    }

    public void createFiles(FileSystem fs, String topdir, short replicationFactor) throws IOException {
        this.files = new MyFile[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            this.files[idx] = new MyFile();
        }
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.createFile(fs, new Path(root, this.files[idx].getName()), this.files[idx].getSize(), replicationFactor, this.files[idx].getSeed());
        }
    }

    public static String readFile(FileSystem fs, Path fileName) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)fs.open(fileName), (OutputStream)os, (int)1024, (boolean)true);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileSystem fs, Path fileName, long fileLen, short replFactor, long seed) throws IOException {
        if (!fs.mkdirs(fileName.getParent())) {
            throw new IOException("Mkdirs failed to create " + fileName.getParent().toString());
        }
        FSDataOutputStream out = null;
        try {
            int bytesToWriteNext;
            out = fs.create(fileName, replFactor);
            byte[] toWrite = new byte[1024];
            Random rb = new Random(seed);
            for (long bytesToWrite = fileLen; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                rb.nextBytes(toWrite);
                bytesToWriteNext = 1024L < bytesToWrite ? 1024 : (int)bytesToWrite;
                out.write(toWrite, 0, bytesToWriteNext);
            }
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileSystem fs, Path fileName, int bufferLen, long fileLen, long blockSize, short replFactor, long seed) throws IOException {
        assert (bufferLen > 0);
        if (!fs.mkdirs(fileName.getParent())) {
            throw new IOException("Mkdirs failed to create " + fileName.getParent().toString());
        }
        FSDataOutputStream out = null;
        try {
            out = fs.create(fileName, true, fs.getConf().getInt("io.file.buffer.size", 4096), replFactor, blockSize);
            if (fileLen > 0L) {
                int bytesToWriteNext;
                byte[] toWrite = new byte[bufferLen];
                Random rb = new Random(seed);
                for (long bytesToWrite = fileLen; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                    rb.nextBytes(toWrite);
                    bytesToWriteNext = (long)bufferLen < bytesToWrite ? bufferLen : (int)bytesToWrite;
                    out.write(toWrite, 0, bytesToWriteNext);
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public boolean checkFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            FSDataInputStream in = fs.open(fPath);
            byte[] toRead = new byte[this.files[idx].getSize()];
            byte[] toCompare = new byte[this.files[idx].getSize()];
            Random rb = new Random(this.files[idx].getSeed());
            rb.nextBytes(toCompare);
            in.readFully(0L, toRead);
            in.close();
            for (int i = 0; i < toRead.length; ++i) {
                if (toRead[i] == toCompare[i]) continue;
                return false;
            }
            toRead = null;
            toCompare = null;
        }
        return true;
    }

    void setReplication(FileSystem fs, String topdir, short value) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            fs.setReplication(fPath, value);
        }
    }

    public void waitReplication(FileSystem fs, String topdir, short value) throws IOException, InterruptedException, TimeoutException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.waitReplication(fs, new Path(root, this.files[idx].getName()), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean allBlockReplicasCorrupt(MiniHDFSCluster cluster, Path file, int blockNo) throws IOException {
        LocatedBlocks blocks;
        DFSClient client = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), cluster.getConfiguration(0));
        try {
            blocks = client.getNamenode().getBlockLocations(file.toString(), 0L, Long.MAX_VALUE);
        }
        finally {
            client.close();
        }
        return blocks.get(blockNo).isCorrupt();
    }

    public static void waitForReplication(MiniHDFSCluster cluster, ExtendedBlock b, int racks, int replicas, int neededReplicas) throws IOException, TimeoutException, InterruptedException {
        int curRacks = 0;
        int curReplicas = 0;
        int curNeededReplicas = 0;
        int count = 0;
        int ATTEMPTS = 20;
        do {
            Thread.sleep(1000L);
            int[] r = BlockManagerTestUtil.getReplicaInfo(cluster.getNamesystem(), b.getLocalBlock());
            curRacks = r[0];
            curReplicas = r[1];
            curNeededReplicas = r[2];
        } while ((curRacks != racks || curReplicas != replicas || curNeededReplicas != neededReplicas) && ++count < 20);
        if (count == 20) {
            throw new TimeoutException("Timed out waiting for replication. Needed replicas = " + neededReplicas + " Cur needed replicas = " + curNeededReplicas + " Replicas = " + replicas + " Cur replicas = " + curReplicas + " Racks = " + racks + " Cur racks = " + curRacks);
        }
    }

    public static void waitCorruptReplicas(FileSystem fs, FSNamesystem ns, Path file, ExtendedBlock b, int corruptRepls) throws IOException, TimeoutException, InterruptedException {
        int count;
        int ATTEMPTS = 50;
        int repls = ns.getBlockManager().numCorruptReplicas(b.getLocalBlock());
        for (count = 0; repls != corruptRepls && count < 50; ++count) {
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (int)512, (boolean)true);
            }
            catch (IOException e) {
                // empty catch block
            }
            System.out.println("Waiting for " + corruptRepls + " corrupt replicas");
            repls = ns.getBlockManager().numCorruptReplicas(b.getLocalBlock());
            Thread.sleep(1000L);
        }
        if (count == 50) {
            throw new TimeoutException("Timed out waiting for corrupt replicas. Waiting for " + corruptRepls + ", but only found " + repls);
        }
    }

    public static void waitForDecommission(FileSystem fs, String name) throws IOException, InterruptedException, TimeoutException {
        DatanodeInfo dn = null;
        int count = 0;
        int ATTEMPTS = 20;
        do {
            Thread.sleep(1000L);
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!name.equals(info.getXferAddr())) continue;
                dn = info;
            }
        } while ((dn == null || dn.isDecommissionInProgress() || !dn.isDecommissioned()) && ++count < 20);
        if (count == 20) {
            throw new TimeoutException("Timed out waiting for datanode " + name + " to decommission.");
        }
    }

    public static int firstDnWithBlock(MiniHDFSCluster cluster, ExtendedBlock b) throws IOException {
        int numDatanodes = cluster.getDataNodes().size();
        for (int i = 0; i < numDatanodes; ++i) {
            String blockContent = cluster.readBlockOnDataNode(i, b);
            if (blockContent == null) continue;
            return i;
        }
        return -1;
    }

    public static long getLiveDatanodeCapacity(DatanodeManager dm) {
        ArrayList live = new ArrayList();
        dm.fetchDatanodes(live, null, false);
        long capacity = 0L;
        for (DatanodeDescriptor dn : live) {
            capacity += dn.getCapacity();
        }
        return capacity;
    }

    public static long getDatanodeCapacity(DatanodeManager dm, int index) {
        ArrayList live = new ArrayList();
        dm.fetchDatanodes(live, null, false);
        return ((DatanodeDescriptor)live.get(index)).getCapacity();
    }

    public static void waitForDatanodeStatus(DatanodeManager dm, int expectedLive, int expectedDead, long expectedVolFails, long expectedTotalCapacity, long timeout) throws InterruptedException, TimeoutException {
        ArrayList live = new ArrayList();
        ArrayList dead = new ArrayList();
        int ATTEMPTS = 10;
        int count = 0;
        long currTotalCapacity = 0L;
        int volFails = 0;
        do {
            Thread.sleep(timeout);
            live.clear();
            dead.clear();
            dm.fetchDatanodes(live, dead, false);
            currTotalCapacity = 0L;
            volFails = 0;
            for (DatanodeDescriptor dd : live) {
                currTotalCapacity += dd.getCapacity();
                volFails += dd.getVolumeFailures();
            }
        } while ((expectedLive != live.size() || expectedDead != dead.size() || expectedTotalCapacity != currTotalCapacity || expectedVolFails != (long)volFails) && ++count < 10);
        if (count == 10) {
            throw new TimeoutException("Timed out waiting for capacity. Live = " + live.size() + " Expected = " + expectedLive + " Dead = " + dead.size() + " Expected = " + expectedDead + " Total capacity = " + currTotalCapacity + " Expected = " + expectedTotalCapacity + " Vol Fails = " + volFails + " Expected = " + expectedVolFails);
        }
    }

    public static void waitForDatanodeDeath(DataNode dn) throws InterruptedException, TimeoutException {
        int ATTEMPTS = 10;
        int count = 0;
        do {
            Thread.sleep(1000L);
        } while (dn.isDatanodeUp() && ++count < 10);
        if (count == 10) {
            throw new TimeoutException("Timed out waiting for DN to die");
        }
    }

    public String[] getFileNames(String topDir) {
        if (this.nFiles == 0) {
            return new String[0];
        }
        String[] fileNames = new String[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            fileNames[idx] = topDir + "/" + this.files[idx].getName();
        }
        return fileNames;
    }

    public static void waitReplication(FileSystem fs, Path fileName, short replFactor) throws IOException, InterruptedException, TimeoutException {
        boolean correctReplFactor;
        int ATTEMPTS = 40;
        int count = 0;
        do {
            correctReplFactor = true;
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(fileName), 0L, Long.MAX_VALUE);
            ++count;
            for (int j = 0; j < locs.length; ++j) {
                Object[] hostnames = locs[j].getNames();
                if (hostnames.length == replFactor) continue;
                correctReplFactor = false;
                System.out.println("Block " + j + " of file " + fileName + " has replication factor " + hostnames.length + " (desired " + replFactor + "); locations " + Joiner.on((char)' ').join(hostnames));
                Thread.sleep(1000L);
                break;
            }
            if (!correctReplFactor) continue;
            System.out.println("All blocks of file " + fileName + " verified to have replication factor " + replFactor);
        } while (!correctReplFactor && count < 40);
        if (count == 40) {
            throw new TimeoutException("Timed out waiting for " + fileName + " to reach " + replFactor + " replicas");
        }
    }

    public void cleanup(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        fs.delete(root, true);
        this.files = null;
    }

    public static ExtendedBlock getFirstBlock(FileSystem fs, Path path) throws IOException {
        HdfsDataInputStream in = (HdfsDataInputStream)fs.open(path);
        in.readByte();
        return in.getCurrentBlock();
    }

    public static List<LocatedBlock> getAllBlocks(FSDataInputStream in) throws IOException {
        return ((HdfsDataInputStream)in).getAllBlocks();
    }

    public static List<LocatedBlock> getAllBlocks(FileSystem fs, Path path) throws IOException {
        HdfsDataInputStream in = (HdfsDataInputStream)fs.open(path);
        return in.getAllBlocks();
    }

    public static Token<BlockTokenIdentifier> getBlockToken(FSDataOutputStream out) {
        return ((DFSOutputStream)out.getWrappedStream()).getBlockToken();
    }

    static void setLogLevel2All(Log log) {
        ((Log4JLogger)log).getLogger().setLevel(Level.ALL);
    }

    public static String readFile(File f) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(f));
        while ((c = in.read()) != -1) {
            b.append((char)c);
        }
        in.close();
        return b.toString();
    }

    public static void writeFile(FileSystem fs, Path p, String s) throws IOException {
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        FSDataOutputStream os = fs.create(p);
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)s.length(), (boolean)true);
    }

    public static void appendFile(FileSystem fs, Path p, String s) throws IOException {
        assert (fs.exists(p));
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        FSDataOutputStream os = fs.append(p);
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)s.length(), (boolean)true);
    }

    public static void appendFile(FileSystem fs, Path p, int length) throws IOException {
        assert (fs.exists(p));
        assert (length >= 0);
        byte[] toAppend = new byte[length];
        Random random = new Random();
        random.nextBytes(toAppend);
        FSDataOutputStream out = fs.append(p);
        out.write(toAppend);
        out.close();
    }

    public static String urlGet(URL url) throws IOException {
        return new String(DFSTestUtil.urlGetBytes(url), Charsets.UTF_8);
    }

    public static byte[] urlGetBytes(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        HttpURLConnection hc = (HttpURLConnection)conn;
        Assert.assertEquals((long)200L, (long)hc.getResponseCode());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        return out.toByteArray();
    }

    public static void updateConfWithFakeGroupMapping(Configuration conf, Map<String, String[]> map) {
        if (map != null) {
            MockUnixGroupsMapping.fakeUser2GroupsMap = map;
        }
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, ShellBasedUnixGroupsMapping.class);
    }

    public static FileSystem getFileSystemAs(UserGroupInformation ugi, final Configuration conf) throws IOException, InterruptedException {
        return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
    }

    public static byte[] generateSequentialBytes(int start, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)((start + i) % 127);
        }
        return result;
    }

    public static FileSystem.Statistics getStatistics(FileSystem fs) {
        return FileSystem.getStatistics((String)fs.getUri().getScheme(), fs.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(String filename) throws IOException {
        File file = new File(filename);
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        byte[] content = new byte[(int)file.length()];
        try {
            in.readFully(content);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return content;
    }

    public static DataTransferProtos.BlockOpResponseProto transferRbw(ExtendedBlock b, DFSClient dfsClient, DatanodeInfo ... datanodes) throws IOException {
        Assert.assertEquals((long)2L, (long)datanodes.length);
        Socket s = DFSOutputStream.createSocketForPipeline((DatanodeInfo)datanodes[0], (int)datanodes.length, (DFSClient)dfsClient);
        long writeTimeout = dfsClient.getDatanodeWriteTimeout(datanodes.length);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)s, (long)writeTimeout), HdfsConstants.SMALL_BUFFER_SIZE));
        DataInputStream in = new DataInputStream((InputStream)NetUtils.getInputStream((Socket)s));
        new Sender(out).transferBlock(b, new Token(), dfsClient.clientName, new DatanodeInfo[]{datanodes[1]});
        out.flush();
        return DataTransferProtos.BlockOpResponseProto.parseDelimitedFrom((InputStream)in);
    }

    public static void setFederatedConfiguration(MiniHDFSCluster cluster, Configuration conf) {
        HashSet<String> nameservices = new HashSet<String>();
        for (MiniHDFSCluster.NameNodeInfo info : cluster.getNameNodeInfos()) {
            assert (info.nameserviceId != null);
            nameservices.add(info.nameserviceId);
            conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{info.nameserviceId}), DFSUtil.createUri((String)"hdfs", (InetSocketAddress)info.nameNode.getNameNodeAddress()).toString());
            conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{info.nameserviceId}), DFSUtil.createUri((String)"hdfs", (InetSocketAddress)info.nameNode.getNameNodeAddress()).toString());
        }
        conf.set("dfs.nameservices", Joiner.on((String)",").join(nameservices));
    }

    private static DatanodeID getDatanodeID(String ipAddr) {
        return new DatanodeID(ipAddr, "localhost", "", 50010, 50075, 50475, 50020);
    }

    public static DatanodeID getLocalDatanodeID() {
        return DFSTestUtil.getDatanodeID("127.0.0.1");
    }

    public static DatanodeID getLocalDatanodeID(int port) {
        return new DatanodeID("127.0.0.1", "localhost", "", port, port, port, port);
    }

    public static DatanodeDescriptor getLocalDatanodeDescriptor() {
        return new DatanodeDescriptor(DFSTestUtil.getLocalDatanodeID());
    }

    public static DatanodeInfo getLocalDatanodeInfo() {
        return new DatanodeInfo(DFSTestUtil.getLocalDatanodeID());
    }

    public static DatanodeInfo getDatanodeInfo(String ipAddr) {
        return new DatanodeInfo(DFSTestUtil.getDatanodeID(ipAddr));
    }

    public static DatanodeInfo getLocalDatanodeInfo(int port) {
        return new DatanodeInfo(DFSTestUtil.getLocalDatanodeID(port));
    }

    public static DatanodeInfo getDatanodeInfo(String ipAddr, String host, int port) {
        return new DatanodeInfo(new DatanodeID(ipAddr, host, "", port, 50075, 50475, 50020));
    }

    public static DatanodeInfo getLocalDatanodeInfo(String ipAddr, String hostname, DatanodeInfo.AdminStates adminState) {
        return new DatanodeInfo(ipAddr, hostname, "", 50010, 50075, 50475, 50020, 1L, 2L, 3L, 4L, 5L, 6, "local", adminState);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation) {
        return DFSTestUtil.getDatanodeDescriptor(ipAddr, 50010, rackLocation);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, int port, String rackLocation) {
        DatanodeID dnId = new DatanodeID(ipAddr, "host", "", port, 50075, 50475, 50020);
        return new DatanodeDescriptor(dnId, rackLocation);
    }

    public static DatanodeRegistration getLocalDatanodeRegistration() {
        return new DatanodeRegistration(DFSTestUtil.getLocalDatanodeID(), new StorageInfo(), new ExportedBlockKeys(), VersionInfo.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            byte[] b = new byte[1024];
            while (((InputStream)in).read(b) > 0) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void runOperations(MiniHDFSCluster cluster, DistributedFileSystem filesystem, Configuration conf, long blockSize, int nnIndex) throws IOException {
        LocatedBlocks locatedBlocks;
        long mtime;
        FileContext fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)conf);
        Path pathFileCreate = new Path("/file_create");
        FSDataOutputStream s = filesystem.create(pathFileCreate);
        s.close();
        Path pathFileMoved = new Path("/file_moved");
        filesystem.rename(pathFileCreate, pathFileMoved);
        filesystem.delete(pathFileMoved, false);
        Path pathDirectoryMkdir = new Path("/directory_mkdir");
        filesystem.mkdirs(pathDirectoryMkdir);
        filesystem.allowSnapshot(pathDirectoryMkdir);
        filesystem.disallowSnapshot(pathDirectoryMkdir);
        String ssName = "snapshot1";
        filesystem.allowSnapshot(pathDirectoryMkdir);
        filesystem.createSnapshot(pathDirectoryMkdir, ssName);
        String ssNewName = "snapshot2";
        filesystem.renameSnapshot(pathDirectoryMkdir, ssName, ssNewName);
        filesystem.deleteSnapshot(pathDirectoryMkdir, ssNewName);
        s = filesystem.create(pathFileCreate);
        s.close();
        filesystem.setReplication(pathFileCreate, (short)1);
        Short permission = 511;
        filesystem.setPermission(pathFileCreate, new FsPermission(permission.shortValue()));
        filesystem.setOwner(pathFileCreate, new String("newOwner"), null);
        long atime = mtime = 1285195527000L;
        filesystem.setTimes(pathFileCreate, mtime, atime);
        filesystem.setQuota(pathDirectoryMkdir, 1000L, Long.MAX_VALUE);
        fc.rename(pathFileCreate, pathFileMoved, new Options.Rename[]{Options.Rename.NONE});
        Path pathConcatTarget = new Path("/file_concat_target");
        Path[] pathConcatFiles = new Path[]{new Path("/file_concat_0"), new Path("/file_concat_1")};
        long length = blockSize * 3L;
        short replication = 1;
        long seed = 1L;
        DFSTestUtil.createFile((FileSystem)filesystem, pathConcatTarget, length, replication, seed);
        DFSTestUtil.createFile((FileSystem)filesystem, pathConcatFiles[0], length, replication, seed);
        DFSTestUtil.createFile((FileSystem)filesystem, pathConcatFiles[1], length, replication, seed);
        filesystem.concat(pathConcatTarget, pathConcatFiles);
        Path pathSymlink = new Path("/file_symlink");
        fc.createSymlink(pathConcatTarget, pathSymlink, false);
        String filePath = "/hard-lease-recovery-test";
        byte[] bytes = "foo-bar-baz".getBytes();
        DFSClientAdapter.stopLeaseRenewer(filesystem);
        FSDataOutputStream leaseRecoveryPath = filesystem.create(new Path(filePath));
        leaseRecoveryPath.write(bytes);
        leaseRecoveryPath.hflush();
        cluster.setLeasePeriod(60000L, 1000L, nnIndex);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ((locatedBlocks = DFSClientAdapter.callGetBlockLocations((ClientProtocol)cluster.getNameNodeRpc(nnIndex), filePath, 0L, bytes.length)).isUnderConstruction());
    }

    public static void abortStream(DFSOutputStream out) throws IOException {
        out.abort();
    }

    public static class Builder {
        private int maxLevels = 3;
        private int maxSize = 8192;
        private int minSize = 1;
        private int nFiles = 1;

        public Builder setName(String string) {
            return this;
        }

        public Builder setNumFiles(int nFiles) {
            this.nFiles = nFiles;
            return this;
        }

        public Builder setMaxLevels(int maxLevels) {
            this.maxLevels = maxLevels;
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public DFSTestUtil build() {
            return new DFSTestUtil(this.nFiles, this.maxLevels, this.maxSize, this.minSize);
        }
    }

    static class MockUnixGroupsMapping
    extends ShellBasedUnixGroupsMapping {
        static Map<String, String[]> fakeUser2GroupsMap;
        private static final List<String> defaultGroups;

        MockUnixGroupsMapping() {
        }

        public List<String> getGroups(String user) throws IOException {
            boolean found = false;
            List<String> l = new ArrayList<String>();
            for (String u : fakeUser2GroupsMap.keySet()) {
                if (!user.equals(u)) continue;
                found = true;
                for (String gr : fakeUser2GroupsMap.get(u)) {
                    l.add(gr);
                }
            }
            if (!found && (l = super.getGroups(user)).size() == 0) {
                System.out.println("failed to get real group for " + user + "; using default");
                return defaultGroups;
            }
            return l;
        }

        static {
            defaultGroups = new ArrayList<String>(1);
            defaultGroups.add("supergroup");
            fakeUser2GroupsMap = new HashMap<String, String[]>();
        }
    }

    private class MyFile {
        private String name = "";
        private int size;
        private long seed;

        MyFile() {
            int nLevels = gen.nextInt(DFSTestUtil.this.maxLevels);
            if (nLevels != 0) {
                int[] levels = new int[nLevels];
                for (int idx = 0; idx < nLevels; ++idx) {
                    levels[idx] = gen.nextInt(10);
                }
                StringBuffer sb = new StringBuffer();
                for (int idx = 0; idx < nLevels; ++idx) {
                    sb.append(dirNames[levels[idx]]);
                    sb.append("/");
                }
                this.name = sb.toString();
            }
            long fidx = -1L;
            while (fidx < 0L) {
                fidx = gen.nextLong();
            }
            this.name = this.name + Long.toString(fidx);
            this.size = DFSTestUtil.this.minSize + gen.nextInt(DFSTestUtil.this.maxSize - DFSTestUtil.this.minSize);
            this.seed = gen.nextLong();
        }

        String getName() {
            return this.name;
        }

        int getSize() {
            return this.size;
        }

        long getSeed() {
            return this.seed;
        }
    }
}

