/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestStickyBit {
    static UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"theDoctor", (String[])new String[]{"tardis"});
    static UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"rose", (String[])new String[]{"powellestates"});

    private void confirmCanAppend(Configuration conf, FileSystem hdfs, Path baseDir) throws IOException, InterruptedException {
        Path p = new Path(baseDir, "tmp");
        hdfs.mkdirs(p);
        hdfs.setPermission(p, new FsPermission(1023));
        hdfs = DFSTestUtil.getFileSystemAs(user1, conf);
        Path file = new Path(p, "foo");
        TestStickyBit.writeFile(hdfs, file);
        hdfs.setPermission(file, new FsPermission(511));
        hdfs = DFSTestUtil.getFileSystemAs(user2, conf);
        Path file2 = new Path(p, "foo");
        FSDataOutputStream h = hdfs.append(file2);
        h.write("Some more data".getBytes());
        h.close();
    }

    private void confirmDeletingFiles(Configuration conf, FileSystem hdfs, Path baseDir) throws IOException, InterruptedException {
        Path p = new Path(baseDir, "contemporary");
        hdfs.mkdirs(p);
        hdfs.setPermission(p, new FsPermission(1023));
        hdfs = DFSTestUtil.getFileSystemAs(user1, conf);
        Path file = new Path(p, "foo");
        TestStickyBit.writeFile(hdfs, file);
        Assert.assertEquals((Object)user1.getShortUserName(), (Object)hdfs.getFileStatus(file).getOwner());
        FileSystem hdfs2 = DFSTestUtil.getFileSystemAs(user2, conf);
        try {
            hdfs2.delete(file, false);
            Assert.fail((String)"Shouldn't be able to delete someone else's file with SB on");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof AccessControlException));
            Assert.assertTrue((boolean)ioe.getMessage().contains("sticky bit"));
        }
    }

    private void confirmStickyBitDoesntPropagate(FileSystem hdfs, Path baseDir) throws IOException {
        Path p = new Path(baseDir, "scissorsisters");
        hdfs.mkdirs(p, new FsPermission(950));
        Path p2 = new Path(p, "bar");
        hdfs.mkdirs(p2);
        Assert.assertFalse((boolean)hdfs.getFileStatus(p2).getPermission().getStickyBit());
    }

    private void confirmSettingAndGetting(FileSystem hdfs, Path baseDir) throws IOException {
        Path p1 = new Path(baseDir, "roguetraders");
        hdfs.mkdirs(p1);
        Assert.assertFalse((boolean)hdfs.getFileStatus(p1).getPermission().getStickyBit());
        short withSB = (short)(hdfs.getFileStatus(p1).getPermission().toShort() | 0x200);
        Assert.assertTrue((boolean)new FsPermission(withSB).getStickyBit());
        hdfs.setPermission(p1, new FsPermission(withSB));
        Assert.assertTrue((boolean)hdfs.getFileStatus(p1).getPermission().getStickyBit());
        Path f = new Path(baseDir, "somefile");
        TestStickyBit.writeFile(hdfs, f);
        Assert.assertFalse((boolean)hdfs.getFileStatus(f).getPermission().getStickyBit());
        withSB = (short)(hdfs.getFileStatus(f).getPermission().toShort() | 0x200);
        hdfs.setPermission(f, new FsPermission(withSB));
        Assert.assertTrue((boolean)hdfs.getFileStatus(f).getPermission().getStickyBit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGeneralSBBehavior() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.permissions.enabled", true);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            FileSystem hdfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)(hdfs instanceof DistributedFileSystem));
            Path baseDir = new Path("/mcgann");
            hdfs.mkdirs(baseDir);
            this.confirmCanAppend((Configuration)conf, hdfs, baseDir);
            baseDir = new Path("/eccleston");
            hdfs.mkdirs(baseDir);
            this.confirmSettingAndGetting(hdfs, baseDir);
            baseDir = new Path("/tennant");
            hdfs.mkdirs(baseDir);
            this.confirmDeletingFiles((Configuration)conf, hdfs, baseDir);
            baseDir = new Path("/smith");
            hdfs.mkdirs(baseDir);
            this.confirmStickyBitDoesntPropagate(hdfs, baseDir);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMovingFiles() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.permissions.enabled", true);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            FileSystem hdfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)(hdfs instanceof DistributedFileSystem));
            Path tmpPath = new Path("/tmp");
            Path tmpPath2 = new Path("/tmp2");
            hdfs.mkdirs(tmpPath);
            hdfs.mkdirs(tmpPath2);
            hdfs.setPermission(tmpPath, new FsPermission(1023));
            hdfs.setPermission(tmpPath2, new FsPermission(1023));
            Path file = new Path(tmpPath, "foo");
            FileSystem hdfs2 = DFSTestUtil.getFileSystemAs(user1, (Configuration)conf);
            TestStickyBit.writeFile(hdfs2, file);
            FileSystem hdfs3 = DFSTestUtil.getFileSystemAs(user2, (Configuration)conf);
            try {
                hdfs3.rename(file, new Path(tmpPath2, "renamed"));
                Assert.fail((String)"Shouldn't be able to rename someone else's file with SB on");
            }
            catch (IOException ioe) {
                Assert.assertTrue((boolean)(ioe instanceof AccessControlException));
                Assert.assertTrue((boolean)ioe.getMessage().contains("sticky bit"));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyBitPersistence() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.permissions.enabled", true);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
            FileSystem hdfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)(hdfs instanceof DistributedFileSystem));
            Path sbSet = new Path("/Housemartins");
            Path sbNotSpecified = new Path("/INXS");
            Path sbSetOff = new Path("/Easyworld");
            for (Path p : new Path[]{sbSet, sbNotSpecified, sbSetOff}) {
                hdfs.mkdirs(p);
            }
            hdfs.setPermission(sbSet, new FsPermission(1023));
            hdfs.setPermission(sbSetOff, new FsPermission(511));
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).format(false).build();
            hdfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)hdfs.exists(sbSet));
            Assert.assertTrue((boolean)hdfs.getFileStatus(sbSet).getPermission().getStickyBit());
            Assert.assertTrue((boolean)hdfs.exists(sbNotSpecified));
            Assert.assertFalse((boolean)hdfs.getFileStatus(sbNotSpecified).getPermission().getStickyBit());
            Assert.assertTrue((boolean)hdfs.exists(sbSetOff));
            Assert.assertFalse((boolean)hdfs.getFileStatus(sbSetOff).getPermission().getStickyBit());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void writeFile(FileSystem hdfs, Path p) throws IOException {
        FSDataOutputStream o = hdfs.create(p);
        o.write("some file contents".getBytes());
        o.close();
    }
}

