/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJMXGet {
    private Configuration config;
    private MiniHDFSCluster cluster;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(0xAAAAEEFL);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    @Before
    public void setUp() throws Exception {
        this.config = new HdfsConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        File data_dir;
        if (this.cluster.isClusterUp()) {
            this.cluster.shutdown();
        }
        if ((data_dir = new File(this.cluster.getDataDirectory())).exists() && !FileUtil.fullyDelete((File)data_dir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + data_dir + "'");
        }
    }

    @Test
    public void testNameNode() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).buildHDFS();
        this.cluster.waitActive();
        this.writeFile((FileSystem)this.cluster.getFileSystem(), new Path("/test1"), 2);
        JMXGet jmx = new JMXGet();
        jmx.init();
        Assert.assertEquals((long)numDatanodes, (long)Integer.parseInt(jmx.getValue("NumLiveDataNodes")));
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)Long.parseLong(jmx.getValue("CorruptBlocks")), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"FSNamesystem"));
        Assert.assertEquals((long)numDatanodes, (long)Integer.parseInt(jmx.getValue("NumOpenConnections")));
        this.cluster.shutdown();
    }

    @Test
    public void testDataNode() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).buildHDFS();
        this.cluster.waitActive();
        this.writeFile((FileSystem)this.cluster.getFileSystem(), new Path("/test"), 2);
        JMXGet jmx = new JMXGet();
        jmx.setService("DataNode");
        jmx.init();
        Assert.assertEquals((long)8192L, (long)Integer.parseInt(jmx.getValue("BytesWritten")));
        this.cluster.shutdown();
    }
}

