/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.TestDFSHAAdmin;
import org.apache.hadoop.util.Shell;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFSHAAdminMiniCluster {
    private static final Log LOG;
    private MiniHDFSCluster cluster;
    private Configuration conf;
    private DFSHAAdmin tool;
    private ByteArrayOutputStream errOutBytes = new ByteArrayOutputStream();
    private String errOutput;
    private int nn1Port;

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).buildHDFS();
        this.tool = new DFSHAAdmin();
        this.tool.setConf(this.conf);
        this.tool.setErrOut(new PrintStream(this.errOutBytes));
        this.cluster.waitActive();
        this.nn1Port = this.cluster.getNameNodePort(0);
    }

    @After
    public void shutdown() throws Exception {
        this.cluster.shutdown();
    }

    @Test
    public void testGetServiceState() throws Exception {
        Assert.assertEquals((long)0L, (long)this.runTool("-getServiceState", "nn1"));
        Assert.assertEquals((long)0L, (long)this.runTool("-getServiceState", "nn2"));
        this.cluster.transitionToActive(0);
        Assert.assertEquals((long)0L, (long)this.runTool("-getServiceState", "nn1"));
        NameNodeAdapter.enterSafeMode(this.cluster.getNameNode(0), false);
        Assert.assertEquals((long)0L, (long)this.runTool("-getServiceState", "nn1"));
    }

    @Test
    public void testStateTransition() throws Exception {
        NameNode nnode1 = this.cluster.getNameNode(0);
        Assert.assertTrue((boolean)nnode1.isStandbyState());
        Assert.assertEquals((long)0L, (long)this.runTool("-transitionToActive", "nn1"));
        Assert.assertFalse((boolean)nnode1.isStandbyState());
        Assert.assertEquals((long)0L, (long)this.runTool("-transitionToStandby", "nn1"));
        Assert.assertTrue((boolean)nnode1.isStandbyState());
        NameNode nnode2 = this.cluster.getNameNode(1);
        Assert.assertTrue((boolean)nnode2.isStandbyState());
        Assert.assertEquals((long)0L, (long)this.runTool("-transitionToActive", "nn2"));
        Assert.assertFalse((boolean)nnode2.isStandbyState());
        Assert.assertEquals((long)0L, (long)this.runTool("-transitionToStandby", "nn2"));
        Assert.assertTrue((boolean)nnode2.isStandbyState());
    }

    @Test
    public void testTryFailoverToSafeMode() throws Exception {
        this.conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf(this.conf);
        NameNodeAdapter.enterSafeMode(this.cluster.getNameNode(0), false);
        Assert.assertEquals((long)-1L, (long)this.runTool("-failover", "nn2", "nn1"));
        Assert.assertTrue((String)("Bad output: " + this.errOutput), (boolean)this.errOutput.contains("is not ready to become active: The NameNode is in safemode"));
    }

    @Test
    public void testFencer() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.runTool("-failover", "nn1", "nn2"));
        File tmpFile = File.createTempFile("testFencer", ".txt");
        tmpFile.deleteOnExit();
        if (Shell.WINDOWS) {
            this.conf.set("dfs.ha.fencing.methods", "shell(echo %target_nameserviceid%.%target_namenodeid% %target_port% %dfs_ha_namenode_id% > " + tmpFile.getAbsolutePath() + ")");
        } else {
            this.conf.set("dfs.ha.fencing.methods", "shell(echo -n $target_nameserviceid.$target_namenodeid $target_port $dfs_ha_namenode_id > " + tmpFile.getAbsolutePath() + ")");
        }
        this.tool.setConf(this.conf);
        Assert.assertEquals((long)0L, (long)this.runTool("-transitionToActive", "nn1"));
        Assert.assertEquals((long)0L, (long)this.runTool("-failover", "nn1", "nn2"));
        Assert.assertEquals((long)0L, (long)this.runTool("-ns", "minidfs-ns", "-failover", "nn2", "nn1"));
        Assert.assertEquals((Object)"", (Object)Files.toString((File)tmpFile, (Charset)Charsets.UTF_8));
        Assert.assertEquals((long)0L, (long)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        String fenceCommandOutput = Files.toString((File)tmpFile, (Charset)Charsets.UTF_8).replaceAll(" *[\r\n]+", "");
        Assert.assertEquals((Object)("minidfs-ns.nn1 " + this.nn1Port + " nn1"), (Object)fenceCommandOutput);
        tmpFile.delete();
        Assert.assertEquals((long)0L, (long)this.runTool("-failover", "nn2", "nn1", "--forceactive"));
        Assert.assertFalse((boolean)tmpFile.exists());
        this.conf.unset("dfs.ha.fencing.methods");
        this.tool.setConf(this.conf);
        Assert.assertEquals((long)-1L, (long)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        Assert.assertFalse((boolean)tmpFile.exists());
        this.conf.set("dfs.ha.fencing.methods", "foobar!");
        this.tool.setConf(this.conf);
        Assert.assertEquals((long)-1L, (long)this.runTool("-failover", "nn1", "nn2", "--forcefence"));
        Assert.assertFalse((boolean)tmpFile.exists());
        this.conf.set("dfs.ha.fencing.methods", TestDFSHAAdmin.getFencerTrueCommand());
        this.tool.setConf(this.conf);
        Assert.assertEquals((long)0L, (long)this.runTool("-failover", "--forcefence", "nn1", "nn2"));
    }

    @Test
    public void testCheckHealth() throws Exception {
        Assert.assertEquals((long)0L, (long)this.runTool("-checkHealth", "nn1"));
        Assert.assertEquals((long)0L, (long)this.runTool("-checkHealth", "nn2"));
    }

    private int runTool(String ... args) throws Exception {
        this.errOutBytes.reset();
        LOG.info((Object)("Running: DFSHAAdmin " + Joiner.on((String)" ").join((Object[])args)));
        int ret = this.tool.run(args);
        this.errOutput = new String(this.errOutBytes.toByteArray(), Charsets.UTF_8);
        LOG.info((Object)("Output:\n" + this.errOutput));
        return ret;
    }

    static {
        ((Log4JLogger)LogFactory.getLog(HAAdmin.class)).getLogger().setLevel(Level.ALL);
        LOG = LogFactory.getLog(TestDFSHAAdminMiniCluster.class);
    }
}

