/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSnapshotReplication {
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private static final int NUMDATANODE = 5;
    private static final long BLOCKSIZE = 1024L;
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    Configuration conf;
    MiniHDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;
    FSDirectory fsdir;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(5).buildHDFS();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.fsdir = this.fsn.getFSDirectory();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private void checkFileReplication(Path file, short replication, short blockReplication) throws Exception {
        short fileReplication = this.hdfs.getFileStatus(this.file1).getReplication();
        Assert.assertEquals((long)replication, (long)fileReplication);
        INode inode = this.fsdir.getINode(this.file1.toString());
        Assert.assertTrue((boolean)(inode instanceof INodeFile));
        Assert.assertEquals((long)blockReplication, (long)((INodeFile)inode).getBlockReplication());
    }

    @Test(timeout=60000L)
    public void testReplicationWithoutSnapshot() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        this.checkFileReplication(this.file1, (short)3, (short)3);
        this.hdfs.setReplication(this.file1, (short)2);
        this.checkFileReplication(this.file1, (short)2, (short)2);
    }

    INodeFile getINodeFile(Path p) throws Exception {
        String s = p.toString();
        return INodeFile.valueOf((INode)this.fsdir.getINode(s), (String)s);
    }

    private void checkSnapshotFileReplication(Path currentFile, Map<Path, Short> snapshotRepMap, short expectedBlockRep) throws Exception {
        INodeFile inodeOfCurrentFile = this.getINodeFile(currentFile);
        Assert.assertEquals((long)expectedBlockRep, (long)inodeOfCurrentFile.getBlockReplication());
        for (Path ss : snapshotRepMap.keySet()) {
            INodesInPath iip = this.fsdir.getLastINodeInPath(ss.toString());
            INodeFile ssInode = (INodeFile)iip.getLastINode();
            Assert.assertEquals((long)expectedBlockRep, (long)ssInode.getBlockReplication());
            Assert.assertEquals((long)snapshotRepMap.get(ss).shortValue(), (long)ssInode.getFileReplication(iip.getPathSnapshot()));
        }
    }

    @Test(timeout=60000L)
    public void testReplicationWithSnapshot() throws Exception {
        short fileRep;
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, fileRep, 0L);
        HashMap<Path, Short> snapshotRepMap = new HashMap<Path, Short>();
        for (fileRep = 1; fileRep < 5; fileRep = (short)(fileRep + 1)) {
            Path snapshotRoot = SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s" + fileRep);
            Path snapshot = new Path(snapshotRoot, this.file1.getName());
            Assert.assertEquals((long)fileRep, (long)this.getINodeFile(snapshot).getFileReplication());
            snapshotRepMap.put(snapshot, fileRep);
            this.hdfs.setReplication(this.file1, fileRep);
            this.checkFileReplication(this.file1, fileRep, fileRep);
            this.checkSnapshotFileReplication(this.file1, snapshotRepMap, fileRep);
        }
        this.hdfs.setReplication(this.file1, (short)3);
        this.checkFileReplication(this.file1, (short)3, (short)4);
        this.checkSnapshotFileReplication(this.file1, snapshotRepMap, (short)4);
    }

    @Test(timeout=60000L)
    public void testReplicationAfterDeletion() throws Exception {
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        HashMap<Path, Short> snapshotRepMap = new HashMap<Path, Short>();
        for (int i = 1; i <= 3; ++i) {
            Path root = SnapshotTestHelper.createSnapshot(this.hdfs, this.sub1, "s" + i);
            Path ssFile = new Path(root, this.file1.getName());
            snapshotRepMap.put(ssFile, (short)3);
        }
        this.checkFileReplication(this.file1, (short)3, (short)3);
        this.checkSnapshotFileReplication(this.file1, snapshotRepMap, (short)3);
        this.hdfs.delete(this.file1, true);
        for (Path ss : snapshotRepMap.keySet()) {
            INodeFile ssInode = this.getINodeFile(ss);
            Assert.assertEquals((long)3L, (long)ssInode.getBlockReplication());
            Assert.assertEquals((long)((Short)snapshotRepMap.get(ss)).shortValue(), (long)ssInode.getFileReplication());
        }
    }
}

