/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestNNMetricFilesInGetListingOps {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final String NN_METRICS = "NameNodeActivity";
    private MiniHDFSCluster cluster;
    private DistributedFileSystem fs;
    private Random rand = new Random();

    @Before
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(CONF).buildHDFS();
        this.cluster.waitActive();
        this.cluster.getNameNode();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void createFile(String fileName, long fileLen, short replicas) throws IOException {
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile((FileSystem)this.fs, filePath, fileLen, replicas, this.rand.nextLong());
    }

    @Test
    public void testFilesInGetListingOps() throws Exception {
        this.createFile("/tmp1/t1", 3200L, (short)3);
        this.createFile("/tmp1/t2", 3200L, (short)3);
        this.createFile("/tmp2/t1", 3200L, (short)3);
        this.createFile("/tmp2/t2", 3200L, (short)3);
        this.cluster.getNameNodeRpc().getListing("/tmp1", HdfsFileStatus.EMPTY_NAME, false);
        MetricsAsserts.assertCounter((String)"FilesInGetListingOps", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.cluster.getNameNodeRpc().getListing("/tmp2", HdfsFileStatus.EMPTY_NAME, false);
        MetricsAsserts.assertCounter((String)"FilesInGetListingOps", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
    }

    static {
        CONF.setLong("dfs.blocksize", 100L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.namenode.replication.interval", 1);
    }
}

