/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInitializeSharedEdits {
    private static final Log LOG = LogFactory.getLog(TestInitializeSharedEdits.class);
    private static final Path TEST_PATH = new Path("/test");
    private Configuration conf;
    private MiniHDFSCluster cluster;

    @Before
    public void setupCluster() throws IOException {
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.log-roll.period", 1);
        this.conf.setInt("dfs.ha.tail-edits.period", 1);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        MiniDFSNNTopology topology = MiniDFSNNTopology.simpleHATopology();
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(topology).numDataNodes(0).buildHDFS();
        this.cluster.waitActive();
        this.shutdownClusterAndRemoveSharedEditsDir();
    }

    @After
    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private void shutdownClusterAndRemoveSharedEditsDir() throws IOException {
        this.cluster.shutdownNameNode(0);
        this.cluster.shutdownNameNode(1);
        File sharedEditsDir = new File(this.cluster.getSharedEditsDir(0, 1));
        Assert.assertTrue((boolean)FileUtil.fullyDelete((File)sharedEditsDir));
    }

    private void assertCannotStartNameNodes() {
        try {
            this.cluster.restartNameNode(0, false);
            Assert.fail((String)"Should not have been able to start NN1 without shared dir");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Got expected exception", (Throwable)ioe);
            GenericTestUtils.assertExceptionContains((String)"Cannot start an HA namenode with name dirs that need recovery", (Throwable)ioe);
        }
        try {
            this.cluster.restartNameNode(1, false);
            Assert.fail((String)"Should not have been able to start NN2 without shared dir");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Got expected exception", (Throwable)ioe);
            GenericTestUtils.assertExceptionContains((String)"Cannot start an HA namenode with name dirs that need recovery", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCanStartHaNameNodes(String pathSuffix) throws ServiceFailedException, IOException, URISyntaxException, InterruptedException {
        this.cluster.restartNameNode(0, false);
        this.cluster.restartNameNode(1, true);
        this.cluster.getNameNode(0).getRpcServer().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER));
        FileSystem fs = null;
        try {
            Path newPath = new Path(TEST_PATH, pathSuffix);
            fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(newPath));
            HATestUtil.waitForStandbyToCatchUp(this.cluster.getNameNode(0), this.cluster.getNameNode(1));
            Assert.assertTrue((boolean)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), newPath.toString(), false).isDir());
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
    }

    @Test
    public void testInitializeSharedEdits() throws Exception {
        this.assertCannotStartNameNodes();
        Assert.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)this.cluster.getConfiguration(0)));
        this.assertCanStartHaNameNodes("1");
        this.shutdownClusterAndRemoveSharedEditsDir();
        this.assertCannotStartNameNodes();
        Assert.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)this.cluster.getConfiguration(0)));
        this.assertCanStartHaNameNodes("2");
    }

    @Test
    public void testFailWhenNoSharedEditsSpecified() throws Exception {
        Configuration confNoShared = new Configuration(this.conf);
        confNoShared.unset("dfs.namenode.shared.edits.dir");
        Assert.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)confNoShared, (boolean)true));
    }

    @Test
    public void testDontOverWriteExistingDir() throws IOException {
        Assert.assertFalse((boolean)NameNode.initializeSharedEdits((Configuration)this.conf, (boolean)false));
        Assert.assertTrue((boolean)NameNode.initializeSharedEdits((Configuration)this.conf, (boolean)false));
    }

    @Test
    public void testInitializeSharedEditsConfiguresGenericConfKeys() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), "localhost:1234");
        Assert.assertNull((Object)conf.get("dfs.namenode.rpc-address"));
        NameNode.initializeSharedEdits((Configuration)conf);
        Assert.assertNotNull((Object)conf.get("dfs.namenode.rpc-address"));
    }
}

