/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHAMetrics {
    private static final Log LOG = LogFactory.getLog(TestHAMetrics.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAMetrics() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", Integer.MAX_VALUE);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).buildHDFS();
        FileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            Assert.assertEquals((Object)nn0.getHAState(), (Object)"standby");
            Assert.assertTrue((0L < nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assert.assertEquals((Object)nn1.getHAState(), (Object)"standby");
            Assert.assertTrue((0L < nn1.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            cluster.transitionToActive(0);
            Assert.assertEquals((Object)"active", (Object)nn0.getHAState());
            Assert.assertEquals((long)0L, (long)nn0.getMillisSinceLastLoadedEdits());
            Assert.assertEquals((Object)"standby", (Object)nn1.getHAState());
            Assert.assertTrue((0L < nn1.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            Assert.assertEquals((Object)"standby", (Object)nn0.getHAState());
            Assert.assertTrue((0L < nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"active", (Object)nn1.getHAState());
            Assert.assertEquals((long)0L, (long)nn1.getMillisSinceLastLoadedEdits());
            Thread.sleep(2000L);
            Assert.assertTrue((2000L <= nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)nn0.getPendingDataNodeMessageCount());
            Assert.assertEquals((long)0L, (long)nn1.getPendingDataNodeMessageCount());
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            DFSTestUtil.createFile(fs, new Path("/foo"), 10L, (short)1, 1L);
            Assert.assertTrue((0 < nn0.getPendingDataNodeMessageCount() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)nn1.getPendingDataNodeMessageCount());
            long millisSinceLastLoadedEdits = nn0.getMillisSinceLastLoadedEdits();
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(1), cluster.getNameNode(0));
            Assert.assertEquals((long)0L, (long)nn0.getPendingDataNodeMessageCount());
            Assert.assertEquals((long)0L, (long)nn1.getPendingDataNodeMessageCount());
            long newMillisSinceLastLoadedEdits = nn0.getMillisSinceLastLoadedEdits();
            Assert.assertTrue((String)("expected " + millisSinceLastLoadedEdits + " > " + newMillisSinceLastLoadedEdits), (millisSinceLastLoadedEdits > newMillisSinceLastLoadedEdits ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }
}

