/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBootstrapStandby {
    private static final Log LOG = LogFactory.getLog(TestBootstrapStandby.class);
    private MiniHDFSCluster cluster;
    private NameNode nn0;

    @Before
    public void setupCluster() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setHttpPort(10001)).addNN(new MiniDFSNNTopology.NNConf("nn2").setHttpPort(10002)));
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).buildHDFS();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.cluster.transitionToActive(0);
        this.cluster.shutdownNameNode(1);
    }

    @After
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSuccessfulBaseCase() throws Exception {
        this.removeStandbyNameDirs();
        try {
            this.cluster.restartNameNode(1);
            Assert.fail((String)"Did not throw");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot start an HA namenode with name dirs that need recovery", (Throwable)ioe);
        }
        int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)this.cluster.getConfiguration(1));
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
        this.cluster.restartNameNode(1);
    }

    @Test
    public void testDownloadingLaterCheckpoint() throws Exception {
        this.nn0.getRpcServer().rollEditLog();
        this.nn0.getRpcServer().rollEditLog();
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        long expectedCheckpointTxId = NameNodeAdapter.getNamesystem(this.nn0).getFSImage().getMostRecentCheckpointTxId();
        Assert.assertEquals((long)6L, (long)expectedCheckpointTxId);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)this.cluster.getConfiguration(1));
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)((int)expectedCheckpointTxId)));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
        this.cluster.restartNameNode(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedEditsMissingLogs() throws Exception {
        this.removeStandbyNameDirs();
        CheckpointSignature sig = this.nn0.getRpcServer().rollEditLog();
        Assert.assertEquals((long)3L, (long)sig.getCurSegmentTxId());
        URI editsUri = this.cluster.getSharedEditsDir(0, 1);
        File editsDir = new File(editsUri);
        File editsSegment = new File(new File(editsDir, "current"), NNStorage.getFinalizedEditsFileName((long)1L, (long)2L));
        GenericTestUtils.assertExists((File)editsSegment);
        Assert.assertTrue((boolean)editsSegment.delete());
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Log)LogFactory.getLog(BootstrapStandby.class));
        try {
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)this.cluster.getConfiguration(1));
            Assert.assertEquals((long)6L, (long)rc);
        }
        finally {
            logs.stopCapturing();
        }
        GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"FATAL.*Unable to read transaction ids 1-3 from the configured shared");
    }

    @Test
    public void testStandbyDirsAlreadyExist() throws Exception {
        int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)this.cluster.getConfiguration(1));
        Assert.assertEquals((long)5L, (long)rc);
        rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)this.cluster.getConfiguration(1));
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test(timeout=30000L)
    public void testOtherNodeNotActive() throws Exception {
        this.cluster.transitionToStandby(0);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)this.cluster.getConfiguration(1));
        Assert.assertEquals((long)0L, (long)rc);
    }

    private void removeStandbyNameDirs() {
        for (URI u : this.cluster.getNameDirs(1)) {
            Assert.assertTrue((boolean)u.getScheme().equals("file"));
            File dir = new File(u.getPath());
            LOG.info((Object)("Removing standby dir " + dir));
            Assert.assertTrue((boolean)FileUtil.fullyDelete((File)dir));
        }
    }
}

