/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestListCorruptFileBlocks {
    static Log LOG = NameNode.stateChangeLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListCorruptFilesCorruptedBlock() throws Exception {
        MiniDFSCluster cluster = null;
        Random random = new Random();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testCorruptFilesCorruptedBlock").setNumFiles(2).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat10");
            NameNode namenode = ((MiniHDFSCluster)cluster).getNameNode();
            Collection badFiles = namenode.getNamesystem().listCorruptFileBlocks("/", null);
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " corrupt files. Expecting None."), (badFiles.size() == 0 ? 1 : 0) != 0);
            String bpid = ((MiniHDFSCluster)cluster).getNamesystem().getBlockPoolId();
            File storageDir = ((MiniHDFSCluster)cluster).getInstanceStorageDir(0, 1);
            File data_dir = MiniHDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            Assert.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            for (int idx = 0; idx < blocks.length; ++idx) {
                if (!blocks[idx].getName().startsWith("blk_") || !blocks[idx].getName().endsWith(".meta")) continue;
                RandomAccessFile file = new RandomAccessFile(blocks[idx], "rw");
                FileChannel channel = file.getChannel();
                long position = channel.size() - 2L;
                int length = 2;
                byte[] buffer = new byte[length];
                random.nextBytes(buffer);
                channel.write(ByteBuffer.wrap(buffer), position);
                file.close();
                LOG.info((Object)("Deliberately corrupting file " + blocks[idx].getName() + " at offset " + position + " length " + length));
                try {
                    util.checkFiles((FileSystem)fs, "/srcdat10");
                }
                catch (BlockMissingException e) {
                    System.out.println("Received BlockMissingException as expected.");
                }
                catch (IOException e) {
                    Assert.assertTrue((String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e), (boolean)false);
                }
                break;
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info((Object)("Namenode has bad files. " + badFiles.size()));
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."), (badFiles.size() == 1 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/srcdat10");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testListCorruptFileBlocksInSafeMode() throws Exception {
        MiniDFSCluster cluster = null;
        Random random = new Random();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            conf.setFloat("dfs.namenode.safemode.threshold-pct", 1.5f);
            conf.setFloat("dfs.namenode.replqueue.threshold-pct", 0.0f);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).waitSafeMode(false).buildHDFS();
            ((MiniHDFSCluster)cluster).getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testListCorruptFileBlocksInSafeMode").setNumFiles(2).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat10");
            Collection badFiles = ((MiniHDFSCluster)cluster).getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " corrupt files. Expecting None."), (badFiles.size() == 0 ? 1 : 0) != 0);
            File storageDir = ((MiniHDFSCluster)cluster).getInstanceStorageDir(0, 0);
            File data_dir = MiniHDFSCluster.getFinalizedDir(storageDir, ((MiniHDFSCluster)cluster).getNamesystem().getBlockPoolId());
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            Assert.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            for (int idx = 0; idx < blocks.length; ++idx) {
                if (!blocks[idx].getName().startsWith("blk_") || !blocks[idx].getName().endsWith(".meta")) continue;
                RandomAccessFile file = new RandomAccessFile(blocks[idx], "rw");
                FileChannel channel = file.getChannel();
                long position = channel.size() - 2L;
                int length = 2;
                byte[] buffer = new byte[length];
                random.nextBytes(buffer);
                channel.write(ByteBuffer.wrap(buffer), position);
                file.close();
                LOG.info((Object)("Deliberately corrupting file " + blocks[idx].getName() + " at offset " + position + " length " + length));
                try {
                    util.checkFiles((FileSystem)fs, "/srcdat10");
                }
                catch (BlockMissingException e) {
                    System.out.println("Received BlockMissingException as expected.");
                }
                catch (IOException e) {
                    Assert.assertTrue((String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e), (boolean)false);
                }
                break;
            }
            badFiles = ((MiniHDFSCluster)cluster).getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info((Object)("Namenode has bad files. " + badFiles.size()));
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."), (badFiles.size() == 1 ? 1 : 0) != 0);
            ((MiniHDFSCluster)cluster).restartNameNode(0);
            fs = ((MiniHDFSCluster)cluster).getFileSystem();
            while (!((MiniHDFSCluster)cluster).getNameNode().namesystem.isPopulatingReplQueues()) {
                try {
                    LOG.info((Object)"waiting for replication queues");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {}
            }
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assert.assertTrue((String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e), (boolean)false);
            }
            badFiles = ((MiniHDFSCluster)cluster).getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info((Object)("Namenode has bad files. " + badFiles.size()));
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."), (badFiles.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Namenode is not in safe mode", (boolean)((MiniHDFSCluster)cluster).getNameNode().isInSafeMode());
            ((MiniHDFSCluster)cluster).getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            util.cleanup((FileSystem)fs, "/srcdat10");
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testlistCorruptFileBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniHDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).buildHDFS();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData");
            NameNode namenode = cluster.getNameNode();
            Collection corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
            int numCorrupt = corruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniHDFSCluster.getFinalizedDir(storageDir, bpid);
                    File[] blocks = data_dir.listFiles();
                    if (blocks == null) continue;
                    for (int idx = 0; idx < blocks.length; ++idx) {
                        if (!blocks[idx].getName().startsWith("blk_")) continue;
                        LOG.info((Object)("Deliberately removing file " + blocks[idx].getName()));
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
                    }
                }
            }
            int count = 0;
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
            numCorrupt = corruptFileBlocks.size();
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
                numCorrupt = corruptFileBlocks.size();
                if (++count <= 30) continue;
            }
            LOG.info((Object)("Namenode has bad files. " + numCorrupt));
            Assert.assertTrue((numCorrupt == 3 ? 1 : 0) != 0);
            FSNamesystem.CorruptFileBlockInfo[] cfb = corruptFileBlocks.toArray(new FSNamesystem.CorruptFileBlockInfo[0]);
            String[] cookie = new String[]{"1"};
            Collection nextCorruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", cookie);
            FSNamesystem.CorruptFileBlockInfo[] ncfb = nextCorruptFileBlocks.toArray(new FSNamesystem.CorruptFileBlockInfo[0]);
            numCorrupt = nextCorruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ncfb[0].block.getBlockName().equalsIgnoreCase(cfb[1].block.getBlockName()));
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", cookie);
            numCorrupt = corruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            util.createFiles((FileSystem)fs, "/goodData");
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/goodData", null);
            numCorrupt = corruptFileBlocks.size();
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private int countPaths(RemoteIterator<Path> iter) throws IOException {
        int i = 0;
        while (iter.hasNext()) {
            LOG.info((Object)("PATH: " + ((Path)iter.next()).toUri().getPath()));
            ++i;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testlistCorruptFileBlocksDFS() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniHDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).buildHDFS();
            cluster.waitActive();
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData");
            RemoteIterator corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
            int numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            Assert.assertTrue((numCorrupt == 0 ? 1 : 0) != 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 2; ++i) {
                File storageDir = cluster.getInstanceStorageDir(0, i);
                File data_dir = MiniHDFSCluster.getFinalizedDir(storageDir, bpid);
                File[] blocks = data_dir.listFiles();
                if (blocks == null) continue;
                for (int idx = 0; idx < blocks.length; ++idx) {
                    if (!blocks[idx].getName().startsWith("blk_")) continue;
                    LOG.info((Object)("Deliberately removing file " + blocks[idx].getName()));
                    Assert.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
                }
            }
            int count = 0;
            corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
            numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
                numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
                if (++count <= 30) continue;
            }
            LOG.info((Object)("Namenode has bad files. " + numCorrupt));
            Assert.assertTrue((numCorrupt == 3 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxCorruptFiles() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 15);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
            DistributedFileSystem fs = ((MiniHDFSCluster)cluster).getFileSystem();
            int maxCorruptFileBlocks = 100;
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testMaxCorruptFiles").setNumFiles(300).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat2", (short)1);
            util.waitReplication((FileSystem)fs, "/srcdat2", (short)1);
            NameNode namenode = ((MiniHDFSCluster)cluster).getNameNode();
            Collection badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " corrupt files. Expecting none."), (badFiles.size() == 0 ? 1 : 0) != 0);
            String bpid = ((MiniHDFSCluster)cluster).getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = ((MiniHDFSCluster)cluster).getInstanceStorageDir(i, j);
                    File data_dir = MiniHDFSCluster.getFinalizedDir(storageDir, bpid);
                    LOG.info((Object)("Removing files from " + data_dir));
                    File[] blocks = data_dir.listFiles();
                    if (blocks == null) continue;
                    for (int idx = 0; idx < blocks.length; ++idx) {
                        if (!blocks[idx].getName().startsWith("blk_")) continue;
                        Assert.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
                    }
                }
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            while (badFiles.size() < 100) {
                LOG.info((Object)("# of corrupt files is: " + badFiles.size()));
                Thread.sleep(10000L);
                badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            LOG.info((Object)("Namenode has bad files. " + badFiles.size()));
            Assert.assertTrue((String)("Namenode has " + badFiles.size() + " bad files. Expecting " + 100 + "."), (badFiles.size() == 100 ? 1 : 0) != 0);
            CorruptFileBlockIterator iter = (CorruptFileBlockIterator)fs.listCorruptFileBlocks(new Path("/srcdat2"));
            int corruptPaths = this.countPaths((RemoteIterator<Path>)iter);
            Assert.assertTrue((String)("Expected more than 100 corrupt file blocks but got " + corruptPaths), (corruptPaths > 100 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Iterator should have made more than 1 call but made " + iter.getCallsMade()), (iter.getCallsMade() > 1 ? 1 : 0) != 0);
            util.cleanup((FileSystem)fs, "/srcdat2");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

