/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFavoredNodesEndToEnd {
    private static MiniHDFSCluster cluster;
    private static Configuration conf;
    private static final int NUM_DATA_NODES = 10;
    private static final int NUM_FILES = 10;
    private static final byte[] SOME_BYTES;
    private static DistributedFileSystem dfs;
    private static ArrayList<DataNode> datanodes;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(10).buildHDFS();
        cluster.waitClusterUp();
        dfs = cluster.getFileSystem();
        datanodes = cluster.getDataNodes();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=180000L)
    public void testFavoredNodesEndToEnd() throws Exception {
        for (int i = 0; i < 10; ++i) {
            BlockLocation[] locations;
            Random rand = new Random(System.currentTimeMillis() + (long)i);
            InetSocketAddress[] datanode = this.getDatanodes(rand);
            Path p = new Path("/filename" + i);
            HdfsDataOutputStream out = dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, datanode);
            out.write(SOME_BYTES);
            out.close();
            for (BlockLocation loc : locations = this.getBlockLocations(p)) {
                String[] hosts = loc.getNames();
                String[] hosts1 = this.getStringForInetSocketAddrs(datanode);
                Assert.assertTrue((boolean)this.compareNodes(hosts, hosts1));
            }
        }
    }

    @Test(timeout=180000L)
    public void testWhenFavoredNodesNotPresent() throws Exception {
        Random rand = new Random(System.currentTimeMillis());
        InetSocketAddress[] arbitraryAddrs = new InetSocketAddress[3];
        for (int i = 0; i < 3; ++i) {
            arbitraryAddrs[i] = this.getArbitraryLocalHostAddr();
        }
        Path p = new Path("/filename-foo-bar");
        HdfsDataOutputStream out = dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, arbitraryAddrs);
        out.write(SOME_BYTES);
        out.close();
        this.getBlockLocations(p);
    }

    @Test(timeout=180000L)
    public void testWhenSomeNodesAreNotGood() throws Exception {
        DatanodeDescriptor d = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanodeByXferAddr(datanodes.get(0).getXferAddress().getAddress().getHostAddress(), datanodes.get(0).getXferAddress().getPort());
        d.setDecommissioned();
        InetSocketAddress[] addrs = new InetSocketAddress[3];
        for (int i = 0; i < 3; ++i) {
            addrs[i] = datanodes.get(i).getXferAddress();
        }
        Path p = new Path("/filename-foo-bar-baz");
        HdfsDataOutputStream out = dfs.create(p, FsPermission.getDefault(), true, 4096, (short)3, 4096L, null, addrs);
        out.write(SOME_BYTES);
        out.close();
        d.stopDecommission();
        BlockLocation[] locations = this.getBlockLocations(p);
        String datanode0 = datanodes.get(0).getXferAddress().getAddress().getHostAddress() + ":" + datanodes.get(0).getXferAddress().getPort();
        for (int i = 0; i < 3; ++i) {
            if (!locations[0].getNames()[i].equals(datanode0)) continue;
            Assert.fail((String)(datanode0 + " not supposed to be a replica for the block"));
        }
    }

    private BlockLocation[] getBlockLocations(Path p) throws Exception {
        DFSTestUtil.waitReplication((FileSystem)dfs, p, (short)3);
        BlockLocation[] locations = dfs.getClient().getBlockLocations(p.toUri().getPath(), 0L, Long.MAX_VALUE);
        Assert.assertTrue((locations.length == 1 && locations[0].getHosts().length == 3 ? 1 : 0) != 0);
        return locations;
    }

    private String[] getStringForInetSocketAddrs(InetSocketAddress[] datanode) {
        String[] strs = new String[datanode.length];
        for (int i = 0; i < datanode.length; ++i) {
            strs[i] = datanode[i].getAddress().getHostAddress() + ":" + datanode[i].getPort();
        }
        return strs;
    }

    private boolean compareNodes(String[] dnList1, String[] dnList2) {
        for (int i = 0; i < dnList1.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < dnList2.length; ++j) {
                if (!dnList1[i].equals(dnList2[j])) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            Assert.fail((String)(dnList1[i] + " not a favored node"));
        }
        return true;
    }

    private InetSocketAddress[] getDatanodes(Random rand) {
        int idx3;
        int idx2;
        int idx1 = rand.nextInt(10);
        while (idx1 == (idx2 = rand.nextInt(10))) {
        }
        while (idx2 == (idx3 = rand.nextInt(10)) || idx1 == idx3) {
        }
        InetSocketAddress[] addrs = new InetSocketAddress[]{datanodes.get(idx1).getXferAddress(), datanodes.get(idx2).getXferAddress(), datanodes.get(idx3).getXferAddress()};
        return addrs;
    }

    private InetSocketAddress getArbitraryLocalHostAddr() throws UnknownHostException {
        boolean conflict;
        Random rand = new Random(System.currentTimeMillis());
        int port = rand.nextInt(65535);
        do {
            conflict = false;
            for (DataNode d : datanodes) {
                if (d.getXferAddress().getPort() != port) continue;
                port = rand.nextInt(65535);
                conflict = true;
            }
        } while (conflict);
        return new InetSocketAddress(InetAddress.getLocalHost(), port);
    }

    static {
        SOME_BYTES = new String("foo").getBytes();
    }
}

