/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestCommitBlockSynchronization {
    private static final long blockId = 100L;
    private static final long length = 200L;
    private static final long genStamp = 300L;

    private FSNamesystem makeNameSystemSpy(Block block, INodeFileUnderConstruction file) throws IOException {
        Configuration conf = new Configuration();
        FSImage image = new FSImage(conf);
        DatanodeDescriptor[] targets = new DatanodeDescriptor[]{};
        FSNamesystem namesystem = new FSNamesystem(conf, image);
        FSNamesystem namesystemSpy = (FSNamesystem)Mockito.spy((Object)namesystem);
        BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(block, 1, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
        blockInfo.setBlockCollection((BlockCollection)file);
        blockInfo.setGenerationStamp(300L);
        blockInfo.initializeBlockRecovery(300L);
        ((INodeFileUnderConstruction)Mockito.doReturn((Object)true).when((Object)file)).removeLastBlock((Block)Matchers.any(Block.class));
        ((FSNamesystem)Mockito.doReturn((Object)blockInfo).when((Object)namesystemSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        ((FSNamesystem)Mockito.doReturn((Object)"").when((Object)namesystemSpy)).closeFileCommitBlocks((INodeFileUnderConstruction)Matchers.any(INodeFileUnderConstruction.class), (BlockInfo)Matchers.any(BlockInfo.class));
        ((FSNamesystem)Mockito.doReturn((Object)"").when((Object)namesystemSpy)).persistBlocks((INodeFileUnderConstruction)Matchers.any(INodeFileUnderConstruction.class), Matchers.anyBoolean());
        ((FSNamesystem)Mockito.doReturn((Object)Mockito.mock(FSEditLog.class)).when((Object)namesystemSpy)).getEditLog();
        return namesystemSpy;
    }

    @Test
    public void testCommitBlockSynchronization() throws IOException {
        INodeFileUnderConstruction file = (INodeFileUnderConstruction)Mockito.mock(INodeFileUnderConstruction.class);
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
        BlockInfo completedBlockInfo = new BlockInfo(block, 1);
        completedBlockInfo.setBlockCollection((BlockCollection)file);
        completedBlockInfo.setGenerationStamp(300L);
        ((FSNamesystem)Mockito.doReturn((Object)completedBlockInfo).when((Object)namesystemSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
    }

    @Test
    public void testCommitBlockSynchronization2() throws IOException {
        INodeFileUnderConstruction file = (INodeFileUnderConstruction)Mockito.mock(INodeFileUnderConstruction.class);
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, false, newTargets, null);
        try {
            namesystemSpy.commitBlockSynchronization(lastBlock, 299L, 200L, false, false, newTargets, null);
            Assert.fail((String)"Failed to get expected IOException on generation stamp/recovery ID mismatch");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Test
    public void testCommitBlockSynchronizationWithDelete() throws IOException {
        INodeFileUnderConstruction file = (INodeFileUnderConstruction)Mockito.mock(INodeFileUnderConstruction.class);
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, true, newTargets, null);
        ((INodeFileUnderConstruction)Mockito.doReturn((Object)false).when((Object)file)).removeLastBlock((Block)Matchers.any(Block.class));
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, false, true, newTargets, null);
    }

    @Test
    public void testCommitBlockSynchronizationWithClose() throws IOException {
        INodeFileUnderConstruction file = (INodeFileUnderConstruction)Mockito.mock(INodeFileUnderConstruction.class);
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{};
        ExtendedBlock lastBlock = new ExtendedBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
        BlockInfo completedBlockInfo = new BlockInfo(block, 1);
        completedBlockInfo.setBlockCollection((BlockCollection)file);
        completedBlockInfo.setGenerationStamp(300L);
        ((FSNamesystem)Mockito.doReturn((Object)completedBlockInfo).when((Object)namesystemSpy)).getStoredBlock((Block)Matchers.any(Block.class));
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
    }

    @Test
    public void testCommitBlockSynchronizationWithCloseAndNonExistantTarget() throws IOException {
        INodeFileUnderConstruction file = (INodeFileUnderConstruction)Mockito.mock(INodeFileUnderConstruction.class);
        Block block = new Block(100L, 200L, 300L);
        FSNamesystem namesystemSpy = this.makeNameSystemSpy(block, file);
        DatanodeID[] newTargets = new DatanodeID[]{new DatanodeID("0.0.0.0", "nonexistantHost", "1", 0, 0, 0, 0)};
        ExtendedBlock lastBlock = new ExtendedBlock();
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
        namesystemSpy.commitBlockSynchronization(lastBlock, 300L, 200L, true, false, newTargets, null);
    }
}

