/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestMultipleNNDataBlockScanner {
    private static final Log LOG = LogFactory.getLog(TestMultipleNNDataBlockScanner.class);
    Configuration conf;
    MiniHDFSCluster cluster = null;
    String[] bpids = new String[3];
    FileSystem[] fs = new FileSystem[3];

    public void setUp() throws IOException {
        int i;
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 100);
        this.conf.setInt("dfs.bytes-per-checksum", 100);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).buildHDFS();
        for (i = 0; i < 3; ++i) {
            this.cluster.waitActive(i);
        }
        for (i = 0; i < 3; ++i) {
            this.bpids[i] = this.cluster.getNamesystem(i).getBlockPoolId();
        }
        for (i = 0; i < 3; ++i) {
            this.fs[i] = this.cluster.getFileSystem(i);
        }
        for (i = 0; i < 3; ++i) {
            DFSTestUtil.createFile(this.fs[i], new Path("file1"), 1000L, (short)1, 0L);
            DFSTestUtil.createFile(this.fs[i], new Path("file2"), 1000L, (short)1, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testDataBlockScanner() throws IOException, InterruptedException {
        this.setUp();
        try {
            DataNode dn = this.cluster.getDataNodes().get(0);
            for (int i = 0; i < 3; ++i) {
                long blocksScanned = 0L;
                while (blocksScanned != 20L) {
                    blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(this.bpids[i]);
                    LOG.info((Object)("Waiting for all blocks to be scanned for bpid=" + this.bpids[i] + "; Scanned so far=" + blocksScanned));
                    Thread.sleep(5000L);
                }
            }
            StringBuilder buffer = new StringBuilder();
            dn.blockScanner.printBlockReport(buffer, false);
            LOG.info((Object)("Block Report\n" + buffer.toString()));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testBlockScannerAfterRefresh() throws IOException, InterruptedException {
        this.setUp();
        try {
            Configuration dnConf = this.cluster.getDataNodes().get(0).getConf();
            HdfsConfiguration conf = new HdfsConfiguration(dnConf);
            StringBuilder namenodesBuilder = new StringBuilder();
            String bpidToShutdown = this.cluster.getNamesystem(2).getBlockPoolId();
            for (int i = 0; i < 2; ++i) {
                String nsId = DFSUtil.getNamenodeNameServiceId((Configuration)this.cluster.getConfiguration(i));
                namenodesBuilder.append(nsId);
                namenodesBuilder.append(",");
            }
            conf.set("dfs.nameservices", namenodesBuilder.toString());
            DataNode dn = this.cluster.getDataNodes().get(0);
            dn.refreshNamenodes((Configuration)conf);
            try {
                while (true) {
                    dn.blockScanner.getBlocksScannedInLastRun(bpidToShutdown);
                    Thread.sleep(1000L);
                }
            }
            catch (IOException ex) {
                LOG.info((Object)ex.getMessage());
                namenodesBuilder.append(DFSUtil.getNamenodeNameServiceId((Configuration)this.cluster.getConfiguration(2)));
                conf.set("dfs.nameservices", namenodesBuilder.toString());
                dn.refreshNamenodes((Configuration)conf);
                for (int i = 0; i < 3; ++i) {
                    long blocksScanned = 0L;
                    while (blocksScanned != 20L) {
                        blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(this.bpids[i]);
                        LOG.info((Object)("Waiting for all blocks to be scanned for bpid=" + this.bpids[i] + "; Scanned so far=" + blocksScanned));
                        Thread.sleep(5000L);
                    }
                }
                this.cluster.shutdown();
            }
        }
        catch (Throwable throwable) {
            this.cluster.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testBlockScannerAfterRestart() throws IOException, InterruptedException {
        this.setUp();
        try {
            this.cluster.restartDataNode(0);
            this.cluster.waitActive();
            DataNode dn = this.cluster.getDataNodes().get(0);
            for (int i = 0; i < 3; ++i) {
                while (!dn.blockScanner.isInitialized(this.bpids[i])) {
                    Thread.sleep(1000L);
                }
                long blocksScanned = 0L;
                while (blocksScanned != 20L) {
                    if (dn.blockScanner != null) {
                        blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(this.bpids[i]);
                        LOG.info((Object)("Waiting for all blocks to be scanned for bpid=" + this.bpids[i] + "; Scanned so far=" + blocksScanned));
                    }
                    Thread.sleep(5000L);
                }
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void test2NNBlockRescanInterval() throws IOException {
        ((Log4JLogger)BlockPoolSliceScanner.LOG).getLogger().setLevel(Level.ALL);
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).buildHDFS();
        try {
            DistributedFileSystem fs = this.cluster.getFileSystem(1);
            Path file2 = new Path("/test/testBlockScanInterval");
            DFSTestUtil.createFile((FileSystem)fs, file2, 30L, (short)1, 0L);
            fs = this.cluster.getFileSystem(0);
            Path file1 = new Path("/test/testBlockScanInterval");
            DFSTestUtil.createFile((FileSystem)fs, file1, 30L, (short)1, 0L);
            for (int i = 0; i < 8; ++i) {
                LOG.info((Object)"Verifying that the blockscanner scans exactly once");
                this.waitAndScanBlocks(1L, 1L);
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testBlockRescanInterval() throws IOException {
        ((Log4JLogger)BlockPoolSliceScanner.LOG).getLogger().setLevel(Level.ALL);
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
        try {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path file1 = new Path("/test/testBlockScanInterval");
            DFSTestUtil.createFile((FileSystem)fs, file1, 30L, (short)1, 0L);
            for (int i = 0; i < 4; ++i) {
                LOG.info((Object)"Verifying that the blockscanner scans exactly once");
                this.waitAndScanBlocks(1L, 1L);
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    void waitAndScanBlocks(long scansLastRun, long scansTotal) throws IOException {
        long total;
        long blocksScanned;
        int n = 5;
        String bpid = this.cluster.getNamesystem(0).getBlockPoolId();
        DataNode dn = this.cluster.getDataNodes().get(0);
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("Interrupted: " + e));
            }
            blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(bpid);
            total = dn.blockScanner.getTotalScans(bpid);
            LOG.info((Object)("bpid = " + bpid + " blocksScanned = " + blocksScanned + " total=" + total));
        } while (n-- > 0 && (blocksScanned != scansLastRun || scansTotal != total));
        junit.framework.Assert.assertEquals((long)scansTotal, (long)total);
        junit.framework.Assert.assertEquals((long)scansLastRun, (long)blocksScanned);
    }
}

