/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Daemon;
import org.junit.Assert;

public class BlockManagerTestUtil {
    public static void setNodeReplicationLimit(BlockManager blockManager, int limit) {
        blockManager.maxReplicationStreams = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatanodeDescriptor getDatanode(FSNamesystem ns, String storageID) {
        ns.readLock();
        try {
            DatanodeDescriptor datanodeDescriptor = ns.getBlockManager().getDatanodeManager().getDatanode(storageID);
            return datanodeDescriptor;
        }
        finally {
            ns.readUnlock();
        }
    }

    public static void updateState(BlockManager blockManager) {
        blockManager.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getReplicaInfo(FSNamesystem namesystem, Block b) {
        BlockManager bm = namesystem.getBlockManager();
        namesystem.readLock();
        try {
            int[] nArray = new int[]{BlockManagerTestUtil.getNumberOfRacks(bm, b), bm.countNodes(b).liveReplicas(), bm.neededReplications.contains(b) ? 1 : 0};
            return nArray;
        }
        finally {
            namesystem.readUnlock();
        }
    }

    private static int getNumberOfRacks(BlockManager blockManager, Block b) {
        HashSet<String> rackSet = new HashSet<String>(0);
        Collection corruptNodes = BlockManagerTestUtil.getCorruptReplicas(blockManager).getNodes(b);
        Iterator it = blockManager.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            String rackName;
            DatanodeDescriptor cur = (DatanodeDescriptor)it.next();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur) || rackSet.contains(rackName = cur.getNetworkLocation())) continue;
            rackSet.add(rackName);
        }
        return rackSet.size();
    }

    public static Daemon getReplicationThread(BlockManager blockManager) {
        return blockManager.replicationThread;
    }

    public static void stopReplicationThread(BlockManager blockManager) throws IOException {
        blockManager.enableRMTerminationForTesting();
        blockManager.replicationThread.interrupt();
        try {
            blockManager.replicationThread.join();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while trying to stop ReplicationMonitor");
        }
    }

    public static CorruptReplicasMap getCorruptReplicas(BlockManager blockManager) {
        return blockManager.corruptReplicas;
    }

    public static int getComputedDatanodeWork(BlockManager blockManager) throws IOException {
        return blockManager.computeDatanodeWork();
    }

    public static int computeInvalidationWork(BlockManager bm) {
        return bm.computeInvalidateWork(Integer.MAX_VALUE);
    }

    public static int computeAllPendingWork(BlockManager bm) {
        int work = BlockManagerTestUtil.computeInvalidationWork(bm);
        return work += bm.computeReplicationWork(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noticeDeadDatanode(NameNode nn, String dnName) {
        FSNamesystem namesystem = nn.getNamesystem();
        namesystem.writeLock();
        try {
            DatanodeManager dnm = namesystem.getBlockManager().getDatanodeManager();
            HeartbeatManager hbm = dnm.getHeartbeatManager();
            DatanodeDescriptor[] dnds = hbm.getDatanodes();
            DatanodeDescriptor theDND = null;
            for (DatanodeDescriptor dnd : dnds) {
                if (!dnd.getXferAddr().equals(dnName)) continue;
                theDND = dnd;
            }
            Assert.assertNotNull((String)("Could not find DN with name: " + dnName), theDND);
            HeartbeatManager heartbeatManager = hbm;
            synchronized (heartbeatManager) {
                theDND.setLastUpdate(0L);
                hbm.heartbeatCheck();
            }
        }
        finally {
            namesystem.writeUnlock();
        }
    }

    public static void setWritingPrefersLocalNode(BlockManager bm, boolean prefer) {
        BlockPlacementPolicy bpp = bm.getBlockPlacementPolicy();
        Preconditions.checkState((boolean)(bpp instanceof BlockPlacementPolicyDefault), (String)"Must use default policy, got %s", (Object[])new Object[]{bpp.getClass()});
        ((BlockPlacementPolicyDefault)bpp).setPreferLocalNode(prefer);
    }

    public static void checkHeartbeat(BlockManager bm) {
        bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }
}

