/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.util.ThreadUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestModTime {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int numDatanodes = 6;
    Random myrand = new Random();
    Path hostsFile;
    Path excludeFile;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private void printDatanodeReport(DatanodeInfo[] info) {
        System.out.println("-------------------------------------------------");
        for (int i = 0; i < info.length; ++i) {
            System.out.println(info[i].getDatanodeReport());
            System.out.println();
        }
    }

    @Test
    public void testModTime() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(6).buildHDFS();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)6L, (long)info.length);
        DistributedFileSystem fileSys = cluster.getFileSystem();
        int replicas = 5;
        Assert.assertTrue((boolean)(fileSys instanceof DistributedFileSystem));
        try {
            System.out.println("Creating testdir1 and testdir1/test1.dat.");
            Path dir1 = new Path("testdir1");
            Path file1 = new Path(dir1, "test1.dat");
            this.writeFile((FileSystem)fileSys, file1, replicas);
            FileStatus stat = fileSys.getFileStatus(file1);
            long mtime1 = stat.getModificationTime();
            Assert.assertTrue((mtime1 != 0L ? 1 : 0) != 0);
            stat = fileSys.getFileStatus(dir1);
            long mdir1 = stat.getModificationTime();
            System.out.println("Creating testdir1/test2.dat.");
            Path file2 = new Path(dir1, "test2.dat");
            this.writeFile((FileSystem)fileSys, file2, replicas);
            stat = fileSys.getFileStatus(file2);
            stat = fileSys.getFileStatus(dir1);
            Assert.assertTrue((stat.getModificationTime() >= mdir1 ? 1 : 0) != 0);
            mdir1 = stat.getModificationTime();
            Path dir2 = fileSys.makeQualified(new Path("testdir2/"));
            System.out.println("Creating testdir2 " + dir2);
            Assert.assertTrue((boolean)fileSys.mkdirs(dir2));
            stat = fileSys.getFileStatus(dir2);
            long mdir2 = stat.getModificationTime();
            Path newfile = new Path(dir2, "testnew.dat");
            System.out.println("Moving " + file1 + " to " + newfile);
            fileSys.rename(file1, newfile);
            stat = fileSys.getFileStatus(newfile);
            Assert.assertTrue((stat.getModificationTime() == mtime1 ? 1 : 0) != 0);
            stat = fileSys.getFileStatus(dir1);
            Assert.assertTrue((stat.getModificationTime() != mdir1 ? 1 : 0) != 0);
            mdir1 = stat.getModificationTime();
            stat = fileSys.getFileStatus(dir2);
            Assert.assertTrue((stat.getModificationTime() != mdir2 ? 1 : 0) != 0);
            mdir2 = stat.getModificationTime();
            System.out.println("Deleting testdir2/testnew.dat.");
            Assert.assertTrue((boolean)fileSys.delete(newfile, true));
            stat = fileSys.getFileStatus(dir1);
            Assert.assertTrue((stat.getModificationTime() == mdir1 ? 1 : 0) != 0);
            stat = fileSys.getFileStatus(dir2);
            Assert.assertTrue((stat.getModificationTime() != mdir2 ? 1 : 0) != 0);
            mdir2 = stat.getModificationTime();
            this.cleanupFile((FileSystem)fileSys, file2);
            this.cleanupFile((FileSystem)fileSys, dir1);
            this.cleanupFile((FileSystem)fileSys, dir2);
        }
        catch (IOException e) {
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            this.printDatanodeReport(info);
            throw e;
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModTimePersistsAfterRestart() throws IOException {
        long sleepTime = 10L;
        MiniHDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
            fs = cluster.getFileSystem();
            Path testPath = new Path("/test");
            FSDataOutputStream out = fs.create(testPath);
            long initialModTime = fs.getFileStatus(testPath).getModificationTime();
            Assert.assertTrue((initialModTime > 0L ? 1 : 0) != 0);
            ThreadUtil.sleepAtLeastIgnoreInterrupts((long)10L);
            out.close();
            long modTimeAfterClose = fs.getFileStatus(testPath).getModificationTime();
            Assert.assertTrue((modTimeAfterClose >= initialModTime + 10L ? 1 : 0) != 0);
            cluster.restartNameNode();
            long modTimeAfterRestart = fs.getFileStatus(testPath).getModificationTime();
            Assert.assertEquals((long)modTimeAfterClose, (long)modTimeAfterRestart);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestModTime().testModTime();
    }
}

